/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.test.aop.proxy;

import java.io.File;
import java.security.AccessController;
import java.security.PrivilegedExceptionAction;
import org.jboss.test.aop.proxy.ProxyFileCreator;
import org.jboss.test.aop.proxy.ProxyFileCreatorDelegate;

public class InProcessProxyFileCreator
implements ProxyFileCreator {
    ProxyFileCreatorDelegate delegate;

    public InProcessProxyFileCreator(ProxyFileCreatorDelegate delegate) {
        this.delegate = delegate;
    }

    public File createProxyFile() throws Exception {
        File proxyFile;
        try {
            proxyFile = AccessController.doPrivileged(new PrivilegedExceptionAction<File>(){

                @Override
                public File run() throws Exception {
                    return File.createTempFile("proxy", "err");
                }
            });
        }
        catch (RuntimeException e) {
            throw new RuntimeException(e);
        }
        proxyFile.deleteOnExit();
        this.delegate.createAndSerializeProxy(proxyFile);
        return proxyFile;
    }
}

