/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.test.aop.reflection;

import org.jboss.aop.advice.Interceptor;
import org.jboss.aop.joinpoint.ConstructorInvocation;
import org.jboss.aop.joinpoint.FieldReadInvocation;
import org.jboss.aop.joinpoint.FieldWriteInvocation;
import org.jboss.aop.joinpoint.Invocation;
import org.jboss.aop.joinpoint.MethodInvocation;

public class SimplePerVmInterceptor
implements Interceptor {
    public static int constructorIntercepted;
    public static int fieldReadIntercepted;
    public static int fieldWriteIntercepted;
    public static int methodIntercepted;

    public String getName() {
        return "SimplePerVmInterceptor";
    }

    public Object invoke(Invocation invocation) throws Throwable {
        System.out.println("SimplePerVmInterceptor interception: " + invocation.getClass().getName());
        if (invocation instanceof MethodInvocation) {
            System.out.println("methodIntercepted: " + ++methodIntercepted);
        } else if (invocation instanceof FieldReadInvocation) {
            System.out.println("fieldReadIntercepted: " + ++fieldReadIntercepted);
        } else if (invocation instanceof FieldWriteInvocation) {
            System.out.println("fieldWriteIntercepted: " + ++fieldWriteIntercepted);
        } else if (invocation instanceof ConstructorInvocation) {
            System.out.println("constructorIntercepted:" + ++constructorIntercepted);
        }
        return invocation.invokeNext();
    }

    public static boolean hasIntercepted() {
        return constructorIntercepted > 0 || fieldReadIntercepted > 0 || fieldWriteIntercepted > 0 || methodIntercepted > 0;
    }

    public static void reset() {
        constructorIntercepted = 0;
        fieldReadIntercepted = 0;
        fieldWriteIntercepted = 0;
        methodIntercepted = 0;
    }
}

