/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.test.aop.regression.jbaop110;

import org.jboss.aop.joinpoint.ConstructorInvocation;
import org.jboss.aop.joinpoint.FieldReadInvocation;
import org.jboss.aop.joinpoint.FieldWriteInvocation;
import org.jboss.aop.joinpoint.MethodInvocation;

public class TestAspect {
    public static boolean constructor;
    public static boolean normalRead;
    public static boolean normalWrite;
    public static boolean staticRead;
    public static boolean staticWrite;
    public static boolean method;

    public static void clear() {
        constructor = false;
        normalRead = false;
        normalWrite = false;
        staticRead = false;
        staticWrite = false;
        method = false;
    }

    public Object invoke(MethodInvocation invocation) throws Throwable {
        method = true;
        System.out.println("Invoking method " + invocation.getMethod());
        return invocation.invokeNext();
    }

    public Object invoke(ConstructorInvocation invocation) throws Throwable {
        constructor = true;
        System.out.println("Invoking ctor " + invocation.getConstructor());
        return invocation.invokeNext();
    }

    public Object invoke(FieldReadInvocation invocation) throws Throwable {
        System.out.println("Invoking field read " + invocation.getField());
        if (invocation.getField().getType().getName().indexOf("NormalType") >= 0) {
            normalRead = true;
        } else if (invocation.getField().getType().getName().indexOf("StaticType") >= 0) {
            staticRead = true;
        }
        return invocation.invokeNext();
    }

    public Object invoke(FieldWriteInvocation invocation) throws Throwable {
        System.out.println("Invoking field write " + invocation.getField());
        if (invocation.getField().getType().getName().indexOf("NormalType") >= 0) {
            normalWrite = true;
        } else if (invocation.getField().getType().getName().indexOf("StaticType") >= 0) {
            staticWrite = true;
        }
        return invocation.invokeNext();
    }
}

