/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.test.aop.stress.simple;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import junit.framework.TestCase;
import junit.textui.TestRunner;
import org.jboss.aop.util.ReflectToJavassist;
import org.jboss.test.aop.stress.AbstractScenario;
import org.jboss.test.aop.stress.Scenario;
import org.jboss.test.aop.stress.ScenarioTest;
import org.jboss.test.aop.stress.simple.LargePojo;

public class SimpleReflectToJavassistTestCase
extends ScenarioTest {
    public static void main(String[] args) {
        TestRunner.run(SimpleReflectToJavassistTestCase.class);
    }

    public SimpleReflectToJavassistTestCase(String name) throws Exception {
        super(name);
    }

    public void testException() throws Exception {
        boolean exception = false;
        try {
            this.getRunner().executeScenario(new ExceptionScenario(), (TestCase)this);
        }
        catch (Exception e) {
            exception = true;
        }
        SimpleReflectToJavassistTestCase.assertTrue((boolean)exception);
    }

    public void testAnnotationsUnderStress() throws Exception {
        Scenario[] scenarios = new Scenario[]{new SimpleClassToJavassistScenario(), new SimpleFieldToJavassistScenario(), new SimpleMethodToJavassistScenario()};
        this.getRunner().executeScenario(scenarios, (TestCase)this);
    }

    public void testExceptionOverhead() throws Throwable {
        this.getRunner().executeScenario(new InstantiateObjectScenario(), (TestCase)this);
        this.getRunner().executeScenario(new CreateExceptionScenario(), (TestCase)this);
        this.getRunner().executeScenario(new CreateExceptionGetStackTraceScenario(), (TestCase)this);
        this.getRunner().executeScenario(new CallMethodWithExceptionScenario(), (TestCase)this);
    }

    private class CallMethodWithExceptionScenario
    extends AbstractScenario {
        RuntimeException e = new RuntimeException();

        private CallMethodWithExceptionScenario() {
        }

        public void execute(int thread, int loop) throws Exception {
            try {
                this.method();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }

        private void method() {
            throw this.e;
        }
    }

    private class CreateExceptionGetStackTraceScenario
    extends AbstractScenario {
        private CreateExceptionGetStackTraceScenario() {
        }

        public void execute(int thread, int loop) throws Exception {
            RuntimeException e = new RuntimeException();
            e.getStackTrace();
        }
    }

    private class CreateExceptionScenario
    extends AbstractScenario {
        private CreateExceptionScenario() {
        }

        public void execute(int thread, int loop) throws Exception {
            RuntimeException e = new RuntimeException();
        }
    }

    private class InstantiateObjectScenario
    extends AbstractScenario {
        private InstantiateObjectScenario() {
        }

        public void execute(int thread, int loop) throws Exception {
            Object o = new Object();
        }
    }

    private class SimpleFieldToJavassistScenario
    extends AbstractScenario {
        private SimpleFieldToJavassistScenario() {
        }

        public void execute(int thread, int loop) throws Exception {
            Class<LargePojo> pojo = LargePojo.class;
            Field f = pojo.getField("field");
            ReflectToJavassist.fieldToJavassist((Field)f);
        }
    }

    private class SimpleMethodToJavassistScenario
    extends AbstractScenario {
        private SimpleMethodToJavassistScenario() {
        }

        public void execute(int thread, int loop) throws Exception {
            Class<LargePojo> pojo = LargePojo.class;
            Method m = pojo.getMethod("method", new Class[0]);
            ReflectToJavassist.methodToJavassist((Method)m);
        }
    }

    private class SimpleClassToJavassistScenario
    extends AbstractScenario {
        private SimpleClassToJavassistScenario() {
        }

        public void execute(int thread, int loop) throws Exception {
            Class<LargePojo> pojo = LargePojo.class;
            ReflectToJavassist.classToJavassist(pojo);
        }
    }

    private class ExceptionScenario
    extends AbstractScenario {
        private ExceptionScenario() {
        }

        public void execute(int thread, int loop) throws Exception {
            if (thread == 0 && loop == 1) {
                System.out.println("Throwing exception!!!!");
                throw new Exception("Thrown Exception");
            }
        }
    }
}

