/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.console.spi;

import com.gwtplatform.mvp.client.annotations.NameToken;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import javax.annotation.processing.AbstractProcessor;
import javax.annotation.processing.Filer;
import javax.annotation.processing.ProcessingEnvironment;
import javax.annotation.processing.RoundEnvironment;
import javax.annotation.processing.SupportedSourceVersion;
import javax.lang.model.SourceVersion;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.AnnotationValue;
import javax.lang.model.element.Element;
import javax.lang.model.element.PackageElement;
import javax.lang.model.element.TypeElement;
import javax.tools.FileObject;
import javax.tools.JavaFileObject;
import javax.tools.StandardLocation;
import org.jboss.as.console.client.plugins.RuntimeExtensionMetaData;
import org.jboss.as.console.client.plugins.SubsystemExtensionMetaData;
import org.jboss.as.console.spi.BeanFactoryExtension;
import org.jboss.as.console.spi.ExtensionDeclaration;
import org.jboss.as.console.spi.GinExtension;
import org.jboss.as.console.spi.GinExtensionBinding;
import org.jboss.as.console.spi.RuntimeExtension;
import org.jboss.as.console.spi.SubsystemExtension;
import org.jboss.as.console.spi.TemplateProcessor;

@SupportedSourceVersion(value=SourceVersion.RELEASE_7)
public class SPIProcessor
extends AbstractProcessor {
    private static final String EXTENSION_TEMPLATE = "Extension.tmpl";
    private static final String EXTENSION_FILENAME = "org.jboss.as.console.client.core.gin.Composite";
    private static final String BINDING_TEMPLATE = "ExtensionBinding.tmpl";
    private static final String BINDING_FILENAME = "org.jboss.as.console.client.core.gin.CompositeBinding";
    private static final String BEAN_FACTORY_TEMPLATE = "BeanFactory.tmpl";
    private static final String BEAN_FACTORY_FILENAME = "org.jboss.as.console.client.shared.BeanFactory";
    private static final String SUBSYSTEM_FILENAME = "org.jboss.as.console.client.plugins.SubsystemRegistryImpl";
    private static final String SUBSYSTEM_TEMPLATE = "SubsystemExtensions.tmpl";
    private static final String RUNTIME_FILENAME = "org.jboss.as.console.client.plugins.RuntimeLHSItemExtensionRegistryImpl";
    private static final String RUNTIME_TEMPLATE = "RuntimeExtensions.tmpl";
    private static final String MODULE_FILENAME = "App.gwt.xml";
    private static final String MODULE_DEV_FILENAME = "App_dev.gwt.xml";
    private static final String MODULE_PRODUCT_FILENAME = "App_RH.gwt.xml";
    private static final String MODULE_PACKAGENAME = "org.jboss.as.console.composite";
    private static final String MODULE_TEMPLATE = "App.gwt.xml.tmpl";
    private static final String MODULE_DEV_TEMPLATE = "App_dev.gwt.xml.tmpl";
    private static final String MODULE_PRODUCT_TEMPLATE = "App_RH.gwt.xml.tmpl";
    private Filer filer;
    private ProcessingEnvironment processingEnv;
    private List<String> discoveredExtensions;
    private List<ExtensionDeclaration> discoveredBindings;
    private List<String> discoveredBeanFactories;
    private List<String> categoryClasses;
    private List<SubsystemExtensionMetaData> subsystemDeclararions;
    private List<RuntimeExtensionMetaData> runtimeExtensions;
    private Set<String> modules = new LinkedHashSet<String>();
    private Set<String> nameTokens;

    @Override
    public void init(ProcessingEnvironment env) {
        this.processingEnv = env;
        this.filer = env.getFiler();
        this.discoveredExtensions = new ArrayList<String>();
        this.discoveredBindings = new ArrayList<ExtensionDeclaration>();
        this.discoveredBeanFactories = new ArrayList<String>();
        this.categoryClasses = new ArrayList<String>();
        this.subsystemDeclararions = new ArrayList<SubsystemExtensionMetaData>();
        this.runtimeExtensions = new ArrayList<RuntimeExtensionMetaData>();
        this.nameTokens = new HashSet<String>();
    }

    @Override
    public Set<String> getSupportedAnnotationTypes() {
        HashSet<String> types = new HashSet<String>();
        types.add(GinExtension.class.getName());
        types.add(GinExtensionBinding.class.getName());
        types.add(BeanFactoryExtension.class.getName());
        types.add(SubsystemExtension.class.getName());
        types.add(RuntimeExtension.class.getName());
        return types;
    }

    @Override
    public boolean process(Set<? extends TypeElement> typeElements, RoundEnvironment roundEnv) {
        if (!roundEnv.processingOver()) {
            System.out.println("Begin Components discovery ...");
            Set<? extends Element> extensionElements = roundEnv.getElementsAnnotatedWith(GinExtension.class);
            for (Element element : extensionElements) {
                this.handleGinExtensionElement(element);
            }
            System.out.println("Begin Bindings discovery ...");
            Set<? extends Element> extensionBindingElements = roundEnv.getElementsAnnotatedWith(GinExtensionBinding.class);
            for (Element element : extensionBindingElements) {
                this.handleGinExtensionBindingElement(element);
            }
            System.out.println("Begin BeanFactory discovery ...");
            Set<? extends Element> set = roundEnv.getElementsAnnotatedWith(BeanFactoryExtension.class);
            for (Element element : set) {
                this.handleBeanFactoryElement(element);
            }
            System.out.println("Begin Subsystem discovery ...");
            Set<? extends Element> set2 = roundEnv.getElementsAnnotatedWith(SubsystemExtension.class);
            for (Element element : set2) {
                this.handleSubsystemElement(element);
            }
            System.out.println("Begin Runtime Extension discovery ...");
            Set<? extends Element> set3 = roundEnv.getElementsAnnotatedWith(RuntimeExtension.class);
            for (Element element : set3) {
                this.handleRuntimeExtensions(element);
            }
        }
        if (roundEnv.processingOver()) {
            try {
                this.writeFiles();
            }
            catch (Exception e) {
                e.printStackTrace();
                throw new RuntimeException("Failed to process SPI artifacts");
            }
            System.out.println("SPI component discovery completed.");
        }
        return true;
    }

    private void handleGinExtensionBindingElement(Element element) {
        String typeName = element.asType().toString();
        System.out.println("Binding: " + typeName);
        this.discoveredBindings.add(new ExtensionDeclaration(typeName));
    }

    private void handleRuntimeExtensions(Element element) {
        List<? extends AnnotationMirror> annotationMirrors = element.getAnnotationMirrors();
        for (AnnotationMirror annotationMirror : annotationMirrors) {
            String annotationType = annotationMirror.getAnnotationType().toString();
            if (!annotationType.equals(RuntimeExtension.class.getName())) continue;
            NameToken nameToken = element.getAnnotation(NameToken.class);
            RuntimeExtension extension = element.getAnnotation(RuntimeExtension.class);
            if (nameToken == null) continue;
            System.out.println("Runtime Extension: " + extension.name() + " -> " + nameToken.value());
            RuntimeExtensionMetaData declared = new RuntimeExtensionMetaData(extension.name(), nameToken.value(), extension.group(), extension.key());
            this.runtimeExtensions.add(declared);
        }
    }

    private void handleGinExtensionElement(Element element) {
        List<? extends AnnotationMirror> annotationMirrors = element.getAnnotationMirrors();
        for (AnnotationMirror annotationMirror : annotationMirrors) {
            String annotationType = annotationMirror.getAnnotationType().toString();
            if (!annotationType.equals(GinExtension.class.getName())) continue;
            GinExtension comps = element.getAnnotation(GinExtension.class);
            String module = comps.value();
            if (module != null && module.length() > 0) {
                this.modules.add(module);
            }
            PackageElement packageElement = this.processingEnv.getElementUtils().getPackageOf(element);
            String fqn = packageElement.getQualifiedName().toString() + "." + element.getSimpleName().toString();
            System.out.println("Components: " + fqn);
            this.discoveredExtensions.add(fqn);
        }
    }

    private void handleBeanFactoryElement(Element element) {
        List<? extends AnnotationMirror> annotationMirrors = element.getAnnotationMirrors();
        for (AnnotationMirror annotationMirror : annotationMirrors) {
            Collection<? extends AnnotationValue> values;
            String annotationType = annotationMirror.getAnnotationType().toString();
            if (annotationType.equals(BeanFactoryExtension.class.getName())) {
                PackageElement packageElement = this.processingEnv.getElementUtils().getPackageOf(element);
                String fqn = packageElement.getQualifiedName().toString() + "." + element.getSimpleName().toString();
                System.out.println("Factory: " + fqn);
                this.discoveredBeanFactories.add(fqn);
                continue;
            }
            if (!annotationType.equals("com.google.web.bindery.autobean.shared.AutoBeanFactory.Category") || (values = annotationMirror.getElementValues().values()).size() <= 0) continue;
            for (AnnotationValue categoryClass : (List)values.iterator().next().getValue()) {
                this.categoryClasses.add(categoryClass.getValue().toString());
            }
        }
    }

    private void handleSubsystemElement(Element element) {
        List<? extends AnnotationMirror> annotationMirrors = element.getAnnotationMirrors();
        for (AnnotationMirror annotationMirror : annotationMirrors) {
            String annotationType = annotationMirror.getAnnotationType().toString();
            if (!annotationType.equals(SubsystemExtension.class.getName())) continue;
            NameToken nameToken = element.getAnnotation(NameToken.class);
            SubsystemExtension subsystem = element.getAnnotation(SubsystemExtension.class);
            if (nameToken == null) continue;
            System.out.println("Subsystem: " + subsystem.name() + " -> " + nameToken.value());
            SubsystemExtensionMetaData declared = new SubsystemExtensionMetaData(subsystem.name(), nameToken.value(), subsystem.group(), subsystem.key());
            this.subsystemDeclararions.add(declared);
            if (this.nameTokens.add(nameToken.value())) continue;
            throw new RuntimeException("Duplicate name token '" + nameToken.value() + "' declared on '" + element.asType());
        }
    }

    private void writeFiles() throws Exception {
        this.writeGinjectorFile();
        this.writeBindingFile();
        this.writeBeanFactoryFile();
        this.writeSubsystemFile();
        this.writeRuntimeFile();
        this.writeModuleFile();
        this.writeDevModuleFile();
        this.writeProductModuleFile();
        this.writeProxyConfigurations();
    }

    private void writeRuntimeFile() throws Exception {
        HashMap<String, Object> model = new HashMap<String, Object>();
        model.put("runtimeMenuItemExtensions", this.runtimeExtensions);
        JavaFileObject sourceFile = this.filer.createSourceFile(RUNTIME_FILENAME, new Element[0]);
        OutputStream output = sourceFile.openOutputStream();
        new TemplateProcessor().process(RUNTIME_TEMPLATE, model, output);
        output.flush();
        output.close();
    }

    private void writeSubsystemFile() throws Exception {
        HashMap<String, Object> model = new HashMap<String, Object>();
        model.put("subsystemExtensions", this.subsystemDeclararions);
        JavaFileObject sourceFile = this.filer.createSourceFile(SUBSYSTEM_FILENAME, new Element[0]);
        OutputStream output = sourceFile.openOutputStream();
        new TemplateProcessor().process(SUBSYSTEM_TEMPLATE, model, output);
        output.flush();
        output.close();
    }

    private void writeBeanFactoryFile() throws Exception {
        HashMap<String, Object> model = new HashMap<String, Object>();
        model.put("extensions", this.discoveredBeanFactories);
        model.put("categoryClasses", this.categoryClasses);
        JavaFileObject sourceFile = this.filer.createSourceFile(BEAN_FACTORY_FILENAME, new Element[0]);
        OutputStream output = sourceFile.openOutputStream();
        new TemplateProcessor().process(BEAN_FACTORY_TEMPLATE, model, output);
        output.flush();
        output.close();
    }

    private void writeBindingFile() throws Exception {
        JavaFileObject sourceFile = this.filer.createSourceFile(BINDING_FILENAME, new Element[0]);
        HashMap<String, Object> model = new HashMap<String, Object>();
        model.put("extensions", this.discoveredBindings);
        OutputStream output = sourceFile.openOutputStream();
        new TemplateProcessor().process(BINDING_TEMPLATE, model, output);
        output.flush();
        output.close();
    }

    private void writeGinjectorFile() throws Exception {
        HashMap<String, Object> model = new HashMap<String, Object>();
        model.put("extensions", this.discoveredExtensions);
        JavaFileObject sourceFile = this.filer.createSourceFile(EXTENSION_FILENAME, new Element[0]);
        OutputStream output = sourceFile.openOutputStream();
        new TemplateProcessor().process(EXTENSION_TEMPLATE, model, output);
        output.flush();
        output.close();
    }

    private void writeModuleFile() {
        try {
            HashMap<String, Object> model = new HashMap<String, Object>();
            model.put("modules", this.modules);
            model.put("properties", this.processingEnv.getOptions());
            FileObject sourceFile = this.filer.createResource(StandardLocation.SOURCE_OUTPUT, MODULE_PACKAGENAME, MODULE_FILENAME, new Element[0]);
            OutputStream output = sourceFile.openOutputStream();
            new TemplateProcessor().process(MODULE_TEMPLATE, model, output);
            output.flush();
            output.close();
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to create file", e);
        }
    }

    private void writeDevModuleFile() {
        try {
            HashMap<String, Object> model = new HashMap<String, Object>();
            model.put("modules", this.modules);
            model.put("properties", this.processingEnv.getOptions());
            FileObject sourceFile = this.filer.createResource(StandardLocation.SOURCE_OUTPUT, MODULE_PACKAGENAME, MODULE_DEV_FILENAME, new Element[0]);
            OutputStream output = sourceFile.openOutputStream();
            new TemplateProcessor().process(MODULE_DEV_TEMPLATE, model, output);
            output.flush();
            output.close();
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to create file", e);
        }
    }

    private void writeProductModuleFile() {
        try {
            HashMap<String, Object> model = new HashMap<String, Object>();
            model.put("modules", this.modules);
            model.put("properties", this.processingEnv.getOptions());
            FileObject sourceFile = this.filer.createResource(StandardLocation.SOURCE_OUTPUT, MODULE_PACKAGENAME, MODULE_PRODUCT_FILENAME, new Element[0]);
            OutputStream output = sourceFile.openOutputStream();
            new TemplateProcessor().process(MODULE_PRODUCT_TEMPLATE, model, output);
            output.flush();
            output.close();
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to create file", e);
        }
    }

    private void writeProxyConfigurations() {
        try {
            String devHostUrl = this.processingEnv.getOptions().get("console.dev.host") != null ? this.processingEnv.getOptions().get("console.dev.host") : "127.0.0.1";
            HashMap<String, Object> model = new HashMap<String, Object>();
            model.put("devHost", devHostUrl);
            FileObject sourceFile = this.filer.createResource(StandardLocation.SOURCE_OUTPUT, "", "gwt-proxy.properties", new Element[0]);
            OutputStream output1 = sourceFile.openOutputStream();
            FileObject sourceFile2 = this.filer.createResource(StandardLocation.SOURCE_OUTPUT, "", "upload-proxy.properties", new Element[0]);
            OutputStream output2 = sourceFile2.openOutputStream();
            FileObject sourceFile3 = this.filer.createResource(StandardLocation.SOURCE_OUTPUT, "", "logout.properties", new Element[0]);
            OutputStream output3 = sourceFile3.openOutputStream();
            new TemplateProcessor().process("gwt.proxy.tmpl", model, output1);
            new TemplateProcessor().process("gwt.proxy.upload.tmpl", model, output2);
            new TemplateProcessor().process("gwt.proxy.logout.tmpl", model, output3);
            output1.close();
            output2.close();
            output3.close();
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to create file", e);
        }
    }
}

