/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.hal.processors;

import com.google.auto.service.AutoService;
import com.google.common.base.Joiner;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import javax.annotation.processing.Processor;
import javax.annotation.processing.RoundEnvironment;
import javax.annotation.processing.SupportedAnnotationTypes;
import javax.lang.model.element.Element;
import javax.lang.model.element.TypeElement;
import org.jboss.as.console.spi.GinExtension;
import org.jboss.as.console.spi.GinExtensionBinding;
import org.jboss.hal.processors.AbstractHalProcessor;

@SupportedAnnotationTypes(value={"org.jboss.as.console.spi.GinExtension", "org.jboss.as.console.spi.GinExtensionBinding"})
@AutoService(value=Processor.class)
public class GinProcessor
extends AbstractHalProcessor {
    static final String GINJECTOR_TEMPLATE = "CompositeGinjector.ftl";
    static final String GINJECTOR_PACKAGE = "org.jboss.as.console.client.core.gin";
    static final String GINJECTOR_CLASS = "CompositeGinjector";
    static final String MODULE_TEMPLATE = "CompositeModule.ftl";
    static final String MODULE_PACKAGE = "org.jboss.as.console.client.core.gin";
    static final String MODULE_CLASS = "CompositeModule";
    static final int GENERATE_AT_ROUND = 1;
    private final Set<String> ginjectors = new HashSet<String>();
    private final Set<String> modules = new HashSet<String>();

    @Override
    protected boolean onProcess(Set<? extends TypeElement> annotations, RoundEnvironment roundEnv) {
        TypeElement moduleElement;
        for (Element element : roundEnv.getElementsAnnotatedWith(GinExtension.class)) {
            moduleElement = (TypeElement)element;
            this.ginjectors.add(moduleElement.getQualifiedName().toString());
            this.debug("Added %s as ginjector extension", moduleElement.getQualifiedName());
        }
        for (Element element : roundEnv.getElementsAnnotatedWith(GinExtensionBinding.class)) {
            moduleElement = (TypeElement)element;
            this.modules.add(moduleElement.getQualifiedName().toString());
            this.debug("Added %s as GIN module extension", moduleElement.getQualifiedName());
        }
        if (this.round() == 1) {
            if (!this.ginjectors.isEmpty()) {
                this.debug("Generating composite ginjector interface", new Object[0]);
                this.code(GINJECTOR_TEMPLATE, "org.jboss.as.console.client.core.gin", GINJECTOR_CLASS, () -> {
                    HashMap<String, Object> context = new HashMap<String, Object>();
                    context.put("packageName", "org.jboss.as.console.client.core.gin");
                    context.put("className", GINJECTOR_CLASS);
                    context.put("ginjectors", this.ginjectors);
                    context.put("compositeBinding", MODULE_CLASS);
                    return context;
                });
                this.info("Successfully generated composite ginjector interface [%s] based on \n\t- %s.", GINJECTOR_CLASS, Joiner.on((String)"\n\t- ").join(this.ginjectors));
                this.ginjectors.clear();
            }
            if (!this.modules.isEmpty()) {
                this.debug("Generating composite GIN module", new Object[0]);
                this.code(MODULE_TEMPLATE, "org.jboss.as.console.client.core.gin", MODULE_CLASS, () -> {
                    HashMap<String, Object> context = new HashMap<String, Object>();
                    context.put("packageName", "org.jboss.as.console.client.core.gin");
                    context.put("className", MODULE_CLASS);
                    context.put("modules", this.modules);
                    return context;
                });
                this.info("Successfully generated composite GIN module [%s] based on \n\t- %s.", MODULE_CLASS, Joiner.on((String)"\n\t- ").join(this.modules));
                this.modules.clear();
            }
        }
        return false;
    }
}

