/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.hal.processors;

import com.google.auto.service.AutoService;
import com.gwtplatform.mvp.client.annotations.NameToken;
import com.gwtplatform.mvp.client.annotations.NoGatekeeper;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.function.Supplier;
import javax.annotation.processing.Processor;
import javax.annotation.processing.RoundEnvironment;
import javax.annotation.processing.SupportedAnnotationTypes;
import javax.lang.model.element.Element;
import javax.lang.model.element.TypeElement;
import org.jboss.as.console.spi.AccessControl;
import org.jboss.as.console.spi.OperationMode;
import org.jboss.as.console.spi.RequiredResources;
import org.jboss.as.console.spi.SearchIndex;
import org.jboss.hal.processors.AbstractHalProcessor;

@SupportedAnnotationTypes(value={"com.gwtplatform.mvp.client.annotations.NameToken"})
@AutoService(value=Processor.class)
public class NameTokenProcessor
extends AbstractHalProcessor {
    static final String REQUIRED_RESOURCES_TEMPLATE = "RequiredResources.ftl";
    static final String REQUIRED_RESOURCES_PACKAGE = "org.jboss.as.console.client.plugins";
    static final String REQUIRED_RESOURCES_CLASS = "RequiredResourcesRegistryImpl";
    static final String SEARCH_INDEX_TEMPLATE = "SearchIndex.ftl";
    static final String SEARCH_INDEX_PACKAGE = "org.jboss.as.console.client.plugins";
    static final String SEARCH_INDEX_CLASS = "SearchIndexRegistryImpl";
    private final Set<NameTokenInfo> tokenInfos = new HashSet<NameTokenInfo>();

    @Override
    protected boolean onProcess(Set<? extends TypeElement> annotations, RoundEnvironment roundEnv) {
        for (Element element : roundEnv.getElementsAnnotatedWith(NameToken.class)) {
            SearchIndex searchIndex;
            TypeElement tokenElement = (TypeElement)element;
            NameToken nameToken = tokenElement.getAnnotation(NameToken.class);
            NameTokenInfo tokenInfo = new NameTokenInfo(nameToken.value()[0]);
            this.tokenInfos.add(tokenInfo);
            RequiredResources requiredResources = tokenElement.getAnnotation(RequiredResources.class);
            AccessControl accessControl = tokenElement.getAnnotation(AccessControl.class);
            NoGatekeeper noGatekeeper = tokenElement.getAnnotation(NoGatekeeper.class);
            if (accessControl != null && requiredResources != null) {
                this.warning(element, "Detected both @%s and @%s on proxy with token \"#%s\". Only @%1$s will be processed.", RequiredResources.class.getSimpleName(), AccessControl.class.getSimpleName(), tokenInfo.getToken());
            }
            if (requiredResources != null) {
                tokenInfo.addResources(requiredResources.resources());
                tokenInfo.addOperations(requiredResources.operations());
                tokenInfo.setRecursive(requiredResources.recursive());
            } else if (accessControl != null) {
                tokenInfo.addResources(accessControl.resources());
                tokenInfo.addOperations(accessControl.operations());
                tokenInfo.setRecursive(accessControl.recursive());
            } else if (noGatekeeper == null) {
                this.warning(element, "Proxy with token \"#%s\" is missing @%s annotation.", tokenInfo.getToken(), RequiredResources.class.getSimpleName());
            }
            if ((searchIndex = tokenElement.getAnnotation(SearchIndex.class)) == null) continue;
            tokenInfo.addKeywords(searchIndex.keywords());
            tokenInfo.setExclude(searchIndex.exclude());
            OperationMode operationMode = tokenElement.getAnnotation(OperationMode.class);
            if (operationMode == null) continue;
            tokenInfo.setDomainOnly(operationMode.value() == OperationMode.Mode.DOMAIN);
            tokenInfo.setStandaloneOnly(operationMode.value() == OperationMode.Mode.STANDALONE);
        }
        if (!this.tokenInfos.isEmpty()) {
            this.debug("Generating code for required resources registry", new Object[0]);
            this.code(REQUIRED_RESOURCES_TEMPLATE, "org.jboss.as.console.client.plugins", REQUIRED_RESOURCES_CLASS, this.context("org.jboss.as.console.client.plugins", REQUIRED_RESOURCES_CLASS));
            this.debug("Generating code for search index registry", new Object[0]);
            this.code(SEARCH_INDEX_TEMPLATE, "org.jboss.as.console.client.plugins", SEARCH_INDEX_CLASS, this.context("org.jboss.as.console.client.plugins", SEARCH_INDEX_CLASS));
            this.info("Successfully generated name token registries [%s] and [%s].", REQUIRED_RESOURCES_CLASS, SEARCH_INDEX_CLASS);
            this.tokenInfos.clear();
        }
        return false;
    }

    private Supplier<Map<String, Object>> context(String packageName, String className) {
        return () -> {
            HashMap<String, Object> context = new HashMap<String, Object>();
            context.put("packageName", packageName);
            context.put("className", className);
            context.put("tokenInfos", this.tokenInfos);
            return context;
        };
    }

    public static class NameTokenInfo {
        private final String token;
        private Set<String> resources;
        private Set<String> operations;
        private boolean recursive;
        private Set<String> keywords;
        private boolean exclude;
        private boolean domainOnly;
        private boolean standaloneOnly;

        public NameTokenInfo(String token) {
            this.token = token;
            this.resources = new HashSet<String>();
            this.operations = new HashSet<String>();
            this.recursive = false;
            this.keywords = new HashSet<String>();
            this.exclude = false;
            this.domainOnly = false;
            this.standaloneOnly = false;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof NameTokenInfo)) {
                return false;
            }
            NameTokenInfo that = (NameTokenInfo)o;
            return this.token.equals(that.token);
        }

        public int hashCode() {
            return this.token.hashCode();
        }

        public String toString() {
            return "NameTokenInfo{" + this.token + "}";
        }

        public boolean isExclude() {
            return this.exclude;
        }

        public void setExclude(boolean exclude) {
            this.exclude = exclude;
        }

        public Set<String> getKeywords() {
            return this.keywords;
        }

        public void addKeywords(String[] keywords) {
            this.keywords.addAll(Arrays.asList(keywords));
        }

        public Set<String> getOperations() {
            return this.operations;
        }

        public void addOperations(String[] operations) {
            this.operations.addAll(Arrays.asList(operations));
        }

        public boolean isRecursive() {
            return this.recursive;
        }

        public void setRecursive(boolean recursive) {
            this.recursive = recursive;
        }

        public Set<String> getResources() {
            return this.resources;
        }

        public void addResources(String[] resources) {
            this.resources.addAll(Arrays.asList(resources));
        }

        public String getToken() {
            return this.token;
        }

        public boolean isDomainOnly() {
            return this.domainOnly;
        }

        public void setDomainOnly(boolean domainOnly) {
            this.domainOnly = domainOnly;
        }

        public boolean isStandaloneOnly() {
            return this.standaloneOnly;
        }

        public void setStandaloneOnly(boolean standaloneOnly) {
            this.standaloneOnly = standaloneOnly;
        }
    }
}

