/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.hal.processors;

import com.google.auto.service.AutoService;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.processing.Processor;
import javax.annotation.processing.RoundEnvironment;
import javax.annotation.processing.SupportedAnnotationTypes;
import javax.annotation.processing.SupportedOptions;
import org.jboss.hal.processors.AbstractHalProcessor;

@SupportedOptions(value={"gwt.hal.version", "gwt.console.core.version"})
@SupportedAnnotationTypes(value={"org.jboss.as.console.spi.Entrypoint"})
@AutoService(value=Processor.class)
public class GwtModuleProcessor
extends AbstractHalProcessor {
    static final String PACKAGE_NAME = "org.jboss.as.console.composite";
    static final String GWT_PREFIX = "gwt.";

    @Override
    protected boolean onLastRound(RoundEnvironment roundEnv) {
        HashMap gwtProperties = new HashMap();
        Map<String, String> options = this.processingEnv.getOptions();
        options.keySet().stream().filter(key -> key.startsWith(GWT_PREFIX)).forEach(key -> {
            String gwtProperty = key.substring(GWT_PREFIX.length());
            this.debug("Discovered GWT property [%s]", gwtProperty);
            gwtProperties.put(gwtProperty, options.get(key));
        });
        for (GwtModule gwtModule : GwtModule.values()) {
            this.resource(gwtModule.template, PACKAGE_NAME, gwtModule.module, () -> {
                HashMap<String, Map> context = new HashMap<String, Map>();
                context.put("properties", gwtProperties);
                return context;
            });
            this.info("Successfully generated GWT module [%s]", gwtModule.module);
        }
        return true;
    }

    static enum GwtModule {
        BASE("Base.gwt.xml", "Base.gwt.xml.ftl"),
        EAP("EAP.gwt.xml", "EAP.gwt.xml.ftl"),
        EAP_DEV("EAPDev.gwt.xml", "EAPDev.gwt.xml.ftl"),
        WILDFLY_DEV("WildFlyDev.gwt.xml", "WildFlyDev.gwt.xml.ftl"),
        WILDFLY_SLIM("WildFly.gwt.xml", "WildFly.gwt.xml.ftl"),
        WILDFLY_FULL("WildFlyFull.gwt.xml", "WildFlyFull.gwt.xml.ftl");

        final String module;
        final String template;

        private GwtModule(String module, String template) {
            this.module = module;
            this.template = template;
        }
    }
}

