/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.hal.testsuite.creaper.command;

import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.Property;
import org.jgrapht.experimental.dag.DirectedAcyclicGraph;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.wildfly.extras.creaper.core.CommandFailedException;
import org.wildfly.extras.creaper.core.online.OnlineCommand;
import org.wildfly.extras.creaper.core.online.OnlineCommandContext;
import org.wildfly.extras.creaper.core.online.operations.Address;
import org.wildfly.extras.creaper.core.online.operations.Batch;
import org.wildfly.extras.creaper.core.online.operations.Operations;
import org.wildfly.extras.creaper.core.online.operations.ReadResourceOption;

public final class BackupAndRestoreAttributes {
    private final Address address;
    private final DirectedAcyclicGraph<String, String> dependencies;
    private final Set<String> excluded;
    private final Logger logger = LoggerFactory.getLogger(BackupAndRestoreAttributes.class);
    private ModelNode backup;
    private final OnlineCommand backupPart = new OnlineCommand(){

        public void apply(OnlineCommandContext ctx) throws Exception {
            if (BackupAndRestoreAttributes.this.backup != null) {
                throw new CommandFailedException("Backup has been already made!");
            }
            Operations ops = new Operations(ctx.client);
            BackupAndRestoreAttributes.this.backup = ops.readResource(BackupAndRestoreAttributes.this.address, new ReadResourceOption[]{ReadResourceOption.INCLUDE_DEFAULTS, ReadResourceOption.ATTRIBUTES_ONLY}).value();
        }
    };
    private final OnlineCommand restorePart = new OnlineCommand(){
        private final Batch batch = new Batch();

        private Map<String, ModelNode> propertyListToMap(List<Property> propertyList) {
            HashMap<String, ModelNode> attributeMap = new HashMap<String, ModelNode>();
            for (Property property : propertyList) {
                BackupAndRestoreAttributes.this.logger.info("Adding '" + property.getName() + "' to map.");
                attributeMap.put(property.getName(), property.getValue());
            }
            return attributeMap;
        }

        public void apply(OnlineCommandContext ctx) throws Exception {
            if (BackupAndRestoreAttributes.this.backup == null) {
                throw new CommandFailedException("There is no backup to be restored!");
            }
            Map<String, ModelNode> attributeValueMap = this.propertyListToMap(BackupAndRestoreAttributes.this.backup.asPropertyList());
            if (BackupAndRestoreAttributes.this.dependencies != null) {
                for (String attributeName : BackupAndRestoreAttributes.this.dependencies) {
                    if (!attributeValueMap.containsKey(attributeName)) {
                        throw new CommandFailedException("Attribute '" + attributeName + "' is not present or it was previously added and removed!");
                    }
                    BackupAndRestoreAttributes.this.logger.info("Adding dependency '" + attributeName + "' to batch.");
                    this.batch.writeAttribute(BackupAndRestoreAttributes.this.address, attributeName, attributeValueMap.get(attributeName));
                    attributeValueMap.remove(attributeName);
                }
            }
            for (String attribute : attributeValueMap.keySet()) {
                if (BackupAndRestoreAttributes.this.excluded != null && BackupAndRestoreAttributes.this.excluded.contains(attribute)) continue;
                BackupAndRestoreAttributes.this.logger.info("Adding attribute '" + attribute + "' to batch.");
                this.batch.writeAttribute(BackupAndRestoreAttributes.this.address, attribute, attributeValueMap.get(attribute));
            }
            Operations ops = new Operations(ctx.client);
            ops.batch(this.batch);
            BackupAndRestoreAttributes.this.backup = null;
        }
    };

    private BackupAndRestoreAttributes(Builder builder) {
        this.address = builder.address;
        this.dependencies = builder.dependencies;
        this.excluded = builder.excluded;
    }

    public OnlineCommand backup() {
        return this.backupPart;
    }

    public OnlineCommand restore() {
        return this.restorePart;
    }

    public static final class Builder {
        private Address address;
        private DirectedAcyclicGraph<String, String> dependencies;
        private Set<String> excluded;

        public Builder(Address address) {
            this.address = address;
        }

        public Builder dependency(String attribute, String dependsOn) {
            if (this.dependencies == null && dependsOn != null) {
                this.dependencies = new DirectedAcyclicGraph(String.class);
            }
            if (this.dependencies != null) {
                this.dependencies.addVertex((Object)attribute);
                this.dependencies.addVertex((Object)dependsOn);
                this.dependencies.addEdge((Object)dependsOn, (Object)attribute);
            }
            return this;
        }

        public Builder excluded(String attribute) {
            if (this.excluded == null && attribute != null) {
                this.excluded = new HashSet<String>();
            }
            if (attribute != null) {
                this.excluded.add(attribute);
            }
            return this;
        }

        public BackupAndRestoreAttributes build() {
            return new BackupAndRestoreAttributes(this);
        }
    }
}

