/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.hal.testsuite.fragment;

import org.jboss.arquillian.graphene.Graphene;
import org.jboss.arquillian.graphene.findby.ByJQuery;
import org.jboss.arquillian.graphene.wait.IsElementBuilder;
import org.jboss.hal.testsuite.fragment.BaseFragment;
import org.jboss.hal.testsuite.fragment.WindowState;
import org.jboss.hal.testsuite.util.Console;
import org.jboss.hal.testsuite.util.PropUtils;
import org.jboss.hal.testsuite.util.Workaround;
import org.openqa.selenium.By;
import org.openqa.selenium.NoSuchElementException;
import org.openqa.selenium.TimeoutException;
import org.openqa.selenium.WebDriverException;
import org.openqa.selenium.WebElement;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WindowFragment
extends BaseFragment {
    private static final Logger log = LoggerFactory.getLogger(WindowFragment.class);
    public static final By ROOT_SELECTOR = By.className((String)PropUtils.get("modals.window.class"));
    protected boolean closed;

    public boolean isClosed() {
        try {
            if (this.closed) {
                return true;
            }
            this.root.isDisplayed();
            return false;
        }
        catch (NoSuchElementException ignored) {
            return true;
        }
    }

    public void waitUntilClosed(int windowCount, boolean fail) {
        Workaround.withBrowser(this.browser).waitUntilWindowIsClosed(windowCount, fail);
    }

    public void waitUntilClosed(boolean fail) {
        block2: {
            try {
                ((IsElementBuilder)Graphene.waitGui().until().element(this.root).is().not()).present();
            }
            catch (TimeoutException e) {
                log.info("After waiting period some window is still opened (this may or may not be an issue).");
                if (!fail) break block2;
                throw e;
            }
        }
    }

    public void waitUntilClosed() {
        this.waitUntilClosed(true);
    }

    public void close() {
        By selector = By.className((String)PropUtils.get("modals.window.close.class"));
        WebElement close = this.root.findElement(selector);
        int windowCount = Console.withBrowser(this.browser).getWindowCount();
        close.click();
        this.waitUntilClosed(windowCount, true);
        this.closed = true;
    }

    public WindowState clickSave() {
        String label = PropUtils.get("modals.window.save.label");
        this.clickButton(label);
        return new WindowState(this);
    }

    public void cancel() {
        String label = PropUtils.get("modals.window.cancel.label");
        this.clickButton(label);
        this.waitUntilClosed();
        this.closed = true;
    }

    @Override
    public void clickButton(String label) {
        log.debug("Trying to click \"" + label + "\" button in current window");
        ByJQuery selector = ByJQuery.selector((String)("button:contains(" + label + "):visible"));
        try {
            Graphene.waitGui().until().element((By)selector).is().visible();
            WebElement button = this.root.findElement((By)selector);
            button.click();
        }
        catch (WebDriverException e) {
            log.debug("Button with label \"" + label + "\" not found");
            throw e;
        }
    }

    public String getHeadTitle() {
        By selector = By.className((String)PropUtils.get("modals.window.title.class"));
        WebElement title = this.root.findElement(selector);
        return title.getText();
    }

    public String getTitle() {
        By selector = By.tagName((String)PropUtils.get("modals.window.content.title.tag"));
        WebElement title = this.root.findElement(selector);
        return title.getText();
    }
}

