/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.hal.testsuite.page.admin;

import org.jboss.arquillian.graphene.Graphene;
import org.jboss.arquillian.graphene.findby.ByJQuery;
import org.jboss.arquillian.graphene.page.Location;
import org.jboss.hal.testsuite.cli.TimeoutException;
import org.jboss.hal.testsuite.finder.FinderNavigation;
import org.jboss.hal.testsuite.fragment.ConfigFragment;
import org.jboss.hal.testsuite.fragment.shared.modal.ConfirmationWindow;
import org.jboss.hal.testsuite.page.BasePage;
import org.jboss.hal.testsuite.util.Console;
import org.openqa.selenium.By;
import org.openqa.selenium.WebElement;

@Location(value="#rbac")
public class RoleAssignmentPage
extends BasePage {
    private FinderNavigation navigation;
    private String roleMapping = "/core-service=management/access=authorization/role-mapping=";
    private String include = "/include=";

    public String prepareAdd(String name, String type, String realm) {
        return "/include=" + name + ":add(name=" + name + ",type=" + type + ",realm=" + realm + ")";
    }

    public String preparePathGroup(String name, String realm, String role, boolean group) {
        if (group) {
            return this.roleMapping + role + this.include + "group-" + name + "@" + realm;
        }
        return this.roleMapping + role + this.include + name;
    }

    public String preparePathUser(String name, String realm, String role, boolean user) {
        if (user) {
            return this.roleMapping + role + this.include + "user-" + name + "@" + realm;
        }
        return this.roleMapping + role + this.include + name;
    }

    public void createGroup(String name, String realm, String role) {
        this.navigation = new FinderNavigation(this.browser, RoleAssignmentPage.class).step("Browse By", "Groups").step("Group");
        this.navigation.selectColumn().invoke("Add");
        this.getWindowFragment().getEditor().text("name", name);
        this.getWindowFragment().getEditor().text("realm", realm);
        this.getWindowFragment().getEditor().select("role", role);
        this.getWindowFragment().clickButton("Save");
    }

    public void selectMember(String name, String realm) {
        WebElement member = this.browser.findElement((By)ByJQuery.selector((String)("[title*='" + name + " (at) " + realm + "']:visible")));
        member.click();
        this.getWindowFragment().clickButton("Save");
    }

    public void selectRole(String role) {
        WebElement member = this.browser.findElement((By)ByJQuery.selector((String)("[title*='" + role + "']:visible")));
        member.click();
        this.getWindowFragment().clickButton("Save");
    }

    public void addInclude(String name, String realm, String role) {
        this.navigation = new FinderNavigation(this.browser, RoleAssignmentPage.class).step("Browse By", "Roles").step("Role", role).step("Membership", "Include").step("Member");
        this.navigation.selectColumn().invoke("Add");
        this.selectMember(name, realm);
    }

    public void removeInclude(String name, String realm, String role) {
        this.navigation = new FinderNavigation(this.browser, RoleAssignmentPage.class).step("Browse By", "Roles").step("Role", role).step("Membership", "Include").step("Member", name + "@" + realm);
        this.navigation.selectRow().invoke("Remove");
        try {
            Console.withBrowser(this.browser).openedWindow(ConfirmationWindow.class).confirm();
        }
        catch (TimeoutException timeoutException) {
            // empty catch block
        }
    }

    public void removeGroup(String name, String realm) {
        this.navigation = new FinderNavigation(this.browser, RoleAssignmentPage.class).step("Browse By", "Groups").step("Group", name + "@" + realm);
        this.navigation.selectRow().invoke("Remove");
        try {
            Console.withBrowser(this.browser).openedWindow(ConfirmationWindow.class).confirm();
        }
        catch (TimeoutException timeoutException) {
            // empty catch block
        }
    }

    public void addUser(String name, String realm, String role) {
        this.navigation = new FinderNavigation(this.browser, RoleAssignmentPage.class).step("Browse By", "Users").step("User");
        this.navigation.selectColumn().invoke("Add");
        this.getWindowFragment().getEditor().text("name", name);
        this.getWindowFragment().getEditor().text("realm", realm);
        this.getWindowFragment().getEditor().select("role", role);
        this.getWindowFragment().clickButton("Save");
    }

    public void removeUser(String name, String realm) {
        this.navigation = new FinderNavigation(this.browser, RoleAssignmentPage.class).step("Browse By", "Users").step("User", name + "@" + realm);
        this.navigation.selectRow().invoke("Remove");
        try {
            Console.withBrowser(this.browser).openedWindow(ConfirmationWindow.class).confirm();
        }
        catch (TimeoutException timeoutException) {
            // empty catch block
        }
    }

    public ConfigFragment getWindowFragment() {
        WebElement editPanel = this.browser.findElement(By.className((String)"default-window-content"));
        return (ConfigFragment)Graphene.createPageFragment(ConfigFragment.class, (WebElement)editPanel);
    }
}

