/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.hal.testsuite.page.config;

import org.jboss.arquillian.graphene.Graphene;
import org.jboss.arquillian.graphene.findby.ByJQuery;
import org.jboss.arquillian.graphene.page.Location;
import org.jboss.hal.testsuite.finder.FinderNavigation;
import org.jboss.hal.testsuite.finder.Row;
import org.jboss.hal.testsuite.fragment.ConfigFragment;
import org.jboss.hal.testsuite.fragment.config.infinispan.CacheContainerWizard;
import org.jboss.hal.testsuite.fragment.config.infinispan.CacheContainersFragment;
import org.jboss.hal.testsuite.fragment.shared.modal.ConfirmationWindow;
import org.jboss.hal.testsuite.page.Navigatable;
import org.jboss.hal.testsuite.page.config.ConfigurationPage;
import org.jboss.hal.testsuite.page.config.DomainConfigEntryPoint;
import org.jboss.hal.testsuite.page.config.StandaloneConfigEntryPoint;
import org.jboss.hal.testsuite.util.ConfigUtils;
import org.jboss.hal.testsuite.util.Console;
import org.jboss.hal.testsuite.util.PropUtils;
import org.openqa.selenium.By;
import org.openqa.selenium.WebElement;

@Location(value="#infinispan")
public class CacheContainersPage
extends ConfigurationPage
implements Navigatable {
    private static final By CONTENT = By.id((String)PropUtils.get("page.content.id"));

    public CacheContainersFragment content() {
        return (CacheContainersFragment)Graphene.createPageFragment(CacheContainersFragment.class, (WebElement)this.getContentRoot().findElement(CONTENT));
    }

    private FinderNavigation createBaseNavigation() {
        FinderNavigation navigation = ConfigUtils.isDomain() ? new FinderNavigation(this.browser, DomainConfigEntryPoint.class).step("Configuration", "Profiles").step("Profile", "full") : new FinderNavigation(this.browser, StandaloneConfigEntryPoint.class).step("Configuration", "Subsystems");
        navigation.step("Subsystem", "Infinispan");
        return navigation;
    }

    @Override
    public void navigate() {
        this.createBaseNavigation().selectColumn();
    }

    public FinderNavigation getNavigationToCacheContainer(String cacheContainer) {
        return this.createBaseNavigation().step("Cache Container", cacheContainer);
    }

    private Row selectCacheContainerRowAndDismissReloadRequiredWindow(String cacheContainer) {
        Row row = this.getNavigationToCacheContainer(cacheContainer).selectRow();
        Console.withBrowser(this.browser).dismissReloadRequiredWindowIfPresent();
        return row;
    }

    private void navigateAndInvokeActionOnCacheContainer(String cacheContainer, String action) {
        this.selectCacheContainerRowAndDismissReloadRequiredWindow(cacheContainer).invoke(action);
    }

    public void invokeTransportSettings(String cacheContainer) {
        this.navigateAndInvokeActionOnCacheContainer(cacheContainer, "Transport Settings");
    }

    public void invokeContainerSettings(String cacheContainer) {
        this.navigateAndInvokeActionOnCacheContainer(cacheContainer, "Container Settings");
    }

    public CacheContainerWizard invokeAddCacheContainer() {
        this.createBaseNavigation().step("Cache Container").selectColumn();
        return this.getResourceManager().addResource(CacheContainerWizard.class);
    }

    public void navigateAndRemoveCacheContainer(String cacheContainer) {
        this.navigateAndInvokeActionOnCacheContainer(cacheContainer, "Remove");
        Console.withBrowser(this.browser).openedWindow(ConfirmationWindow.class).confirm();
    }

    public ConfigFragment getSettingsConfig() {
        ByJQuery selector = ByJQuery.selector((String)("." + PropUtils.get("page.content.rhs.class") + ":visible"));
        WebElement formRoot = this.browser.findElement((By)selector);
        return (ConfigFragment)Graphene.createPageFragment(ConfigFragment.class, (WebElement)formRoot);
    }
}

