/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.hal.testsuite.page.home;

import java.util.Optional;
import org.jboss.arquillian.graphene.Graphene;
import org.jboss.arquillian.graphene.findby.ByJQuery;
import org.jboss.arquillian.graphene.page.Location;
import org.jboss.hal.testsuite.fragment.homepage.HomepageModuleFragment;
import org.jboss.hal.testsuite.fragment.homepage.HomepageNeedHelpSectionFragment;
import org.jboss.hal.testsuite.page.BasePage;
import org.jboss.hal.testsuite.page.Navigatable;
import org.jboss.hal.testsuite.util.Console;
import org.jboss.hal.testsuite.util.PropUtils;
import org.openqa.selenium.By;
import org.openqa.selenium.WebElement;

@Location(value="#home")
public class HomePage
extends BasePage
implements Navigatable {
    private static final String MODULE_CLASS = PropUtils.get("homepage.module.class");
    private static final String MODULE_HEADER_CLASS = PropUtils.get("homepage.module.header.class");
    private static final String MODULE_COLUMN_CLASS = PropUtils.get("homepage.module.column.class");

    @Override
    public void navigate() {
        this.browser.navigate().refresh();
        Graphene.goTo(HomePage.class);
        Console.withBrowser(this.browser).waitUntilLoaded().maximizeWindow();
    }

    public HomepageModuleFragment getModule(String title) {
        By anyModuleSelector = By.className((String)MODULE_CLASS);
        ByJQuery moduleTitleSelector = ByJQuery.selector((String)("." + MODULE_HEADER_CLASS + ":contains('" + title + "'):visible"));
        Optional<WebElement> module = this.getContentRoot().findElements(anyModuleSelector).stream().filter(arg_0 -> HomePage.lambda$getModule$0((By)moduleTitleSelector, arg_0)).findFirst();
        if (module.isPresent()) {
            return (HomepageModuleFragment)Graphene.createPageFragment(HomepageModuleFragment.class, (WebElement)module.get());
        }
        return null;
    }

    public HomepageNeedHelpSectionFragment getNeedHelpSection(String sectionLabel) {
        ByJQuery select = ByJQuery.selector((String)("." + MODULE_CLASS + ":has(." + MODULE_HEADER_CLASS + ":contains('Need Help?'))" + " ." + MODULE_COLUMN_CLASS + ":has(p:contains('" + sectionLabel + "'))"));
        WebElement sectionRoot = this.browser.findElement((By)select);
        return (HomepageNeedHelpSectionFragment)Graphene.createPageFragment(HomepageNeedHelpSectionFragment.class, (WebElement)sectionRoot);
    }

    private static /* synthetic */ boolean lambda$getModule$0(By moduleTitleSelector, WebElement anyModule) {
        return !anyModule.findElements(moduleTitleSelector).isEmpty();
    }
}

