/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.hal.testsuite.util;

import java.util.concurrent.TimeUnit;
import org.jboss.arquillian.graphene.Graphene;
import org.jboss.hal.testsuite.util.Console;
import org.openqa.selenium.By;
import org.openqa.selenium.TimeoutException;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebElement;

public class Workaround {
    private WebDriver browser;

    public static Workaround withBrowser(WebDriver browser) {
        Workaround workaround = new Workaround();
        workaround.browser = browser;
        return workaround;
    }

    public void clickLinkUntilWindowIsOpened(WebElement link, By selector) {
        boolean done = false;
        int attempts = 10;
        do {
            --attempts;
            try {
                link.click();
                Graphene.waitGui().until().element(selector).is().present();
                done = true;
            }
            catch (TimeoutException e) {
                if (attempts != 0) continue;
                throw e;
            }
        } while (!done && attempts > 0);
    }

    public void waitUntilWindowIsClosed(int windowCount, boolean fail) {
        Graphene.waitGui().withTimeout(1L, TimeUnit.SECONDS);
        int newWindowCount = Console.withBrowser(this.browser).getWindowCount();
        if (fail && newWindowCount >= windowCount) {
            throw new TimeoutException();
        }
    }
}

