/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.hal.testsuite.creaper.command.messaging;

import java.util.List;
import org.wildfly.extras.creaper.core.CommandFailedException;
import org.wildfly.extras.creaper.core.online.OnlineManagementClient;
import org.wildfly.extras.creaper.core.online.operations.Address;
import org.wildfly.extras.creaper.core.online.operations.Operations;

final class MessagingUtils {
    static final String DEFAULT_SERVER_NAME = "default";

    private MessagingUtils() {
    }

    static Address address(OnlineManagementClient client, String serverName) throws CommandFailedException {
        Operations ops = new Operations(client);
        Address hornetqAddress = Address.subsystem((String)"messaging").and("hornetq-server", serverName);
        Address artemisAddress = Address.subsystem((String)"messaging-activemq").and("server", serverName);
        Address selectedAddress = null;
        try {
            if (ops.exists(artemisAddress)) {
                selectedAddress = artemisAddress;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            if (ops.exists(hornetqAddress)) {
                selectedAddress = hornetqAddress;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (selectedAddress == null) {
            throw new CommandFailedException("The messaging server '" + serverName + "' doesn't exist. Does the ActiveMQ or HornetQ messaging subsystem exist?");
        }
        return selectedAddress;
    }

    static String getStringOfEntries(List<String> jndiEntries) {
        StringBuilder result = new StringBuilder();
        for (int i = 0; i < jndiEntries.size(); ++i) {
            result.append(jndiEntries.get(i));
            if (i == jndiEntries.size() - 1) continue;
            result.append(" ");
        }
        return result.toString();
    }
}

