/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.hal.testsuite.dmr;

import java.util.Arrays;
import org.jboss.dmr.ModelNode;
import org.jboss.hal.testsuite.cli.Library;
import org.jboss.hal.testsuite.dmr.Dispatcher;
import org.jboss.hal.testsuite.dmr.DmrResponse;
import org.jboss.hal.testsuite.dmr.Operation;
import org.jboss.hal.testsuite.dmr.ResourceAddress;
import org.junit.Assert;

public class ResourceVerifier {
    private final Dispatcher dispatcher;

    public ResourceVerifier(Dispatcher dispatcher) {
        this.dispatcher = dispatcher;
    }

    public void verifyResource(ResourceAddress address) {
        this.verifyResource(address, true);
    }

    public void verifyResource(ResourceAddress address, int timeout) {
        this.verifyResource(address, true, timeout);
    }

    public void verifyResource(ResourceAddress address, boolean expected) {
        this.verifyResource(address, expected, 0);
    }

    public void verifyResource(ResourceAddress address, boolean expected, int timeout) {
        Operation operation = new Operation.Builder("read-resource", address).withTimeout(timeout).build();
        Assert.assertEquals((Object)expected, (Object)this.dispatcher.execute(operation).isSuccessful());
    }

    public void verifyAttribute(ResourceAddress address, String attribute, boolean expected) {
        this.verifyAttribute(address, attribute, expected, 0);
    }

    public void verifyAttribute(ResourceAddress address, String attribute, boolean expected, int timeout) {
        DmrResponse response = this.dispatcher.execute(this.readAttributeOperation(address, attribute));
        long start = System.currentTimeMillis();
        while (System.currentTimeMillis() <= start + (long)timeout && expected != response.payload().asBoolean()) {
            response = this.getResponseAndWait(address, attribute);
        }
        Assert.assertTrue((boolean)response.isSuccessful());
        Assert.assertEquals((Object)expected, (Object)response.payload().asBoolean());
    }

    public void verifyAttribute(ResourceAddress address, String attribute, String[] expected) {
        this.verifyAttribute(address, attribute, expected, 0);
    }

    public void verifyAttribute(ResourceAddress address, String attribute, String[] expected, int timeout) {
        DmrResponse response = this.dispatcher.execute(this.readAttributeOperation(address, attribute));
        long start = System.currentTimeMillis();
        Object[] values = (String[])response.payload().asList().stream().map(ModelNode::asString).toArray(String[]::new);
        while (System.currentTimeMillis() <= start + (long)timeout && !Arrays.equals(expected, values)) {
            response = this.getResponseAndWait(address, attribute);
            values = (String[])response.payload().asList().stream().map(ModelNode::asString).toArray(String[]::new);
        }
        Assert.assertTrue((boolean)response.isSuccessful());
        Assert.assertArrayEquals((Object[])expected, (Object[])values);
    }

    public void verifyAttribute(ResourceAddress address, String attribute, String expected) {
        this.verifyAttribute(address, attribute, expected, 0);
    }

    public void verifyAttribute(ResourceAddress address, String attribute, String expected, int timeout) {
        DmrResponse response = this.dispatcher.execute(this.readAttributeOperation(address, attribute));
        long start = System.currentTimeMillis();
        while (System.currentTimeMillis() <= start + (long)timeout && !expected.equals(response.payload().asString())) {
            response = this.getResponseAndWait(address, attribute);
        }
        Assert.assertTrue((boolean)response.isSuccessful());
        Assert.assertEquals((Object)expected, (Object)response.payload().asString());
    }

    private Operation readAttributeOperation(ResourceAddress address, String attribute) {
        return new Operation.Builder("read-attribute", address).param("name", attribute).build();
    }

    private DmrResponse getResponseAndWait(ResourceAddress address, String attribute) {
        Library.letsSleep(50L);
        DmrResponse response = this.dispatcher.execute(this.readAttributeOperation(address, attribute));
        return response;
    }
}

