/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.hal.testsuite.fragment.shared.table;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.jboss.arquillian.graphene.Graphene;
import org.jboss.arquillian.graphene.findby.ByJQuery;
import org.jboss.hal.testsuite.fragment.BaseFragment;
import org.jboss.hal.testsuite.fragment.PagerFragment;
import org.jboss.hal.testsuite.fragment.shared.table.ResourceTableRowFragment;
import org.jboss.hal.testsuite.util.PropUtils;
import org.openqa.selenium.By;
import org.openqa.selenium.WebElement;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ResourceTableFragment
extends BaseFragment {
    private static final Logger log = LoggerFactory.getLogger(ResourceTableFragment.class);
    public static final By SELECTOR = By.className((String)PropUtils.get("resourcetable.class"));
    private static final By SELECTOR_PAGER = By.xpath((String)("./following::table[contains(@class, '" + PagerFragment.CLASS_NAME_PAGER + "')]"));
    private PagerFragment pager = null;

    public ResourceTableRowFragment getRow(int index) {
        ResourceTableRowFragment row = null;
        if (this.hasPager()) {
            this.getPager().goToFirstPage();
            do {
                if (this.getPager().getCurrentFromNumber() <= index + 1 && index + 1 <= this.getPager().getCurrentToNumber()) {
                    row = this.getVisibleRow(index - this.getPager().getCurrentFromNumber());
                    break;
                }
                log.trace("Trying to move to next page");
            } while (this.getPager().goToNextPage());
        } else {
            row = this.getVisibleRow(index);
        }
        if (row != null) {
            log.debug("Row with index {} found.", (Object)index);
        } else {
            log.debug("No row with index {} at this table.", (Object)index);
        }
        return row;
    }

    public ResourceTableRowFragment getVisibleRow(int index) {
        List<WebElement> rowElements = this.getRowElements();
        if (0 <= index && index < rowElements.size()) {
            return (ResourceTableRowFragment)Graphene.createPageFragment(ResourceTableRowFragment.class, (WebElement)rowElements.get(index));
        }
        return null;
    }

    public ResourceTableRowFragment getLastRow() {
        List<WebElement> rowElements;
        if (this.hasPager()) {
            this.getPager().goToLastPage();
        }
        if (!(rowElements = this.getRowElements()).isEmpty()) {
            WebElement rowRoot = rowElements.get(rowElements.size() - 1);
            return (ResourceTableRowFragment)Graphene.createPageFragment(ResourceTableRowFragment.class, (WebElement)rowRoot);
        }
        return null;
    }

    public List<ResourceTableRowFragment> getVisibleRows() {
        List<WebElement> rowElements = this.getRowElements();
        ArrayList<ResourceTableRowFragment> rows = new ArrayList<ResourceTableRowFragment>(rowElements.size());
        for (WebElement e : rowElements) {
            rows.add((ResourceTableRowFragment)Graphene.createPageFragment(ResourceTableRowFragment.class, (WebElement)e));
        }
        return rows;
    }

    public List<ResourceTableRowFragment> getAllRows() {
        ArrayList<ResourceTableRowFragment> rows = new ArrayList<ResourceTableRowFragment>();
        if (!this.hasPager()) {
            return this.getVisibleRows();
        }
        this.getPager().goToFirstPage();
        do {
            log.trace("Adding all visible rows to all rows list");
            rows.addAll(this.getVisibleRows());
        } while (this.getPager().goToNextPage());
        return rows;
    }

    public ResourceTableRowFragment getRowByText(int col, String text) {
        By selector = this.getRowByTextSelector(col, text);
        ResourceTableRowFragment row = null;
        if (this.hasPager()) {
            this.getPager().goToFirstPage();
            do {
                List rowsWithText;
                if (!(rowsWithText = this.root.findElements(selector)).isEmpty()) {
                    log.debug("Row with text <{}> at column {} found.", (Object)text, (Object)col);
                    row = (ResourceTableRowFragment)Graphene.createPageFragment(ResourceTableRowFragment.class, (WebElement)((WebElement)rowsWithText.get(0)));
                    break;
                }
                log.trace("Row with text <{}> at column {} not found on this page of table.", (Object)text, (Object)col);
                log.trace("Trying to move to next page");
            } while (this.getPager().goToNextPage());
        } else {
            List rowsWithText = this.root.findElements(selector);
            if (!rowsWithText.isEmpty()) {
                row = (ResourceTableRowFragment)Graphene.createPageFragment(ResourceTableRowFragment.class, (WebElement)((WebElement)rowsWithText.get(0)));
            }
        }
        if (row != null) {
            log.debug("Row with text <{}> at column {} found.", (Object)text, (Object)col);
        } else {
            log.debug("Row with text <{}> at column {} not found at this table.", (Object)text, (Object)col);
        }
        return row;
    }

    public ResourceTableRowFragment selectRowByText(int col, String text) {
        ResourceTableRowFragment row = this.getRowByText(col, text);
        if (row != null) {
            row.click();
            Graphene.waitModel().withTimeout(1500L, TimeUnit.MILLISECONDS);
        }
        return row;
    }

    public boolean hasPager() {
        return !this.root.findElements(SELECTOR_PAGER).isEmpty();
    }

    public PagerFragment getPager() {
        if (this.pager == null && this.hasPager()) {
            log.debug("Creating pager fragment");
            WebElement pagerElement = this.root.findElement(SELECTOR_PAGER);
            this.pager = (PagerFragment)Graphene.createPageFragment(PagerFragment.class, (WebElement)pagerElement);
        }
        return this.pager;
    }

    private List<WebElement> getRowElements(boolean fail) {
        ByJQuery selector = new ByJQuery("tr.cellTableEvenRow, tr.cellTableOddRow");
        List rowElements = this.root.findElements((By)selector);
        if (rowElements.isEmpty()) {
            log.warn("Table is empty");
        }
        return rowElements;
    }

    private List<WebElement> getRowElements() {
        return this.getRowElements(true);
    }

    private By getRowByTextSelector(int col, String text) {
        String row = "tr[contains(@class, 'cellTableEvenRow') or contains(@class, 'cellTableOddRow')]";
        String cell = "td[contains(@class, 'cellTableCell')]";
        String containsText = "*[contains(text(), '" + text + "')]";
        By selector = By.xpath((String)(".//" + row + "//" + cell + "[" + (col + 1) + "]" + "/descendant-or-self::" + containsText + "/ancestor::" + row));
        return selector;
    }

    public List<String> getTextInColumn(int col) {
        ArrayList<String> values = new ArrayList<String>();
        List<ResourceTableRowFragment> rows = this.getAllRows();
        for (ResourceTableRowFragment row : rows) {
            values.add(row.getCellValue(col));
        }
        return values;
    }
}

