/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.hal.testsuite.page;

import java.util.List;
import org.jboss.arquillian.drone.api.annotation.Drone;
import org.jboss.arquillian.graphene.Graphene;
import org.jboss.arquillian.graphene.findby.ByJQuery;
import org.jboss.arquillian.graphene.findby.FindByJQuery;
import org.jboss.arquillian.graphene.wait.IsElementBuilder;
import org.jboss.hal.testsuite.cli.Library;
import org.jboss.hal.testsuite.fragment.ConfigFragment;
import org.jboss.hal.testsuite.fragment.MessageListEntry;
import org.jboss.hal.testsuite.fragment.NavigationFragment;
import org.jboss.hal.testsuite.fragment.NotificationCenterFragment;
import org.jboss.hal.testsuite.fragment.config.navigation.ViewNavigation;
import org.jboss.hal.testsuite.fragment.rhaccess.RHAccessHeaderFragment;
import org.jboss.hal.testsuite.fragment.shared.layout.Footer;
import org.jboss.hal.testsuite.fragment.shared.layout.HeaderTabs;
import org.jboss.hal.testsuite.fragment.shared.table.InfoTable;
import org.jboss.hal.testsuite.fragment.shared.util.ResourceManager;
import org.jboss.hal.testsuite.util.Console;
import org.jboss.hal.testsuite.util.PropUtils;
import org.openqa.selenium.By;
import org.openqa.selenium.NoSuchElementException;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.support.FindBy;

public abstract class BasePage {
    @Drone
    protected WebDriver browser;
    @FindByJQuery(value="#header-links-section")
    private HeaderTabs headerNavigation;
    private NavigationFragment navigation;
    private NotificationCenterFragment notification;
    @FindBy(className="footer-panel")
    private Footer footer;
    private static By INFO_TABLE_SELECTOR = By.className((String)PropUtils.get("infotable.class"));
    private static By INFO_TABLE_2ND_SELECTOR = ByJQuery.selector((String)("." + PropUtils.get("infotable.class") + ":eq(2)"));
    private static By ROOT_SELECTOR = ByJQuery.selector((String)("#" + PropUtils.get("page.content.id") + ":visible"));
    private static By PARENT_ROOT_SELECTOR = ByJQuery.selector((String)("." + PropUtils.get("page.content.parent.class") + ":visible"));

    public HeaderTabs getHeaderNavigation() {
        return this.headerNavigation;
    }

    public NavigationFragment getNavigation() {
        if (this.navigation != null) {
            return this.navigation;
        }
        ByJQuery selector = ByJQuery.selector((String)"#main-content-area div [role='navigation']");
        WebElement navigationRoot = this.browser.findElement((By)selector);
        this.navigation = (NavigationFragment)Graphene.createPageFragment(NavigationFragment.class, (WebElement)navigationRoot);
        return this.navigation;
    }

    public Footer getFooter() {
        return this.footer;
    }

    public WebElement getButton(String identifier) {
        ByJQuery selector = ByJQuery.selector((String)("button#" + identifier + ":visible," + "button:contains('" + identifier + "'):visible," + "div.btn:contains('" + identifier + "'):visible"));
        WebElement button = this.getContentRoot().findElement((By)selector);
        return button;
    }

    public void clickButton(String label) {
        WebElement button = this.getButton(label);
        button.click();
    }

    public void switchTab(String identifier) {
        WebElement tab = this.getTab(identifier);
        tab.click();
        this.waitUntilTabActive(identifier);
    }

    public void switchSubTab(String identifier) {
        WebElement subTab = this.getSubTab(identifier);
        subTab.click();
        Graphene.waitGui().until().element(subTab).attribute("class").contains("link-bar-active");
        Console.withBrowser(this.browser).waitUntilLoaded();
    }

    private WebElement getSubTab(String identifier) {
        ByJQuery selector = ByJQuery.selector((String)("div.inline-link:contains('" + identifier + "'):visible"));
        return this.browser.findElement((By)selector);
    }

    protected WebElement getTab(String identifier) {
        String idSelector = ".gwt-TabLayoutPanelTab[id$='" + identifier + "']";
        String labelSelector = ".gwt-TabLayoutPanelTab:contains('" + identifier + "')";
        ByJQuery selector = ByJQuery.selector((String)(idSelector + ", " + labelSelector));
        WebElement tab = this.browser.findElement((By)selector);
        return tab;
    }

    protected void waitUntilTabIsPresent(String identifier) {
        String idSelector = ".gwt-TabLayoutPanelTab[id$='" + identifier + "']";
        String labelSelector = ".gwt-TabLayoutPanelTab:contains('" + identifier + "')";
        ByJQuery selector = ByJQuery.selector((String)(idSelector + ", " + labelSelector));
        Graphene.waitGui().until().element((By)selector).is().present();
    }

    protected void waitUntilTabIsNotPresent(String identifier) {
        String idSelector = ".gwt-TabLayoutPanelTab[id$='" + identifier + "']";
        String labelSelector = ".gwt-TabLayoutPanelTab:contains('" + identifier + "')";
        ByJQuery selector = ByJQuery.selector((String)(idSelector + ", " + labelSelector));
        ((IsElementBuilder)Graphene.waitGui().until().element((By)selector).is().not()).present();
    }

    protected void waitUntilTabActive(String identifier) {
        String idSelectorSelected = ".gwt-TabLayoutPanelTab-selected[id$='" + identifier + "']";
        String labelSelectorSelected = ".gwt-TabLayoutPanelTab-selected:contains('" + identifier + "')";
        ByJQuery selectorCurrent = ByJQuery.selector((String)(idSelectorSelected + ", " + labelSelectorSelected));
        Graphene.waitAjax().until().element((By)selectorCurrent).is().present();
    }

    public ViewNavigation getViewNavigation() {
        By selector = By.className((String)PropUtils.get("page.content.viewnav.class"));
        WebElement root = this.getContentRoot().findElement(selector);
        ViewNavigation viewNavigation = (ViewNavigation)Graphene.createPageFragment(ViewNavigation.class, (WebElement)root);
        return viewNavigation;
    }

    public void switchView(String identifier) {
        ViewNavigation viewNavigation = this.getViewNavigation();
        viewNavigation.switchView(identifier);
    }

    public WebElement getContentRoot() {
        WebElement contentRoot;
        try {
            contentRoot = this.browser.findElement(ROOT_SELECTOR);
        }
        catch (NoSuchElementException e) {
            contentRoot = this.browser.findElement(PARENT_ROOT_SELECTOR);
        }
        return contentRoot;
    }

    public List<MessageListEntry> getMessages() {
        return this.getNotificationArea().openMessagesList().getMessagesAsData();
    }

    public boolean hasMessages() {
        return this.getNotificationArea().openMessagesList().hasMessages();
    }

    public void clearMessages() {
        this.getNotificationArea().openMessagesList().clear();
    }

    public NotificationCenterFragment getNotificationArea() {
        if (this.notification == null) {
            WebElement e = this.browser.findElement(By.className((String)NotificationCenterFragment.CLASS_ROOT));
            this.notification = (NotificationCenterFragment)Graphene.createPageFragment(NotificationCenterFragment.class, (WebElement)e);
        }
        return this.notification;
    }

    public RHAccessHeaderFragment getRedHatAccessArea() {
        List candidates = this.browser.findElements(By.className((String)RHAccessHeaderFragment.CLASS_ROOT));
        for (WebElement candidate : candidates) {
            if (!candidate.getText().contains("Red Hat Access")) continue;
            return (RHAccessHeaderFragment)Graphene.createPageFragment(RHAccessHeaderFragment.class, (WebElement)candidate);
        }
        return null;
    }

    public InfoTable getInfoTable() {
        WebElement root = this.getContentRoot().findElement(INFO_TABLE_SELECTOR);
        InfoTable table = (InfoTable)Graphene.createPageFragment(InfoTable.class, (WebElement)root);
        return table;
    }

    public InfoTable get2ndInfoTable() {
        WebElement root = this.getContentRoot().findElement(INFO_TABLE_2ND_SELECTOR);
        InfoTable table = (InfoTable)Graphene.createPageFragment(InfoTable.class, (WebElement)root);
        return table;
    }

    public ResourceManager getResourceManager() {
        return (ResourceManager)Graphene.createPageFragment(ResourceManager.class, (WebElement)this.getContentRoot());
    }

    public void navigate() {
        this.browser.navigate().refresh();
        Graphene.goTo(this.getClass());
        Console.withBrowser(this.browser).waitUntilLoaded();
    }

    public BasePage selectMenu(String label) {
        String cellSelectedClass = PropUtils.get("table.cell.selected.class");
        By selector = this.getMenuEqualsSelector(label);
        this.getContentRoot().findElement(selector).click();
        Graphene.waitModel().until().element(selector).attribute("class").contains(cellSelectedClass);
        Library.letsSleep(1000L);
        return this;
    }

    public ConfigFragment getConfigFragment() {
        WebElement editPanel = this.browser.findElement(By.className((String)"default-tabpanel"));
        return (ConfigFragment)Graphene.createPageFragment(ConfigFragment.class, (WebElement)editPanel);
    }

    protected By getMenuEqualsSelector(String label) {
        return this.getMenuSelector(" and text()='" + label + "']]");
    }

    protected By getMenuContainsSelector(String label) {
        return this.getMenuSelector(" and contains(.,'" + label + "')]]");
    }

    private By getMenuSelector(String xpathSuffix) {
        String cellClass = PropUtils.get("table.cell.class");
        return By.ByXPath.xpath((String)("//td[contains(@class,'" + cellClass + "') and descendant::div[@class='navigation-column-item'" + xpathSuffix));
    }
}

