/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.hal.testsuite.creaper;

import org.wildfly.extras.creaper.core.online.OnlineCommand;
import org.wildfly.extras.creaper.core.online.OnlineCommandContext;
import org.wildfly.extras.creaper.core.online.operations.Address;
import org.wildfly.extras.creaper.core.online.operations.Operations;
import org.wildfly.extras.creaper.core.online.operations.Values;

public final class AddJMSBridge
implements OnlineCommand {
    private String name;
    private boolean replaceExisting;
    private QualityOfService qualityOfService;
    private int failureRetryInterval;
    private int maxRetries;
    private int maxBatchSize;
    private int maxBatchTime;
    private String sourceConnectionFactory;
    private String sourceDestination;
    private Values sourceContext;
    private String targetConnectionFactory;
    private String targetDestination;
    private Values targetContext;

    private AddJMSBridge(Builder builder) {
        this.name = builder.name;
        this.replaceExisting = builder.replaceExisting;
        this.qualityOfService = builder.qualityOfService;
        this.failureRetryInterval = builder.failureRetryInterval;
        this.maxRetries = builder.maxRetries;
        this.maxBatchSize = builder.maxBatchSize;
        this.maxBatchTime = builder.maxBatchTime;
        this.sourceConnectionFactory = builder.sourceConnectionFactory;
        this.sourceDestination = builder.sourceDestination;
        this.sourceContext = builder.sourceContext;
        this.targetConnectionFactory = builder.targetConnectionFactory;
        this.targetDestination = builder.targetDestination;
        this.targetContext = builder.targetContext;
    }

    public void apply(OnlineCommandContext ctx) throws Exception {
        Address address = Address.subsystem((String)"messaging-activemq").and("jms-bridge", this.name);
        Operations operations = new Operations(ctx.client);
        if (this.replaceExisting) {
            operations.removeIfExists(address);
        }
        Values params = Values.of((String)"quality-of-service", (String)this.qualityOfService.getStringValue()).and("failure-retry-interval", this.failureRetryInterval).and("max-retries", this.maxRetries).and("max-batch-size", this.maxBatchSize).and("max-batch-time", this.maxBatchTime).and("source-connection-factory", this.sourceConnectionFactory).and("source-destination", this.sourceDestination).and("target-connection-factory", this.targetConnectionFactory).and("target-destination", this.targetDestination);
        if (this.sourceContext != null) {
            params.andObject("source-context", this.sourceContext);
        }
        if (this.targetContext != null) {
            params.andObject("target-context", this.targetContext);
        }
        operations.add(address, params);
    }

    public String toString() {
        return "Command for adding JMS Bridge named '" + this.name + "' with attributes: {replaceExisting=" + this.replaceExisting + ", qualityOfService=" + (Object)((Object)this.qualityOfService) + ", failureRetryInterval=" + this.failureRetryInterval + ", maxRetries=" + this.maxRetries + ", maxBatchSize=" + this.maxBatchSize + ", maxBatchTime=" + this.maxBatchTime + ", sourceConnectionFactory='" + this.sourceConnectionFactory + '\'' + ", sourceDestination='" + this.sourceDestination + '\'' + ", sourceContext=" + this.sourceContext + ", targetConnectionFactory='" + this.targetConnectionFactory + '\'' + ", targetDestination='" + this.targetDestination + '\'' + ", targetContext=" + this.targetContext + '}';
    }

    public static final class Builder {
        private String name;
        private boolean replaceExisting;
        private QualityOfService qualityOfService;
        private int failureRetryInterval;
        private int maxRetries;
        private int maxBatchSize;
        private int maxBatchTime;
        private String sourceConnectionFactory;
        private String sourceDestination;
        private Values sourceContext;
        private String targetConnectionFactory;
        private String targetDestination;
        private Values targetContext;

        public Builder(String name) {
            this.name = name;
        }

        public Builder qualityOfService(QualityOfService qualityOfService) {
            this.qualityOfService = qualityOfService;
            return this;
        }

        public Builder failureRetryInterval(int failureRetryInterval) {
            this.failureRetryInterval = failureRetryInterval;
            return this;
        }

        public Builder maxRetries(int maxRetries) {
            this.maxRetries = maxRetries;
            return this;
        }

        public Builder maxBatchSize(int maxBatchSize) {
            this.maxBatchSize = maxBatchSize;
            return this;
        }

        public Builder maxBatchTime(int maxBatchTime) {
            this.maxBatchTime = maxBatchTime;
            return this;
        }

        public Builder sourceConnectionFactory(String sourceConnectionFactory) {
            this.sourceConnectionFactory = sourceConnectionFactory;
            return this;
        }

        public Builder sourceDestination(String sourceDestination) {
            this.sourceDestination = sourceDestination;
            return this;
        }

        public Builder sourceContext(Values sourceContext) {
            this.sourceContext = sourceContext;
            return this;
        }

        public Builder targetConnectionFactory(String targetConnectionFactory) {
            this.targetConnectionFactory = targetConnectionFactory;
            return this;
        }

        public Builder targetDestination(String targetDestination) {
            this.targetDestination = targetDestination;
            return this;
        }

        public Builder targetContext(Values targetContext) {
            this.targetContext = targetContext;
            return this;
        }

        public Builder replaceExisting() {
            this.replaceExisting = true;
            return this;
        }

        public AddJMSBridge build() {
            return new AddJMSBridge(this);
        }
    }

    public static enum QualityOfService {
        AT_MOST_ONCE("AT_MOST_ONCE"),
        DUPLICATES_OK("DUPLICATES_OK"),
        ONCE_AND_ONLY_ONCE("ONCE_AND_ONLY_ONCE");

        private String stringValue;

        private QualityOfService(String stringValue) {
            this.stringValue = stringValue;
        }

        public String getStringValue() {
            return this.stringValue;
        }
    }
}

