/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.hal.testsuite.dmr;

import java.util.Collection;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.Property;
import org.jboss.hal.testsuite.dmr.ResourceAddress;

public class Operation
extends ModelNode {
    private final int timeout;

    public Operation() {
        this("whoami", new ResourceAddress(), new ModelNode(), "", 0);
    }

    protected Operation(String name, ResourceAddress address, ModelNode parameter, String role, int timeout) {
        this.get("operation").set(name);
        this.get("address").set((ModelNode)address);
        if (parameter.isDefined()) {
            for (Property property : parameter.asPropertyList()) {
                this.get(property.getName()).set(property.getValue());
            }
        }
        if (role != null && !name.equals("whoami")) {
            this.get("operation-headers").get("roles").set(role);
        }
        this.timeout = timeout;
    }

    public int getTimeout() {
        return this.timeout;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Operation)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        Operation operation = (Operation)((Object)o);
        return this.getTimeout() == operation.getTimeout();
    }

    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + this.getTimeout();
        return result;
    }

    public static class Builder {
        private final String name;
        private final ResourceAddress address;
        private final ModelNode parameter;
        private String role;
        private int timeout;

        public Builder(String name, ResourceAddress address) {
            this.address = address;
            this.name = name;
            this.parameter = new ModelNode();
        }

        public Builder param(String name, boolean value) {
            this.parameter.get(name).set(value);
            return this;
        }

        public Builder param(String name, int value) {
            this.parameter.get(name).set(value);
            return this;
        }

        public Builder param(String name, long value) {
            this.parameter.get(name).set(value);
            return this;
        }

        public Builder param(String name, double value) {
            this.parameter.get(name).set(value);
            return this;
        }

        public Builder param(String name, String value) {
            this.parameter.get(name).set(value);
            return this;
        }

        public Builder param(String name, ModelNode value) {
            this.parameter.get(name).set(value);
            return this;
        }

        public Builder param(String name, Collection<ModelNode> value) {
            this.parameter.get(name).set(value);
            return this;
        }

        public Builder runAs(String role) {
            this.role = role;
            return this;
        }

        public Builder withTimeout(int timeout) {
            this.timeout = timeout;
            return this;
        }

        public Operation build() {
            return new Operation(this.name, this.address, this.parameter, this.role, this.timeout);
        }
    }
}

