/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.hal.testsuite.fragment.formeditor;

import com.gargoylesoftware.htmlunit.ElementNotFoundException;
import java.util.List;
import org.jboss.arquillian.graphene.findby.ByJQuery;
import org.openqa.selenium.By;
import org.openqa.selenium.WebElement;

public class RadioButtonGroup {
    private List<WebElement> choices;

    public RadioButtonGroup(String name, WebElement root) {
        ByJQuery selector = ByJQuery.selector((String)("input:radio[name=" + name + "]"));
        this.choices = root.findElements((By)selector);
    }

    public WebElement getInputElement(int i) {
        return this.choices.get(i);
    }

    public WebElement getInputElement(String value) throws ElementNotFoundException {
        for (WebElement input : this.choices) {
            if (!input.getAttribute("value").equals(value)) continue;
            return input;
        }
        throw new ElementNotFoundException("radio-input", "value", value);
    }

    public void pick(int index) {
        this.getInputElement(index).click();
    }

    public void pick(String value) {
        this.getInputElement(value).click();
    }

    public int getSelectedIndex() {
        int i = 0;
        for (WebElement choice : this.choices) {
            if (choice.isSelected()) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public String getValue() {
        return this.getInputElement(this.getSelectedIndex()).getAttribute("value");
    }
}

