/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.hal.testsuite.fragment.shared.modal;

import java.util.concurrent.TimeUnit;
import org.jboss.arquillian.graphene.Graphene;
import org.jboss.arquillian.graphene.wait.IsElementBuilder;
import org.jboss.hal.testsuite.fragment.WindowFragment;
import org.jboss.hal.testsuite.util.Console;
import org.jboss.hal.testsuite.util.PropUtils;
import org.junit.Assert;
import org.openqa.selenium.By;
import org.openqa.selenium.SearchContext;
import org.openqa.selenium.TimeoutException;
import org.openqa.selenium.WebDriverException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WizardWindow
extends WindowFragment {
    private static final Logger log = LoggerFactory.getLogger(WizardWindow.class);

    public void next() {
        String label = PropUtils.get("modals.wizard.next.label");
        this.clickButton(label);
        Console.withBrowser(this.browser).waitUntilFinished();
    }

    public void back() {
        String label = PropUtils.get("modals.wizard.back.label");
        this.clickButton(label);
        Console.withBrowser(this.browser).waitUntilFinished();
    }

    public boolean save() {
        this.clickSave();
        return this.isWizardClosed();
    }

    public State saveWithState() {
        this.clickSave();
        return this.getWizardState();
    }

    public boolean saveAndDismissReloadRequiredWindow() {
        this.clickSave();
        this.dismissReloadRequiredWindow();
        return this.isWizardClosed();
    }

    public State saveAndDismissReloadRequiredWindowWithState() {
        this.clickSave();
        this.dismissReloadRequiredWindow();
        return this.getWizardState();
    }

    public boolean finish() {
        this.chooseAndClickFinishingButton();
        return this.isWizardClosed();
    }

    public State finishWithState() {
        this.chooseAndClickFinishingButton();
        return this.getWizardState();
    }

    public boolean finishAndDismissReloadRequiredWindow() {
        this.chooseAndClickFinishingButton();
        this.dismissReloadRequiredWindow();
        return this.isWizardClosed();
    }

    public State finishAndDismissReloadRequiredWindowWithState() {
        this.chooseAndClickFinishingButton();
        this.dismissReloadRequiredWindow();
        return this.getWizardState();
    }

    public boolean cancelAndDismissReloadRequiredWindow() {
        this.clickCancel();
        this.dismissReloadRequiredWindow();
        return this.isWizardClosed();
    }

    public State cancelAndDismissReloadRequiredWindowWithState() {
        this.clickCancel();
        this.dismissReloadRequiredWindow();
        return this.getWizardState();
    }

    public boolean closeAndDismissReloadRequiredWindow() {
        this.clickWindowCloseButton();
        this.dismissReloadRequiredWindow();
        return this.isWizardClosed();
    }

    public State closeAndDismissReloadRequiredWindowWithState() {
        this.clickWindowCloseButton();
        this.dismissReloadRequiredWindow();
        return this.getWizardState();
    }

    private void clickDoneButton() {
        String label = PropUtils.get("modals.wizard.done.label");
        this.clickButton(label);
    }

    private void clickFinishButton() {
        String label = PropUtils.get("modals.wizard.finish.label");
        this.clickButton(label);
    }

    private void chooseAndClickFinishingButton() {
        try {
            this.clickFinishButton();
        }
        catch (WebDriverException e) {
            try {
                this.clickDoneButton();
            }
            catch (WebDriverException ex) {
                this.clickSave();
            }
        }
    }

    private void dismissReloadRequiredWindow() {
        Console.withBrowser(this.browser).dismissReloadRequiredWindowIfPresent();
    }

    private boolean isWizardClosed() {
        try {
            ((IsElementBuilder)Graphene.waitModel().until().element(this.root).is().not()).present();
            this.closed = true;
            log.debug("Wizard window finished (should be closed)");
            return true;
        }
        catch (TimeoutException e) {
            log.debug("Wizard window remains open");
            return false;
        }
    }

    public void assertFinish(boolean expected) {
        boolean finished = this.finish();
        if (expected) {
            Assert.assertTrue((String)"Wizard was supposed to finish, the window should be closed.", (boolean)finished);
        } else {
            Assert.assertFalse((String)"Wizard was supposed to fail, the window should be open.", (boolean)finished);
        }
    }

    public void waitUntilFinished() {
        By selector = By.className((String)PropUtils.get("modals.window.spinner.class"));
        Graphene.waitGui().withTimeout(1200L, TimeUnit.MILLISECONDS);
        ((IsElementBuilder)Graphene.waitModel().until().element((SearchContext)this.root, selector).is().not()).visible();
    }

    private State getWizardState() {
        return new State(this.isWizardClosed() ? InnerState.CLOSED : InnerState.OPEN);
    }

    private static enum InnerState {
        CLOSED,
        OPEN;

    }

    public static final class State {
        private final InnerState state;

        private State(InnerState state) {
            this.state = state;
        }

        public void assertWindowClosed() {
            this.assertWindowClosed(null);
        }

        public void assertWindowClosed(String messageSuffix) {
            Assert.assertEquals((String)("Wizard was supposed to finish, the window should be closed." + (messageSuffix == null || messageSuffix.isEmpty() ? "" : " " + messageSuffix)), (Object)((Object)InnerState.CLOSED), (Object)((Object)this.state));
        }

        public void assertWindowOpen() {
            Assert.assertEquals((String)"Wizard was supposed to fail, the window should be open.", (Object)((Object)InnerState.OPEN), (Object)((Object)this.state));
        }
    }
}

