/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.hal.testsuite.fragment.shared.modal;

import java.util.List;
import java.util.stream.Collectors;
import org.jboss.hal.testsuite.fragment.shared.modal.WizardWindow;
import org.jboss.hal.testsuite.util.Console;
import org.jboss.hal.testsuite.util.PropUtils;
import org.openqa.selenium.By;
import org.openqa.selenium.NoSuchElementException;
import org.openqa.selenium.WebElement;

public class WizardWindowWithAdvancedSelectBoxOptions
extends WizardWindow {
    public WizardWindowWithAdvancedSelectBoxOptions pick(String label) {
        List<WebElement> elements = this.getOptionElements();
        for (WebElement elem : elements) {
            if (!elem.getText().equalsIgnoreCase(label)) continue;
            elem.click();
            Console.withBrowser(this.browser).waitUntilFinished();
            return this;
        }
        throw new NoSuchElementException("Unable to find option with value " + label);
    }

    public List<WebElement> getOptionElements() {
        String cssClass = PropUtils.get("components.selectbox.item.class");
        By selector = By.className((String)cssClass);
        return this.root.findElements(selector);
    }

    public List<String> getOptions() {
        return this.getOptionElements().stream().map(WebElement::getText).collect(Collectors.toList());
    }

    public WizardWindowWithAdvancedSelectBoxOptions clickContinue() {
        this.clickButton("Continue");
        Console.withBrowser(this.browser).waitUntilFinished();
        return this;
    }
}

