/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.hal.testsuite.page;

import java.util.Map;
import java.util.stream.Collectors;
import org.jboss.arquillian.graphene.Graphene;
import org.jboss.hal.testsuite.cli.Library;
import org.jboss.hal.testsuite.finder.Application;
import org.jboss.hal.testsuite.finder.FinderNavigation;
import org.jboss.hal.testsuite.fragment.MetricsAreaFragment;
import org.jboss.hal.testsuite.page.BasePage;
import org.jboss.hal.testsuite.page.runtime.DomainRuntimeEntryPoint;
import org.jboss.hal.testsuite.page.runtime.StandaloneRuntimeEntryPoint;
import org.jboss.hal.testsuite.util.ConfigUtils;
import org.jboss.hal.testsuite.util.PropUtils;
import org.openqa.selenium.By;
import org.openqa.selenium.NoSuchElementException;
import org.openqa.selenium.WebElement;

public abstract class MetricsPage
extends BasePage {
    public static final String MONITORED_SERVER = "server-one";

    public MetricsAreaFragment getMetricsArea(String title) {
        By selector = By.xpath((String)(".//table[contains(@class, '" + PropUtils.get("metrics.container.class") + "')][.//h3[text()='" + title + "']]"));
        WebElement element = null;
        try {
            element = this.getContentRoot().findElements(selector).stream().filter(el -> el.isDisplayed()).findFirst().get();
        }
        catch (NoSuchElementException exc) {
            return null;
        }
        MetricsAreaFragment area = (MetricsAreaFragment)Graphene.createPageFragment(MetricsAreaFragment.class, (WebElement)element);
        Map<String, String> metricGrid = element.findElement(By.className((String)PropUtils.get("metrics.grid.class"))).findElements(By.tagName((String)"tr")).stream().collect(Collectors.toMap(e -> e.findElement(By.className((String)PropUtils.get("metrics.grid.nominal.class"))).getText(), e -> e.findElement(By.className((String)PropUtils.get("metrics.grid.numerical.class"))).getText()));
        area.setMetricGrid(metricGrid);
        return area;
    }

    public void refreshStats() {
        WebElement viewPanel = this.browser.findElements(Application.APPLICATION_PANEL).stream().filter(p -> p.isDisplayed()).findFirst().get();
        WebElement refreshLink = viewPanel.findElement(By.className((String)"html-link"));
        refreshLink.click();
        Library.letsSleep(500L);
    }

    protected void navigate2runtimeSubsystem(String subsystemLabel) {
        FinderNavigation navigation = ConfigUtils.isDomain() ? new FinderNavigation(this.browser, DomainRuntimeEntryPoint.class).step("Browse Domain By", "Hosts").step("Host", ConfigUtils.getDefaultHost()).step("Server", MONITORED_SERVER) : new FinderNavigation(this.browser, StandaloneRuntimeEntryPoint.class).step("Server", "Standalone Server");
        navigation = navigation.step("Monitor", "Subsystems").step("Subsystem", subsystemLabel);
        navigation.selectRow().invoke("View");
        Application.waitUntilVisible();
    }
}

