/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.hal.testsuite.util;

import java.io.IOException;
import java.nio.file.Path;
import java.nio.file.Paths;
import org.jboss.dmr.ModelNode;
import org.jboss.hal.testsuite.util.ConfigUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.wildfly.extras.creaper.core.online.ModelNodeResult;
import org.wildfly.extras.creaper.core.online.OnlineManagementClient;
import org.wildfly.extras.creaper.core.online.operations.Address;
import org.wildfly.extras.creaper.core.online.operations.Operations;
import org.wildfly.extras.creaper.core.online.operations.ReadAttributeOption;

public class PathOperations {
    private static final Logger log = LoggerFactory.getLogger(PathOperations.class);
    private final Operations ops;

    public PathOperations(OnlineManagementClient managementClient) {
        this.ops = new Operations(managementClient);
    }

    public String resolveFullPathForStandaloneServer(String pathName) throws IOException {
        return this.resolveFullPathForResource(pathName, Address.root());
    }

    public String resolveFullPathForDomainServerOnDefaultHost(String pathName, String serverName) throws IOException {
        return this.resolveFullPathForResource(pathName, Address.host((String)ConfigUtils.getDefaultHost()).and("server", serverName));
    }

    public String resolveFullPathForResource(String pathName, Address resourceAddress) throws IOException {
        log.debug("Resolving full path of '" + pathName + "'");
        Address pathAddress = resourceAddress.and("path", pathName);
        String path = this.ops.readAttribute(pathAddress, "path", new ReadAttributeOption[0]).stringValue();
        log.debug("Resolved path: " + path);
        ModelNodeResult relativeTo = this.ops.readAttribute(pathAddress, "relative-to", new ReadAttributeOption[0]);
        Path resolved = relativeTo.isFailed() || !relativeTo.hasDefinedValue() ? Paths.get(path, new String[0]) : Paths.get(this.resolveFullPathForResource(relativeTo.stringValue(), resourceAddress), path);
        log.debug("Resolved FULL path: " + path);
        return resolved.toString();
    }

    public Path getServerLogFile() throws IOException {
        return Paths.get(this.resolveFullPathForStandaloneServer("jboss.server.log.dir"), ((ModelNode)this.ops.readChildrenNames(Address.subsystem((String)"logging"), "log-file").listValue().get(0)).asString());
    }

    public Path getServerLogFileForDomainServerOnDefaultHost(String serverName) throws IOException {
        return Paths.get(this.resolveFullPathForDomainServerOnDefaultHost("jboss.server.log.dir", serverName), ((ModelNode)this.ops.readChildrenNames(Address.host((String)ConfigUtils.getDefaultHost()).and("server", serverName).and("subsystem", "logging"), "log-file").listValue().get(0)).asString());
    }

    public Path getModulesPath() throws IOException {
        String jbossHomeDir = "jboss.home.dir";
        String jbossHomeDirPath = ConfigUtils.isDomain() ? this.resolveFullPathForDomainServerOnDefaultHost(jbossHomeDir, "server-one") : this.resolveFullPathForStandaloneServer(jbossHomeDir);
        return Paths.get(jbossHomeDirPath, "modules");
    }
}

