/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.hal.testsuite.util;

import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.jboss.hal.testsuite.fragment.ConfigFragment;
import org.jboss.hal.testsuite.fragment.formeditor.Editor;
import org.jboss.hal.testsuite.util.Console;
import org.jboss.hal.testsuite.util.SuggestionResource;
import org.junit.Assert;
import org.openqa.selenium.Keys;
import org.openqa.selenium.TimeoutException;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebElement;

public class SuggestionChecker {
    private WebDriver browser;
    private ConfigFragment configFragment;
    private String suggestBoxInputLabel;
    private SuggestionResource suggestionResource;

    private SuggestionChecker(Builder builder) {
        this.browser = builder.browser;
        this.configFragment = builder.configFragment;
        this.suggestBoxInputLabel = builder.suggestBoxInputLabel;
        this.suggestionResource = builder.suggestionResource;
    }

    private void clearFilter() {
        WebElement textInput = this.getEditor().getText(this.suggestBoxInputLabel);
        textInput.sendKeys(new CharSequence[]{Keys.chord((CharSequence[])new CharSequence[]{Keys.CONTROL, "a"})});
        textInput.sendKeys(new CharSequence[]{Keys.DELETE});
    }

    private List<String> getSuggestedLabelsStrings() {
        try {
            return Console.withBrowser(this.browser).openedSuggestionBoxPopUp().getLabelValues();
        }
        catch (TimeoutException e) {
            return Collections.emptyList();
        }
    }

    public SuggestState filterSuggestions(String filterString) {
        this.clearFilter();
        this.getEditor().text(this.suggestBoxInputLabel, filterString);
        return new SuggestState(filterString, this.getSuggestedLabelsStrings());
    }

    public SuggestState appendSymbolToInputField(char symbol) {
        WebElement inputField = this.getEditor().getText(this.suggestBoxInputLabel);
        inputField.click();
        inputField.sendKeys(new CharSequence[]{String.valueOf(symbol)});
        return new SuggestState(inputField.getAttribute("value"), this.getSuggestedLabelsStrings());
    }

    public SuggestState removeSymbolFromInputField() {
        WebElement inputField = this.getEditor().getText(this.suggestBoxInputLabel);
        inputField.click();
        inputField.sendKeys(new CharSequence[]{Keys.BACK_SPACE});
        return new SuggestState(inputField.getAttribute("value"), this.getSuggestedLabelsStrings());
    }

    private Editor getEditor() {
        Editor editor = this.configFragment.getEditor();
        if (!this.configFragment.isInEditMode()) {
            editor = this.configFragment.edit();
        }
        return editor;
    }

    public static class Builder {
        private WebDriver browser;
        private ConfigFragment configFragment;
        private String suggestBoxInputLabel;
        private SuggestionResource suggestionResource;

        public Builder configFragment(ConfigFragment configFragment) {
            this.configFragment = configFragment;
            return this;
        }

        public Builder suggestBoxInputLabel(String suggestBoxInputLabel) {
            this.suggestBoxInputLabel = suggestBoxInputLabel;
            return this;
        }

        public Builder suggestionResource(SuggestionResource suggestionResource) {
            this.suggestionResource = suggestionResource;
            return this;
        }

        public Builder browser(WebDriver browser) {
            this.browser = browser;
            return this;
        }

        public SuggestionChecker build() {
            return new SuggestionChecker(this);
        }
    }

    public class SuggestState {
        private final String inputFieldValue;
        private final List<String> valuesLabels;

        private SuggestState(String inputFieldValue, List<String> valuesLabels) {
            this.inputFieldValue = inputFieldValue;
            if (valuesLabels == null) {
                throw new IllegalArgumentException("List of suggested items cannot be null!");
            }
            this.valuesLabels = valuesLabels;
        }

        public void verifyOnlyRelevantSuggestionWereSuggested() throws IOException {
            this.verifyOnlyRelevantSuggestionWereSuggested(null);
        }

        public void verifyOnlyRelevantSuggestionWereSuggested(String message) throws IOException {
            List filteredSuggestionFromResource = SuggestionChecker.this.suggestionResource.readSuggestions().stream().filter(suggestion -> suggestion.matches(".*(" + Pattern.quote(this.inputFieldValue) + ").*")).collect(Collectors.toList());
            Collections.sort(filteredSuggestionFromResource);
            Collections.sort(this.valuesLabels);
            Assert.assertEquals((String)("Non relevant suggestions appeared or some of the are missing, input value: '" + this.inputFieldValue + "'. Size expected: '" + filteredSuggestionFromResource.size() + "' vs. size actual: '" + this.valuesLabels.size() + "'. " + (message == null ? "" : message)), filteredSuggestionFromResource, this.valuesLabels);
        }

        public void verifyNoneSuggestionWereSuggested() {
            Assert.assertTrue((String)("There were some suggested items! Input value: '" + this.inputFieldValue + "'."), (boolean)this.valuesLabels.isEmpty());
        }
    }
}

