/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.appclient.service;

import java.io.IOException;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Set;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.PasswordCallback;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.security.sasl.RealmCallback;
import org.jboss.security.SecurityContext;
import org.jboss.security.SecurityContextAssociation;
import org.jboss.security.identity.Identity;
import org.jboss.security.identity.extensions.CredentialIdentity;

public class DefaultApplicationClientCallbackHandler
implements CallbackHandler {
    public static final String DOLLAR_LOCAL = "$local";

    @Override
    public void handle(Callback[] callbacks) throws IOException, UnsupportedCallbackException {
        SecurityContext context = AccessController.doPrivileged(DefaultApplicationClientCallbackHandler.securityContext());
        for (Callback current : callbacks) {
            RealmCallback realmCallback;
            Identity identity;
            Set identities;
            if (current instanceof NameCallback) {
                NameCallback ncb = (NameCallback)current;
                if (context != null) {
                    identities = context.getSubjectInfo().getIdentities();
                    if (identities.isEmpty()) {
                        ncb.setName(DOLLAR_LOCAL);
                        continue;
                    }
                    identity = (Identity)identities.iterator().next();
                    ncb.setName(identity.getName());
                    continue;
                }
                ncb.setName(DOLLAR_LOCAL);
                continue;
            }
            if (current instanceof PasswordCallback) {
                if (context == null) continue;
                PasswordCallback pcb = (PasswordCallback)current;
                identities = context.getSubjectInfo().getIdentities();
                if (identities.isEmpty()) {
                    throw new UnsupportedCallbackException(current);
                }
                identity = (Identity)identities.iterator().next();
                if (identity instanceof CredentialIdentity) {
                    pcb.setPassword((char[])((CredentialIdentity)identity).getCredential());
                    continue;
                }
                throw new UnsupportedCallbackException(current);
            }
            if (!(current instanceof RealmCallback) || (realmCallback = (RealmCallback)current).getText() != null) continue;
            realmCallback.setText(realmCallback.getDefaultText());
        }
    }

    private static PrivilegedAction<SecurityContext> securityContext() {
        return new PrivilegedAction<SecurityContext>(){

            @Override
            public SecurityContext run() {
                return SecurityContextAssociation.getSecurityContext();
            }
        };
    }
}

