/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.appclient.subsystem;

import java.io.PrintStream;
import org.jboss.as.appclient.logging.AppClientMessages;

enum CommandLineArgument {
    APPCLIENT_CONFIG("--appclient-config", "=<config> ", new String[0]){

        @Override
        public String instructions() {
            return AppClientMessages.MESSAGES.argAppClientConfig();
        }
    }
    ,
    HELP("--help", null, new String[]{"-h"}){

        @Override
        public String instructions() {
            return AppClientMessages.MESSAGES.argHelp();
        }
    }
    ,
    HOST("--host", "=<url>", new String[]{"-H"}){

        @Override
        public String instructions() {
            return AppClientMessages.MESSAGES.argHost();
        }
    }
    ,
    PROPERTIES("--properties", "=<url>", new String[]{"-P"}){

        @Override
        public String instructions() {
            return AppClientMessages.MESSAGES.argProperties();
        }
    }
    ,
    SYS_PROP("-D", "<name>[=value]", new String[0]){

        @Override
        public String instructions() {
            return AppClientMessages.MESSAGES.argSystemProperty();
        }
    }
    ,
    UNKNOWN("unknown", null, new String[0]){

        @Override
        public String instructions() {
            return "Unknown argument.";
        }
    }
    ,
    VERSION("--version", null, new String[]{"-v"}){

        @Override
        public String instructions() {
            return AppClientMessages.MESSAGES.argVersion();
        }
    };

    private static final String USAGE;
    private final String argument;
    private final String exampleDesc;
    private final String[] altArguments;

    private CommandLineArgument(String argument, String exampleDesc, String ... altArguments) {
        this.argument = argument;
        this.exampleDesc = exampleDesc;
        this.altArguments = altArguments;
    }

    public String argument() {
        return this.argument;
    }

    public String[] altArguments() {
        return this.altArguments;
    }

    private String argumentExample(String arg) {
        if (this.exampleDesc == null) {
            return arg;
        }
        return String.format("%s%s", arg, this.exampleDesc);
    }

    public abstract String instructions();

    public String toString() {
        StringBuilder result = new StringBuilder();
        result.append(String.format("    %-35s %s%n", this.argumentExample(this.argument), this.instructions()));
        if (this.altArguments != null && this.altArguments.length > 0) {
            for (String arg : this.altArguments) {
                result.append(String.format("%n    %-35s %s%n", this.argumentExample(arg), this.instructions()));
            }
        }
        return result.toString();
    }

    public static CommandLineArgument forArg(String arg) {
        for (CommandLineArgument argument : CommandLineArgument.values()) {
            if (arg.startsWith(argument.argument)) {
                return argument;
            }
            for (String sArg : argument.altArguments) {
                if (!arg.startsWith(sArg)) continue;
                return argument;
            }
        }
        return UNKNOWN;
    }

    public static void printUsage(PrintStream out) {
        out.print(USAGE);
    }

    public static String usage() {
        return USAGE;
    }

    static {
        StringBuilder sb = new StringBuilder();
        sb.append(AppClientMessages.MESSAGES.argUsage());
        for (CommandLineArgument arg : CommandLineArgument.values()) {
            if (arg == UNKNOWN) continue;
            sb.append(arg.toString());
        }
        USAGE = sb.toString();
    }
}

