/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.arquillian.container.domain;

import org.jboss.arquillian.container.spi.client.container.DeployableContainer;
import org.jboss.arquillian.container.spi.client.container.DeploymentException;
import org.jboss.arquillian.container.spi.client.container.LifecycleException;
import org.jboss.arquillian.container.spi.client.protocol.ProtocolDescription;
import org.jboss.arquillian.container.spi.client.protocol.metadata.ProtocolMetaData;
import org.jboss.as.arquillian.container.domain.Domain;
import org.jboss.as.arquillian.container.domain.EmptyConfiguration;
import org.jboss.as.arquillian.container.domain.ManagementClient;
import org.jboss.shrinkwrap.api.Archive;
import org.jboss.shrinkwrap.descriptor.api.Descriptor;

public class ServerContainer
implements DeployableContainer<EmptyConfiguration> {
    private ManagementClient client;
    private Domain.Server server;
    private int operationTimeout;

    public ServerContainer(ManagementClient client, Domain.Server server, int operationTimeout) {
        this.client = client;
        this.server = server;
        this.operationTimeout = operationTimeout;
    }

    public Class<EmptyConfiguration> getConfigurationClass() {
        return EmptyConfiguration.class;
    }

    public void setup(EmptyConfiguration configuration) {
    }

    public void start() throws LifecycleException {
        this.client.startServer(this.server);
        this.waitForServerToStart();
    }

    public void stop() throws LifecycleException {
        this.client.stopServer(this.server);
        this.waitForServerToStop();
    }

    public ProtocolDescription getDefaultProtocol() {
        return new ProtocolDescription("Servlet 3.0");
    }

    public ProtocolMetaData deploy(Archive<?> archive) throws DeploymentException {
        throw new UnsupportedOperationException("Can not deploy to a single server in the domain, target server-group " + this.server.getGroup());
    }

    public void undeploy(Archive<?> archive) throws DeploymentException {
        throw new UnsupportedOperationException("Can not undeploy from a single server in the domain, target server-group " + this.server.getGroup());
    }

    public void deploy(Descriptor descriptor) throws DeploymentException {
        throw new UnsupportedOperationException("Can not deploy to a single server in the domain, target server-group " + this.server.getGroup());
    }

    public void undeploy(Descriptor descriptor) throws DeploymentException {
        throw new UnsupportedOperationException("Can not undeploy from a single server in the domain, target server-group " + this.server.getGroup());
    }

    private void waitForServerToStart() {
        this.waitForServerState(true);
    }

    private void waitForServerToStop() {
        this.waitForServerState(false);
    }

    private void waitForServerState(boolean shouldBeStarted) {
        long timeout;
        long sleep = 100L;
        for (timeout = (long)(this.operationTimeout * 1000); timeout > 0L && shouldBeStarted != this.client.isServerStarted(this.server); timeout -= sleep) {
            try {
                Thread.sleep(sleep);
                continue;
            }
            catch (InterruptedException e) {
                throw new RuntimeException("Failed waiting for server to " + (shouldBeStarted ? "start" : "stop"), e);
            }
        }
        if (timeout <= 0L) {
            throw new RuntimeException("Server did not " + (shouldBeStarted ? "start" : "stop") + " within set timeout [serverOperationTimeoutInSeconds=" + this.operationTimeout + "]. " + this.server);
        }
    }
}

