/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.arquillian.container.domain.managed;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeoutException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.management.MBeanServerConnection;
import javax.management.remote.JMXConnector;
import javax.management.remote.JMXConnectorFactory;
import javax.management.remote.JMXServiceURL;
import org.jboss.as.arquillian.container.domain.managed.JBossAsManagedConfiguration;
import org.jboss.as.controller.client.Operation;
import org.jboss.as.controller.client.OperationBuilder;
import org.jboss.as.controller.client.helpers.domain.DomainClient;
import org.jboss.as.controller.client.helpers.domain.ServerIdentity;
import org.jboss.as.controller.client.helpers.domain.ServerStatus;
import org.jboss.dmr.ModelNode;

public class DomainLifecycleUtil {
    private static final ThreadFactory threadFactory = new AsyncThreadFactory();
    private final Logger log = Logger.getLogger(DomainLifecycleUtil.class.getName());
    private Process process;
    private Thread shutdownThread;
    private final JBossAsManagedConfiguration configuration;
    private DomainClient domainClient;
    private Map<ServerIdentity, ServerStatus> serverStatuses = new HashMap<ServerIdentity, ServerStatus>();
    private Map<ServerIdentity, MBeanServerConnectionProvider> jmxConnectionProviders = new HashMap<ServerIdentity, MBeanServerConnectionProvider>();
    private Map<ServerIdentity, MBeanServerConnection> jmxConnections = new HashMap<ServerIdentity, MBeanServerConnection>();
    private MBeanServerConnectionProvider[] providers;
    private ExecutorService executor;

    public DomainLifecycleUtil(JBossAsManagedConfiguration configuration) {
        assert (configuration != null) : "configuration is null";
        this.configuration = configuration;
    }

    public void start() {
        try {
            this.configuration.validate();
            String jbossHomeDir = this.configuration.getJbossHome();
            String additionalJavaOpts = System.getProperty("jboss.options");
            File modulesJar = new File(jbossHomeDir + "/jboss-modules.jar");
            if (!modulesJar.exists()) {
                throw new IllegalStateException("Cannot find: " + modulesJar);
            }
            String javaHome = this.configuration.getJavaHome();
            String java = javaHome != null ? javaHome + "/bin/java" : "java";
            File domainDir = this.configuration.getDomainDirectory() != null ? new File(this.configuration.getDomainDirectory()) : new File(new File(jbossHomeDir), "domain");
            String domainPath = domainDir.getAbsolutePath();
            String modulePath = this.configuration.getModulePath() != null && !this.configuration.getModulePath().isEmpty() ? this.configuration.getModulePath() : jbossHomeDir + "/modules";
            ArrayList<String> cmd = new ArrayList<String>();
            cmd.add(java);
            if (additionalJavaOpts != null) {
                for (String opt : additionalJavaOpts.split("\\s+")) {
                    cmd.add(opt);
                }
            }
            cmd.add("-Djboss.home.dir=" + jbossHomeDir);
            cmd.add("-Dorg.jboss.boot.log.file=" + domainPath + "/log/process-controller.log");
            cmd.add("-Dlogging.configuration=file:" + jbossHomeDir + "/domain/configuration/logging.properties");
            cmd.add("-jar");
            cmd.add(modulesJar.getAbsolutePath());
            cmd.add("-mp");
            cmd.add(modulePath);
            cmd.add("-logmodule");
            cmd.add("org.jboss.logmanager");
            cmd.add("org.jboss.as.process-controller");
            cmd.add("-jboss-home");
            cmd.add(jbossHomeDir);
            cmd.add("-jvm");
            cmd.add(java);
            cmd.add("--");
            cmd.add("-Dorg.jboss.boot.log.file=" + domainPath + "/log/host-controller.log");
            cmd.add("-Dlogging.configuration=file:" + jbossHomeDir + "/domain/configuration/logging.properties");
            if (additionalJavaOpts != null) {
                for (String opt : additionalJavaOpts.split("\\s+")) {
                    cmd.add(opt);
                }
            }
            cmd.add("--");
            cmd.add("-default-jvm");
            cmd.add(java);
            if (this.configuration.getDomainConfigFile() != null) {
                cmd.add("-domain-config");
                cmd.add(this.configuration.getDomainConfigFile());
            }
            if (this.configuration.getHostConfigFile() != null) {
                cmd.add("-host-config");
                cmd.add(this.configuration.getHostConfigFile());
            }
            if (this.configuration.getHostCommandLineProperties() != null) {
                for (String opt : this.configuration.getHostCommandLineProperties().split("\\s+")) {
                    cmd.add(opt);
                }
            }
            if (this.configuration.getDomainDirectory() != null) {
                cmd.add("-Djboss.domain.base.dir=" + this.configuration.getDomainDirectory());
            }
            this.log.info("Starting container with: " + ((Object)cmd).toString());
            ProcessBuilder processBuilder = new ProcessBuilder(cmd);
            processBuilder.redirectErrorStream(true);
            long start = System.currentTimeMillis();
            this.process = processBuilder.start();
            new Thread(new ConsoleConsumer()).start();
            final Process proc = this.process;
            this.shutdownThread = new Thread(new Runnable(){

                @Override
                public void run() {
                    if (proc != null) {
                        proc.destroy();
                        try {
                            proc.waitFor();
                        }
                        catch (InterruptedException e) {
                            throw new RuntimeException(e);
                        }
                    }
                }
            });
            Runtime.getRuntime().addShutdownHook(this.shutdownThread);
            long timeout = this.configuration.getStartupTimeoutInSeconds() * 1000;
            boolean serversAvailable = false;
            while (timeout > 0L && !serversAvailable) {
                serversAvailable = this.areServersStarted();
                if (serversAvailable) continue;
                Thread.sleep(100L);
                timeout -= 100L;
            }
            if (!serversAvailable) {
                throw new TimeoutException(String.format("Managed servers were not started within [%d] seconds", this.configuration.getStartupTimeoutInSeconds()));
            }
            this.log.info("All servers started in " + (System.currentTimeMillis() - start) + " ms");
            HashMap<Object, MBeanServerConnection> connections = new HashMap<Object, MBeanServerConnection>();
            for (Map.Entry<ServerIdentity, ServerStatus> entry : this.serverStatuses.entrySet()) {
                switch (entry.getValue()) {
                    case STARTED: {
                        connections.put(entry.getKey(), null);
                    }
                }
            }
            this.log.info("Awaiting mbeanServer connections for " + connections.keySet());
            int available = 0;
            int enabledCount = connections.size();
            while (timeout > 0L && available < enabledCount) {
                for (Map.Entry entry : connections.entrySet()) {
                    if (entry.getValue() != null) continue;
                    try {
                        MBeanServerConnectionProvider provider = this.getMBeanServerConnectionProvider((ServerIdentity)entry.getKey());
                        MBeanServerConnection mbeanServer = provider == null ? null : provider.getConnection();
                        if (mbeanServer == null) continue;
                        connections.put(entry.getKey(), mbeanServer);
                        ++available;
                    }
                    catch (Exception ignore) {
                        this.log.severe(String.format("Failed accessing mbean server on %s: %s", entry.getKey(), ignore));
                    }
                }
                if (available >= enabledCount) continue;
                long sleep = 100L;
                Thread.sleep(100L);
                timeout -= 100L;
            }
            if (available < enabledCount) {
                ArrayList notStartedServers = new ArrayList();
                for (Map.Entry entry : connections.entrySet()) {
                    if (entry.getValue() != null) continue;
                    notStartedServers.add(entry.getKey());
                }
                throw new TimeoutException(String.format("Could not connect to the managed server's MBeanServer for servers %s within [%d] seconds", notStartedServers.toString(), this.configuration.getStartupTimeoutInSeconds()));
            }
            this.log.info("All containers available");
        }
        catch (Exception e) {
            throw new RuntimeException("Could not start container", e);
        }
    }

    public Future<Void> startAsync() {
        Callable<Void> c = new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                DomainLifecycleUtil.this.start();
                return null;
            }
        };
        return this.getExecutorService().submit(c);
    }

    public void stop() {
        if (this.shutdownThread != null) {
            Runtime.getRuntime().removeShutdownHook(this.shutdownThread);
            this.shutdownThread = null;
        }
        try {
            if (this.process != null) {
                this.process.destroy();
                this.process.waitFor();
                this.process = null;
            }
        }
        catch (Exception e) {
            throw new RuntimeException("Could not stop container", e);
        }
        finally {
            this.safeCloseDomainClient();
            ExecutorService exec = this.executor;
            if (exec != null) {
                exec.shutdownNow();
                this.executor = null;
            }
        }
    }

    public Future<Void> stopAsync() {
        Callable<Void> c = new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                DomainLifecycleUtil.this.stop();
                return null;
            }
        };
        return Executors.newSingleThreadExecutor(threadFactory).submit(c);
    }

    public synchronized DomainClient getDomainClient() {
        if (this.domainClient == null) {
            try {
                InetAddress managementAddress = InetAddress.getByName(this.configuration.getHostControllerManagementAddress());
                this.domainClient = DomainClient.Factory.create((InetAddress)managementAddress, (int)this.configuration.getHostControllerManagementPort());
            }
            catch (UnknownHostException e) {
                throw new RuntimeException(e);
            }
        }
        return this.domainClient;
    }

    private synchronized ExecutorService getExecutorService() {
        if (this.executor == null) {
            this.executor = Executors.newSingleThreadExecutor(threadFactory);
        }
        return this.executor;
    }

    private boolean areServersStarted() {
        try {
            Map<ServerIdentity, ServerStatus> statuses = this.getServerStatuses();
            block5: for (Map.Entry<ServerIdentity, ServerStatus> entry : statuses.entrySet()) {
                switch (entry.getValue()) {
                    case STARTED: 
                    case DISABLED: {
                        continue block5;
                    }
                }
                return false;
            }
            this.serverStatuses.putAll(statuses);
            return true;
        }
        catch (Exception exception) {
            return false;
        }
    }

    private synchronized void safeCloseDomainClient() {
        if (this.domainClient != null) {
            try {
                this.domainClient.close();
            }
            catch (IOException e) {
                this.log.log(Level.SEVERE, "Caught exception closing DomainClient", e);
            }
        }
    }

    private Map<ServerIdentity, ServerStatus> getServerStatuses() {
        HashMap<ServerIdentity, ServerStatus> result = new HashMap<ServerIdentity, ServerStatus>();
        ModelNode op = new ModelNode();
        op.get("operation").set("read-children-names");
        op.get("child-type").set("server-config");
        op.get("address").add("host", this.configuration.getHostName());
        ModelNode opResult = this.executeForResult(new OperationBuilder(op).build());
        HashSet<String> servers = new HashSet<String>();
        for (ModelNode modelNode : opResult.asList()) {
            servers.add(modelNode.asString());
        }
        for (String string : servers) {
            ModelNode address = new ModelNode();
            address.add("host", this.configuration.getHostName());
            address.add("server-config", string);
            String group = this.readAttribute("group", address).asString();
            ServerStatus status = Enum.valueOf(ServerStatus.class, this.readAttribute("status", address).asString());
            ServerIdentity id = new ServerIdentity(this.configuration.getHostName(), group, string);
            result.put(id, status);
        }
        return result;
    }

    private ModelNode readAttribute(String name, ModelNode address) {
        ModelNode op = new ModelNode();
        op.get("operation").set("read-attribute");
        op.get("address").set(address);
        op.get("name").set(name);
        return this.executeForResult(new OperationBuilder(op).build());
    }

    private ModelNode executeForResult(ModelNode op) {
        return this.executeForResult(new OperationBuilder(op).build());
    }

    private ModelNode executeForResult(Operation op) {
        try {
            ModelNode result = this.getDomainClient().execute(op);
            if (result.hasDefined("outcome") && "success".equals(result.get("outcome").asString())) {
                return result.get("result");
            }
            if (result.hasDefined("failure-description")) {
                throw new RuntimeException(result.get("failure-description").toString());
            }
            if (result.hasDefined("domain-failure-description")) {
                throw new RuntimeException(result.get("domain-failure-description").toString());
            }
            if (result.hasDefined("host-failure-descriptions")) {
                throw new RuntimeException(result.get("host-failure-descriptions").toString());
            }
            throw new RuntimeException("Operation outcome is " + result.get("outcome").asString());
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private MBeanServerConnectionProvider getMBeanServerConnectionProvider(ServerIdentity server) throws IOException {
        ModelNode op = new ModelNode();
        op.get("operation").set("read-children-names");
        ModelNode opAddr = op.get("address");
        opAddr.add("host", server.getHostName());
        opAddr.add("server", server.getServerName());
        op.get("child-type").set("socket-binding-group");
        ModelNode result = this.executeForResult(op);
        String groupName = ((ModelNode)result.asList().get(0)).asString();
        op = new ModelNode();
        op.get("operation").set("read-attribute");
        opAddr = op.get("address");
        opAddr.add("host", server.getHostName());
        opAddr.add("server", server.getServerName());
        opAddr.add("socket-binding-group", groupName);
        opAddr.add("socket-binding", "jmx-connector-registry");
        op.get("name").set("bound");
        result = this.executeForResult(op);
        if (result.asBoolean(false)) {
            op.get("name").set("bound-address");
            String address = this.executeForResult(op).asString();
            op.get("name").set("bound-port");
            int port = this.executeForResult(op).asInt();
            return new MBeanServerConnectionProvider(InetAddress.getByName(address), port);
        }
        return null;
    }

    public static void main(String[] args) throws Exception {
        DomainLifecycleUtil starterUtil = new DomainLifecycleUtil(new JBossAsManagedConfiguration());
        starterUtil.start();
        System.out.println("--------- STARTED");
        starterUtil.stop();
        System.out.println("--------- STOPPED");
    }

    private static final class AsyncThreadFactory
    implements ThreadFactory {
        private int threadCount;

        private AsyncThreadFactory() {
        }

        @Override
        public Thread newThread(Runnable r) {
            Thread t = new Thread(r, DomainLifecycleUtil.class.getSimpleName() + "-" + ++this.threadCount);
            t.setDaemon(true);
            return t;
        }
    }

    public final class MBeanServerConnectionProvider {
        private final InetAddress hostAddr;
        private final int port;
        private JMXConnector jmxConnector;

        public MBeanServerConnectionProvider(InetAddress hostAddr, int port) {
            this.hostAddr = hostAddr;
            this.port = port;
        }

        public MBeanServerConnection getConnection() {
            String host = this.hostAddr.getHostAddress();
            String urlString = System.getProperty("jmx.service.url", "service:jmx:rmi:///jndi/rmi://" + host + ":" + this.port + "/jmxrmi");
            try {
                if (this.jmxConnector == null) {
                    DomainLifecycleUtil.this.log.fine("Connecting JMXConnector to: " + urlString);
                    JMXServiceURL serviceURL = new JMXServiceURL(urlString);
                    this.jmxConnector = JMXConnectorFactory.connect(serviceURL, null);
                }
                return this.jmxConnector.getMBeanServerConnection();
            }
            catch (IOException ex) {
                throw new IllegalStateException("Cannot obtain MBeanServerConnection to: " + urlString, ex);
            }
        }
    }

    private class ConsoleConsumer
    implements Runnable {
        private ConsoleConsumer() {
        }

        @Override
        public void run() {
            InputStream stream = DomainLifecycleUtil.this.process.getInputStream();
            BufferedReader reader = new BufferedReader(new InputStreamReader(stream));
            boolean writeOutput = AccessController.doPrivileged(new PrivilegedAction<Boolean>(){

                @Override
                public Boolean run() {
                    String val = System.getProperty("org.jboss.as.writeconsole");
                    return val == null || !"false".equals(val);
                }
            });
            String line = null;
            try {
                while ((line = reader.readLine()) != null) {
                    if (!writeOutput) continue;
                    System.out.println(line);
                }
            }
            catch (IOException e) {
                // empty catch block
            }
        }
    }
}

