/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.cli.handlers;

import java.io.File;
import java.util.List;
import org.jboss.as.cli.CommandContext;
import org.jboss.as.cli.EscapeSelector;
import org.jboss.as.cli.Util;
import org.jboss.as.cli.handlers.FilenameTabCompleter;

public class DefaultFilenameTabCompleter
extends FilenameTabCompleter {
    public static final DefaultFilenameTabCompleter INSTANCE = new DefaultFilenameTabCompleter();
    private static final EscapeSelector ESCAPE_SELECTOR = new EscapeSelector(){

        @Override
        public boolean isEscape(char ch) {
            return ch == '\\' || ch == ' ' || ch == '\"';
        }
    };

    @Override
    public int complete(CommandContext ctx, String buffer, int cursor, List<String> candidates) {
        int lastSeparator;
        int result = this.getCandidates(buffer, candidates);
        int correction = 0;
        if (buffer.length() > 0 && (lastSeparator = buffer.lastIndexOf(File.separatorChar)) > 0) {
            String path = buffer.substring(0, lastSeparator);
            String escaped = Util.escapeString(path, ESCAPE_SELECTOR);
            correction = escaped.length() - path.length();
        }
        if (candidates.size() == 1) {
            candidates.set(0, Util.escapeString(candidates.get(0), ESCAPE_SELECTOR));
        } else {
            Util.sortAndEscape(candidates, ESCAPE_SELECTOR);
        }
        return result + correction;
    }
}

