/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.cli.handlers;

import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.jboss.as.cli.CommandContext;
import org.jboss.as.cli.CommandLineCompleter;
import org.jboss.as.cli.ParsedArguments;
import org.jboss.as.cli.Util;
import org.jboss.as.cli.handlers.BatchModeCommandHandler;
import org.jboss.as.cli.handlers.DefaultFilenameTabCompleter;
import org.jboss.as.cli.handlers.FilenameTabCompleter;
import org.jboss.as.cli.handlers.SimpleArgumentTabCompleter;
import org.jboss.as.cli.handlers.WindowsFilenameTabCompleter;
import org.jboss.as.cli.impl.ArgumentWithValue;
import org.jboss.as.cli.impl.ArgumentWithoutValue;
import org.jboss.as.cli.operation.OperationFormatException;
import org.jboss.as.cli.operation.impl.DefaultOperationRequestBuilder;
import org.jboss.as.controller.client.ModelControllerClient;
import org.jboss.as.controller.client.OperationBuilder;
import org.jboss.as.protocol.StreamUtils;
import org.jboss.dmr.ModelNode;

public class DeployHandler
extends BatchModeCommandHandler {
    private final ArgumentWithoutValue force;
    private final ArgumentWithoutValue l;
    private final ArgumentWithoutValue path;
    private final ArgumentWithoutValue name;
    private final ArgumentWithoutValue rtName;
    private final ArgumentWithValue serverGroups;
    private final ArgumentWithoutValue allServerGroups;
    private final ArgumentWithoutValue disabled;

    public DeployHandler() {
        super("deploy", true);
        SimpleArgumentTabCompleter argsCompleter = (SimpleArgumentTabCompleter)this.getArgumentCompleter();
        this.l = new ArgumentWithoutValue("-l");
        this.l.setExclusive(true);
        argsCompleter.addArgument(this.l);
        FilenameTabCompleter pathCompleter = Util.isWindows() ? WindowsFilenameTabCompleter.INSTANCE : DefaultFilenameTabCompleter.INSTANCE;
        this.path = new ArgumentWithValue(false, pathCompleter, 0, new String[]{"--path"}){

            @Override
            public String getValue(ParsedArguments args) {
                String value = super.getValue(args);
                if (value != null && value.length() >= 0 && value.charAt(0) == '\"' && value.charAt(value.length() - 1) == '\"') {
                    value = value.substring(1, value.length() - 1);
                }
                return value;
            }
        };
        this.path.addCantAppearAfter(this.l);
        argsCompleter.addArgument(this.path);
        this.force = new ArgumentWithoutValue("--force", "-f");
        this.force.addRequiredPreceding(this.path);
        argsCompleter.addArgument(this.force);
        this.name = new ArgumentWithValue(new CommandLineCompleter(){

            @Override
            public int complete(CommandContext ctx, String buffer, int cursor, List<String> candidates) {
                int nextCharIndex;
                ParsedArguments args = ctx.getParsedArguments();
                if (DeployHandler.this.path.isPresent(args)) {
                    return -1;
                }
                for (nextCharIndex = 0; nextCharIndex < buffer.length() && Character.isWhitespace(buffer.charAt(nextCharIndex)); ++nextCharIndex) {
                }
                if (ctx.getModelControllerClient() != null) {
                    List<String> deployments = Util.getDeployments(ctx.getModelControllerClient());
                    if (deployments.isEmpty()) {
                        return -1;
                    }
                    String opBuffer = buffer.substring(nextCharIndex).trim();
                    if (opBuffer.isEmpty()) {
                        candidates.addAll(deployments);
                    } else {
                        for (String name : deployments) {
                            if (!name.startsWith(opBuffer)) continue;
                            candidates.add(name);
                        }
                        Collections.sort(candidates);
                    }
                    return nextCharIndex;
                }
                return -1;
            }
        }, "--name");
        this.path.addCantAppearAfter(this.l);
        this.path.addCantAppearAfter(this.name);
        argsCompleter.addArgument(this.name);
        this.rtName = new ArgumentWithValue("--runtime-name");
        this.rtName.addRequiredPreceding(this.path);
        argsCompleter.addArgument(this.rtName);
        this.allServerGroups = new ArgumentWithoutValue(new String[]{"--all-server-groups"}){

            @Override
            public boolean canAppearNext(CommandContext ctx) {
                if (!ctx.isDomainMode()) {
                    return false;
                }
                return super.canAppearNext(ctx);
            }
        };
        argsCompleter.addArgument(this.allServerGroups);
        this.allServerGroups.addRequiredPreceding(this.path);
        this.allServerGroups.addRequiredPreceding(this.name);
        this.serverGroups = new ArgumentWithValue(false, new CommandLineCompleter(){

            @Override
            public int complete(CommandContext ctx, String buffer, int cursor, List<String> candidates) {
                int result;
                String chunk;
                int lastGroupIndex;
                List<String> allGroups = Util.getServerGroups(ctx.getModelControllerClient());
                if (buffer.isEmpty()) {
                    candidates.addAll(allGroups);
                    Collections.sort(candidates);
                    return 0;
                }
                String[] groups = buffer.split(",+");
                if (buffer.charAt(buffer.length() - 1) == ',') {
                    lastGroupIndex = groups.length;
                    chunk = null;
                } else {
                    lastGroupIndex = groups.length - 1;
                    chunk = groups[groups.length - 1];
                }
                for (int i = 0; i < lastGroupIndex; ++i) {
                    allGroups.remove(groups[i]);
                }
                if (chunk == null) {
                    candidates.addAll(allGroups);
                    result = buffer.length();
                } else {
                    for (String group : allGroups) {
                        if (!group.startsWith(chunk)) continue;
                        candidates.add(group);
                    }
                    result = buffer.lastIndexOf(44) + 1;
                }
                Collections.sort(candidates);
                return result;
            }
        }, new String[]{"--server-groups"}){

            @Override
            public boolean canAppearNext(CommandContext ctx) {
                if (!ctx.isDomainMode()) {
                    return false;
                }
                return super.canAppearNext(ctx);
            }
        };
        argsCompleter.addArgument(this.serverGroups);
        this.serverGroups.addRequiredPreceding(this.path);
        this.serverGroups.addRequiredPreceding(this.name);
        this.serverGroups.addCantAppearAfter(this.allServerGroups);
        this.allServerGroups.addCantAppearAfter(this.serverGroups);
        this.disabled = new ArgumentWithoutValue("--disabled");
        argsCompleter.addArgument(this.disabled);
        this.disabled.addRequiredPreceding(this.path);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void doHandle(CommandContext ctx) {
        ModelNode result;
        DefaultOperationRequestBuilder builder;
        String name;
        ParsedArguments args;
        ModelControllerClient client;
        block38: {
            String runtimeName;
            File f;
            block34: {
                block37: {
                    block35: {
                        ModelNode result2;
                        client = ctx.getModelControllerClient();
                        args = ctx.getParsedArguments();
                        boolean l = this.l.isPresent(args);
                        if (!args.hasArguments() || l) {
                            this.printList(ctx, Util.getDeployments(client), l);
                            return;
                        }
                        String path = this.path.getValue(args);
                        if (path != null) {
                            f = new File(path);
                            if (!f.exists()) {
                                ctx.printLine("Path " + f.getAbsolutePath() + " doesn't exist.");
                                return;
                            }
                        } else {
                            f = null;
                        }
                        if ((name = this.name.getValue(args)) == null) {
                            if (f == null) {
                                ctx.printLine("Either path or --name is requied.");
                                return;
                            }
                            name = f.getName();
                        }
                        runtimeName = this.rtName.getValue(args);
                        if (!Util.isDeploymentInRepository(name, client) || f == null) break block34;
                        if (!this.force.isPresent(args)) break block35;
                        DefaultOperationRequestBuilder builder2 = new DefaultOperationRequestBuilder();
                        builder2 = new DefaultOperationRequestBuilder();
                        builder2.setOperationName("full-replace-deployment");
                        builder2.addProperty("name", name);
                        if (runtimeName != null) {
                            builder2.addProperty("runtime-name", runtimeName);
                        }
                        FileInputStream is = null;
                        try {
                            is = new FileInputStream(f);
                            ModelNode request = builder2.buildRequest();
                            OperationBuilder op = OperationBuilder.Factory.create((ModelNode)request);
                            op.addInputStream((InputStream)is);
                            request.get("content").get(0).get("input-stream-index").set(0);
                            result2 = client.execute(op.build());
                        }
                        catch (Exception e) {
                            try {
                                ctx.printLine("Failed to replace the deployment: " + e.getLocalizedMessage());
                            }
                            catch (Throwable throwable) {
                                StreamUtils.safeClose(is);
                                throw throwable;
                            }
                            StreamUtils.safeClose((Closeable)is);
                            return;
                        }
                        StreamUtils.safeClose((Closeable)is);
                        if (!Util.isSuccess(result2)) {
                            ctx.printLine(Util.getFailureDescription(result2));
                            return;
                        }
                        ctx.printLine("'" + name + "' re-deployed successfully.");
                        break block37;
                    }
                    ctx.printLine("'" + name + "' is already deployed (use " + this.force.getDefaultName() + " to force re-deploy).");
                }
                return;
            }
            if (f == null) break block38;
            builder = new DefaultOperationRequestBuilder();
            builder.setOperationName("add");
            builder.addNode("deployment", name);
            if (runtimeName != null) {
                builder.addProperty("runtime-name", runtimeName);
            }
            FileInputStream is = null;
            try {
                is = new FileInputStream(f);
                ModelNode request = builder.buildRequest();
                OperationBuilder op = OperationBuilder.Factory.create((ModelNode)request);
                op.addInputStream((InputStream)is);
                request.get("content").get(0).get("input-stream-index").set(0);
                result = client.execute(op.build());
            }
            catch (Exception e) {
                try {
                    ctx.printLine("Failed to add the deployment content to the repository: " + e.getLocalizedMessage());
                }
                catch (Throwable throwable) {
                    StreamUtils.safeClose(is);
                    throw throwable;
                }
                StreamUtils.safeClose((Closeable)is);
                return;
            }
            StreamUtils.safeClose((Closeable)is);
            if (!Util.isSuccess(result)) {
                ctx.printLine(Util.getFailureDescription(result));
                return;
            }
        }
        if (!this.disabled.isPresent(args)) {
            ModelNode request;
            if (ctx.isDomainMode()) {
                List<String> serverGroups;
                if (ctx.isDomainMode()) {
                    if (this.allServerGroups.isPresent(args)) {
                        serverGroups = Util.getServerGroups(client);
                    } else {
                        String serverGroupsStr = this.serverGroups.getValue(args);
                        if (serverGroupsStr == null) {
                            ctx.printLine("Either --all-server-groups or --server-groups must be specified.");
                            return;
                        }
                        serverGroups = Arrays.asList(serverGroupsStr.split(","));
                    }
                    if (serverGroups.isEmpty()) {
                        ctx.printLine("No server group is available.");
                        return;
                    }
                } else {
                    serverGroups = null;
                }
                request = new ModelNode();
                request.get("operation").set("composite");
                request.get("address").setEmptyList();
                ModelNode steps = request.get("steps");
                for (String serverGroup : serverGroups) {
                    steps.add(Util.configureDeploymentOperation("add", name, serverGroup));
                }
                for (String serverGroup : serverGroups) {
                    steps.add(Util.configureDeploymentOperation("deploy", name, serverGroup));
                }
            } else {
                builder = new DefaultOperationRequestBuilder();
                builder.setOperationName("deploy");
                builder.addNode("deployment", name);
                try {
                    request = builder.buildRequest();
                }
                catch (Exception e) {
                    ctx.printLine("Failed to deploy: " + e.getLocalizedMessage());
                    return;
                }
            }
            try {
                result = client.execute(request);
            }
            catch (Exception e) {
                ctx.printLine("Failed to deploy: " + e.getLocalizedMessage());
                return;
            }
            if (!Util.isSuccess(result)) {
                ctx.printLine(Util.getFailureDescription(result));
                return;
            }
        }
        ctx.printLine("'" + name + "' deployed successfully.");
    }

    @Override
    public ModelNode buildRequest(CommandContext ctx) throws OperationFormatException {
        List<String> serverGroups;
        String filePath;
        ParsedArguments args = ctx.getParsedArguments();
        if (!args.hasArguments()) {
            throw new OperationFormatException("Required arguments are missing.");
        }
        try {
            filePath = this.path.getValue(args);
        }
        catch (IllegalArgumentException e) {
            throw new OperationFormatException("Missing required path argument.");
        }
        String name = this.name.getValue(args);
        String runtimeName = this.rtName.getValue(args);
        File f = new File(filePath);
        if (!f.exists()) {
            throw new OperationFormatException(f.getAbsolutePath() + " doesn't exist.");
        }
        if (name == null) {
            name = f.getName();
        }
        if (Util.isDeploymentInRepository(name, ctx.getModelControllerClient())) {
            if (this.force.isPresent(args)) {
                DefaultOperationRequestBuilder builder = new DefaultOperationRequestBuilder();
                builder = new DefaultOperationRequestBuilder();
                builder.setOperationName("full-replace-deployment");
                builder.addProperty("name", name);
                if (runtimeName != null) {
                    builder.addProperty("runtime-name", runtimeName);
                }
                byte[] bytes = this.readBytes(f);
                builder.getModelNode().get("bytes").set(bytes);
                return builder.buildRequest();
            }
            throw new OperationFormatException("'" + name + "' is already deployed (use -f to force re-deploy).");
        }
        if (ctx.isDomainMode()) {
            if (this.allServerGroups.isPresent(args)) {
                serverGroups = Util.getServerGroups(ctx.getModelControllerClient());
            } else {
                String serverGroupsStr = this.serverGroups.getValue(args);
                if (serverGroupsStr == null) {
                    new OperationFormatException("Either --all-server-groups or --server-groups must be specified.");
                }
                serverGroups = Arrays.asList(serverGroupsStr.split(","));
            }
            if (serverGroups.isEmpty()) {
                new OperationFormatException("No server group is available.");
            }
        } else {
            serverGroups = null;
        }
        ModelNode composite = new ModelNode();
        composite.get("operation").set("composite");
        composite.get("address").setEmptyList();
        ModelNode steps = composite.get("steps");
        DefaultOperationRequestBuilder builder = new DefaultOperationRequestBuilder();
        builder.setOperationName("add");
        builder.addNode("deployment", name);
        if (runtimeName != null) {
            builder.addProperty("runtime-name", runtimeName);
        }
        byte[] bytes = this.readBytes(f);
        builder.getModelNode().get("bytes").set(bytes);
        steps.add(builder.buildRequest());
        if (!this.disabled.isPresent(args)) {
            if (ctx.isDomainMode()) {
                for (String serverGroup : serverGroups) {
                    steps.add(Util.configureDeploymentOperation("add", name, serverGroup));
                }
                for (String serverGroup : serverGroups) {
                    steps.add(Util.configureDeploymentOperation("deploy", name, serverGroup));
                }
            } else {
                builder = new DefaultOperationRequestBuilder();
                builder.setOperationName("deploy");
                builder.addNode("deployment", name);
                steps.add(builder.buildRequest());
            }
        }
        return composite;
    }

    protected byte[] readBytes(File f) throws OperationFormatException {
        byte[] bytes;
        FileInputStream is = null;
        try {
            is = new FileInputStream(f);
            bytes = new byte[(int)f.length()];
            int read = is.read(bytes);
            if (read != bytes.length) {
                throw new OperationFormatException("Failed to read bytes from " + f.getAbsolutePath() + ": " + read + " from " + f.length());
            }
        }
        catch (Exception e) {
            try {
                throw new OperationFormatException("Failed to read file " + f.getAbsolutePath(), e);
            }
            catch (Throwable throwable) {
                StreamUtils.safeClose(is);
                throw throwable;
            }
        }
        StreamUtils.safeClose((Closeable)is);
        return bytes;
    }
}

