/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.cli.handlers;

import java.util.List;
import org.jboss.as.cli.CommandContext;
import org.jboss.as.cli.CommandFormatException;
import org.jboss.as.cli.CommandLineCompleter;
import org.jboss.as.cli.handlers.CommandHandlerWithHelp;
import org.jboss.as.cli.handlers.SimpleArgumentTabCompleter;
import org.jboss.as.cli.impl.ArgumentWithValue;
import org.jboss.as.cli.impl.ArgumentWithoutValue;
import org.jboss.as.cli.operation.OperationRequestAddress;
import org.jboss.as.cli.operation.OperationRequestCompleter;
import org.jboss.as.cli.operation.impl.DefaultOperationCallbackHandler;
import org.jboss.as.cli.operation.impl.DefaultOperationRequestAddress;

public class LsHandler
extends CommandHandlerWithHelp {
    private final ArgumentWithValue nodePath;
    private final ArgumentWithoutValue l;

    public LsHandler() {
        this("ls");
    }

    public LsHandler(String command) {
        super(command, true);
        SimpleArgumentTabCompleter argsCompleter = (SimpleArgumentTabCompleter)this.getArgumentCompleter();
        this.l = new ArgumentWithoutValue("-l");
        argsCompleter.addArgument(this.l);
        this.nodePath = new ArgumentWithValue(false, (CommandLineCompleter)OperationRequestCompleter.INSTANCE, 0, "--node-path");
        argsCompleter.addArgument(this.nodePath);
    }

    @Override
    protected void doHandle(CommandContext ctx) {
        OperationRequestAddress address;
        String nodePath = this.nodePath.getValue(ctx.getParsedArguments());
        if (nodePath != null) {
            address = new DefaultOperationRequestAddress(ctx.getPrefix());
            DefaultOperationCallbackHandler handler = new DefaultOperationCallbackHandler(address);
            try {
                ctx.getOperationRequestParser().parse(nodePath, handler);
            }
            catch (CommandFormatException e) {
                ctx.printLine(e.getLocalizedMessage());
            }
        } else {
            address = ctx.getPrefix();
        }
        List<String> names = address.endsOnType() ? ctx.getOperationCandidatesProvider().getNodeNames(address) : ctx.getOperationCandidatesProvider().getNodeTypes(address);
        this.printList(ctx, names, this.l.isPresent(ctx.getParsedArguments()));
    }
}

