/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.cli.handlers;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jboss.as.cli.CommandArgument;
import org.jboss.as.cli.CommandContext;
import org.jboss.as.cli.CommandLineCompleter;
import org.jboss.as.cli.CommandLineException;
import org.jboss.as.cli.parsing.CommandLineParser;

public class SimpleArgumentTabCompleter
implements CommandLineCompleter {
    private final List<CommandArgument> allArgs = new ArrayList<CommandArgument>();
    private final ParsingResults results = new ParsingResults();

    public void addArgument(CommandArgument arg) {
        this.allArgs.add(arg);
    }

    @Override
    public int complete(CommandContext ctx, String buffer, int cursor, List<String> candidates) {
        int firstCharIndex;
        for (firstCharIndex = 0; firstCharIndex < buffer.length() && Character.isWhitespace(buffer.charAt(firstCharIndex)); ++firstCharIndex) {
        }
        int result = buffer.length();
        String chunk = null;
        CommandLineCompleter valueCompleter = null;
        if (firstCharIndex != result) {
            this.results.reset();
            try {
                CommandLineParser.parse(buffer, new CommandLineParser.CallbackHandler(){

                    @Override
                    public void argument(String name, int nameStart, String value, int valueStart, int end) {
                        ((SimpleArgumentTabCompleter)SimpleArgumentTabCompleter.this).results.argName = name;
                        ((SimpleArgumentTabCompleter)SimpleArgumentTabCompleter.this).results.argValue = value;
                        ((SimpleArgumentTabCompleter)SimpleArgumentTabCompleter.this).results.nameStart = nameStart;
                        ((SimpleArgumentTabCompleter)SimpleArgumentTabCompleter.this).results.valueStart = valueStart;
                        ((SimpleArgumentTabCompleter)SimpleArgumentTabCompleter.this).results.endIndex = end;
                    }
                });
            }
            catch (CommandLineException e) {
                return -1;
            }
            if (this.results.argValue != null) {
                if (this.results.argValue.isEmpty()) {
                    chunk = null;
                    result = this.results.valueStart;
                    if (this.results.argName != null) {
                        ctx.setArgumentsString(buffer.substring(0, this.results.nameStart));
                        for (CommandArgument arg : this.allArgs) {
                            if (!this.results.argName.equals(arg.getDefaultName())) continue;
                            valueCompleter = arg.getValueCompleter();
                            break;
                        }
                    } else {
                        ctx.setArgumentsString(buffer.substring(0, this.results.valueStart));
                        for (CommandArgument arg : this.allArgs) {
                            if (arg.getIndex() < 0 || !arg.canAppearNext(ctx)) continue;
                            valueCompleter = arg.getValueCompleter();
                            break;
                        }
                    }
                    if (valueCompleter == null) {
                        return -1;
                    }
                } else if (this.results.endIndex < buffer.length()) {
                    chunk = null;
                } else {
                    chunk = this.results.argValue;
                    result = this.results.valueStart;
                    if (this.results.argName != null) {
                        ctx.setArgumentsString(buffer.substring(0, this.results.nameStart));
                        for (CommandArgument arg : this.allArgs) {
                            if (!this.results.argName.equals(arg.getDefaultName())) continue;
                            valueCompleter = arg.getValueCompleter();
                            break;
                        }
                    } else {
                        ctx.setArgumentsString(buffer.substring(0, this.results.valueStart));
                        for (CommandArgument arg : this.allArgs) {
                            if (arg.getIndex() < 0 || !arg.canAppearNext(ctx)) continue;
                            valueCompleter = arg.getValueCompleter();
                            break;
                        }
                    }
                    if (valueCompleter == null) {
                        return -1;
                    }
                }
            } else if (this.results.endIndex < buffer.length()) {
                chunk = null;
            } else {
                chunk = this.results.argName;
                if (this.results.argName != null) {
                    result = this.results.nameStart;
                }
            }
        }
        if (valueCompleter != null) {
            int valueResult = valueCompleter.complete(ctx, chunk == null ? "" : chunk, cursor, candidates);
            if (valueResult < 0) {
                return valueResult;
            }
            return result + valueResult;
        }
        int charLength = buffer.length() - firstCharIndex;
        if (charLength == 1 && buffer.charAt(firstCharIndex) == '-' || charLength == 2 && '-' == buffer.charAt(firstCharIndex) && '-' == buffer.charAt(firstCharIndex + 1)) {
            ctx.setArgumentsString("");
        } else {
            ctx.setArgumentsString(buffer.substring(firstCharIndex, result));
        }
        for (CommandArgument arg : this.allArgs) {
            if (!arg.canAppearNext(ctx)) continue;
            if (arg.getIndex() >= 0) {
                CommandLineCompleter valCompl = arg.getValueCompleter();
                if (valCompl == null) continue;
                valCompl.complete(ctx, chunk == null ? "" : chunk, cursor, candidates);
                continue;
            }
            String argName = arg.getDefaultName();
            if (chunk == null) {
                if (arg.isValueRequired()) {
                    argName = argName + '=';
                }
                candidates.add(argName);
                continue;
            }
            if (!argName.startsWith(chunk)) continue;
            if (arg.isValueRequired()) {
                argName = argName + '=';
            }
            candidates.add(argName);
        }
        Collections.sort(candidates);
        return result;
    }

    private static final class ParsingResults {
        String argName;
        String argValue;
        int nameStart;
        int valueStart;
        int endIndex;

        private ParsingResults() {
        }

        void reset() {
            this.argName = null;
            this.argValue = null;
            this.nameStart = -1;
            this.valueStart = -1;
            this.endIndex = -1;
        }
    }
}

