/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.cli.operation;

import java.util.Collections;
import java.util.List;
import java.util.Set;
import jline.Completor;
import org.jboss.as.cli.CommandContext;
import org.jboss.as.cli.CommandLineCompleter;
import org.jboss.as.cli.EscapeSelector;
import org.jboss.as.cli.Util;
import org.jboss.as.cli.operation.OperationCandidatesProvider;
import org.jboss.as.cli.operation.OperationFormatException;
import org.jboss.as.cli.operation.OperationRequestAddress;
import org.jboss.as.cli.operation.impl.DefaultOperationCallbackHandler;
import org.jboss.as.cli.operation.impl.DefaultOperationRequestAddress;

public class OperationRequestCompleter
implements CommandLineCompleter,
Completor {
    public static final OperationRequestCompleter INSTANCE = new OperationRequestCompleter(null);
    private static final EscapeSelector ESCAPE_SELECTOR = new EscapeSelector(){

        @Override
        public boolean isEscape(char ch) {
            return ch == ':' || ch == '/' || ch == '=' || ch == ' ' || ch == '\"' || ch == '\\';
        }
    };
    private final CommandContext ctx;

    public OperationRequestCompleter(CommandContext ctx) {
        this.ctx = ctx;
    }

    public int complete(String buffer, int cursor, List candidates) {
        return this.complete(this.ctx, buffer, cursor, candidates);
    }

    @Override
    public int complete(CommandContext ctx, String buffer, int cursor, List<String> candidates) {
        String chunk;
        for (int firstCharIndex = 0; firstCharIndex < buffer.length() && Character.isWhitespace(buffer.charAt(firstCharIndex)); ++firstCharIndex) {
        }
        if (buffer.endsWith("..")) {
            return 0;
        }
        DefaultOperationCallbackHandler handler = new DefaultOperationCallbackHandler(new DefaultOperationRequestAddress(ctx.getPrefix()));
        try {
            ctx.getOperationRequestParser().parse(buffer, handler);
        }
        catch (OperationFormatException e1) {
            return -1;
        }
        if (handler.isRequestComplete()) {
            return -1;
        }
        if (handler.hasProperties() || handler.endsOnPropertyListStart()) {
            if (handler.endsOnPropertyValueSeparator()) {
                return -1;
            }
            OperationCandidatesProvider provider = ctx.getOperationCandidatesProvider();
            List<String> propertyNames = provider.getPropertyNames(handler.getOperationName(), handler.getAddress());
            if (propertyNames.isEmpty()) {
                if (handler.endsOnPropertyListStart()) {
                    candidates.add(")");
                    return buffer.length();
                }
                return -1;
            }
            if (handler.endsOnPropertyListStart()) {
                if (propertyNames.size() == 1) {
                    candidates.add(propertyNames.get(0) + '=');
                } else {
                    candidates.addAll(propertyNames);
                    Collections.sort(candidates);
                }
                return buffer.length();
            }
            Set<String> specifiedNames = handler.getPropertyNames();
            String chunk2 = null;
            for (String specifiedName : specifiedNames) {
                String value = handler.getPropertyValue(specifiedName);
                if (value == null) {
                    chunk2 = specifiedName;
                    continue;
                }
                propertyNames.remove(specifiedName);
            }
            if (chunk2 == null) {
                if (handler.endsOnPropertySeparator()) {
                    if (propertyNames.size() == 1) {
                        candidates.add(propertyNames.get(0) + '=');
                    } else {
                        candidates.addAll(propertyNames);
                        Collections.sort(candidates);
                    }
                } else if (propertyNames.isEmpty()) {
                    candidates.add(")");
                }
                return buffer.length();
            }
            for (String candidate : propertyNames) {
                if (!candidate.startsWith(chunk2)) continue;
                candidates.add(candidate);
            }
            if (candidates.size() == 1) {
                candidates.set(0, candidates.get(0) + '=');
            } else {
                Collections.sort(candidates);
            }
            return handler.getLastSeparatorIndex() + 1;
        }
        if (handler.hasOperationName() || handler.endsOnAddressOperationNameSeparator()) {
            if (handler.getAddress().endsOnType()) {
                return -1;
            }
            OperationCandidatesProvider provider = ctx.getOperationCandidatesProvider();
            List<String> names = provider.getOperationNames(handler.getAddress());
            if (names.isEmpty()) {
                return -1;
            }
            String chunk3 = handler.getOperationName();
            if (chunk3 == null) {
                candidates.addAll(names);
            } else {
                for (String name : names) {
                    if (chunk3 != null && !name.startsWith(chunk3)) continue;
                    candidates.add(name);
                }
            }
            Collections.sort(candidates);
            return handler.getLastSeparatorIndex() + 1;
        }
        OperationRequestAddress address = handler.getAddress();
        if (address.isEmpty() || handler.endsOnNodeSeparator() || handler.endsOnNodeTypeNameSeparator() || address.equals(ctx.getPrefix()) || buffer.endsWith("..")) {
            chunk = null;
        } else if (address.endsOnType()) {
            chunk = address.getNodeType();
            address.toParentNode();
        } else {
            chunk = address.toNodeType();
        }
        OperationCandidatesProvider provider = ctx.getOperationCandidatesProvider();
        List<String> names = address.endsOnType() ? provider.getNodeNames(address) : provider.getNodeTypes(address);
        if (names.isEmpty()) {
            return -1;
        }
        if (chunk == null) {
            candidates.addAll(names);
        } else {
            for (String name : names) {
                if (chunk != null && !name.startsWith(chunk)) continue;
                candidates.add(name);
            }
        }
        if (candidates.size() == 1) {
            if (address.endsOnType()) {
                candidates.set(0, Util.escapeString(candidates.get(0), ESCAPE_SELECTOR));
            } else {
                String onlyType = candidates.get(0);
                address.toNodeType(onlyType);
                List<String> childNames = provider.getNodeNames(address);
                if (!childNames.isEmpty()) {
                    onlyType = Util.escapeString(onlyType, ESCAPE_SELECTOR);
                    candidates.clear();
                    if (childNames.size() == 1) {
                        candidates.add(onlyType + '=' + Util.escapeString(childNames.get(0), ESCAPE_SELECTOR));
                    } else {
                        Util.sortAndEscape(childNames, ESCAPE_SELECTOR);
                        for (String name : childNames) {
                            candidates.add(onlyType + '=' + name);
                        }
                    }
                }
            }
        } else {
            Util.sortAndEscape(candidates, ESCAPE_SELECTOR);
        }
        return handler.getLastSeparatorIndex() + 1;
    }
}

