/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.cli.impl;

import java.io.BufferedInputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.jboss.as.cli.CliConfig;
import org.jboss.as.cli.CliInitializationException;
import org.jboss.as.cli.CommandContext;
import org.jboss.as.cli.SSLConfig;
import org.jboss.as.cli.impl.SecurityActions;
import org.jboss.as.protocol.StreamUtils;
import org.jboss.staxmapper.XMLElementReader;
import org.jboss.staxmapper.XMLExtendedStreamReader;
import org.jboss.staxmapper.XMLMapper;

class CliConfigImpl
implements CliConfig {
    private SSLConfig sslConfig;

    static CliConfig load(CommandContext ctx) throws CliInitializationException {
        String jbossHome = SecurityActions.getEnvironmentVariable("JBOSS_HOME");
        if (jbossHome == null) {
            System.err.println("WARN: can't load the config file because JBOSS_HOME environment variable is not set.");
            return new CliConfigImpl();
        }
        return CliConfigImpl.parse(ctx, new File(jbossHome + File.separatorChar + "bin", "jboss-cli.xml"));
    }

    static CliConfig parse(CommandContext ctx, File f) throws CliInitializationException {
        if (f == null) {
            throw new CliInitializationException("The file argument is null.");
        }
        if (!f.exists()) {
            return new CliConfigImpl();
        }
        CliConfigImpl config = new CliConfigImpl();
        BufferedInputStream input = null;
        try {
            XMLMapper mapper = XMLMapper.Factory.create();
            mapper.registerRootElement(new QName("urn:jboss:cli:1.0", "jboss-cli"), (XMLElementReader)new XMLElementReader<CliConfigImpl>(){

                public void readElement(XMLExtendedStreamReader reader, CliConfigImpl config) throws XMLStreamException {
                    boolean jbossCliEnded = false;
                    while (reader.hasNext() && !jbossCliEnded) {
                        String localName;
                        int tag = reader.nextTag();
                        if (tag == 1) {
                            localName = reader.getLocalName();
                            if (!localName.equals("ssl")) continue;
                            SslConfig sslConfig = new SslConfig();
                            this.readSSLElement(reader, sslConfig);
                            config.sslConfig = sslConfig;
                            continue;
                        }
                        if (tag != 2 || !(localName = reader.getLocalName()).equals("jboss-cli")) continue;
                        jbossCliEnded = true;
                    }
                }

                public void readSSLElement(XMLExtendedStreamReader reader, SslConfig config) throws XMLStreamException {
                    while (reader.hasNext() && reader.nextTag() != 2) {
                        String localName = reader.getLocalName();
                        if ("keyStore".equals(localName)) {
                            config.setKeyStore(reader.getElementText());
                            continue;
                        }
                        if ("keyStorePassword".equals(localName)) {
                            config.setKeyStorePassword(reader.getElementText());
                            continue;
                        }
                        if ("trustStore".equals(localName)) {
                            config.setTrustStore(reader.getElementText());
                            continue;
                        }
                        if ("trustStorePassword".equals(localName)) {
                            config.setTrustStorePassword(reader.getElementText());
                            continue;
                        }
                        if (!"modifyTrustStore".equals(localName)) continue;
                        config.setModifyTrustStore(Boolean.getBoolean(reader.getElementText()));
                    }
                }
            });
            FileInputStream is = new FileInputStream(f);
            input = new BufferedInputStream(is);
            XMLStreamReader streamReader = XMLInputFactory.newInstance().createXMLStreamReader(input);
            mapper.parseDocument((Object)config, streamReader);
            streamReader.close();
        }
        catch (Throwable t) {
            try {
                throw new CliInitializationException("Failed to parse " + f.getAbsolutePath(), t);
            }
            catch (Throwable throwable) {
                StreamUtils.safeClose(input);
                throw throwable;
            }
        }
        StreamUtils.safeClose((Closeable)input);
        return config;
    }

    private CliConfigImpl() {
    }

    @Override
    public SSLConfig getSslConfig() {
        return this.sslConfig;
    }

    static class SslConfig
    implements SSLConfig {
        private String keyStore = null;
        private String keyStorePassword = null;
        private String trustStore = null;
        private String trustStorePassword = null;
        private boolean modifyTrustStore = true;

        SslConfig() {
        }

        @Override
        public String getKeyStore() {
            return this.keyStore;
        }

        void setKeyStore(String keyStore) {
            this.keyStore = keyStore;
        }

        @Override
        public String getKeyStorePassword() {
            return this.keyStorePassword;
        }

        void setKeyStorePassword(String keyStorePassword) {
            this.keyStorePassword = keyStorePassword;
        }

        @Override
        public String getTrustStore() {
            return this.trustStore;
        }

        void setTrustStore(String trustStore) {
            this.trustStore = trustStore;
        }

        @Override
        public String getTrustStorePassword() {
            return this.trustStorePassword;
        }

        void setTrustStorePassword(String trustStorePassword) {
            this.trustStorePassword = trustStorePassword;
        }

        @Override
        public boolean isModifyTrustStore() {
            return this.modifyTrustStore;
        }

        void setModifyTrustStore(boolean modifyTrustStore) {
            this.modifyTrustStore = modifyTrustStore;
        }
    }
}

