/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.clustering.subsystem;

import java.io.IOException;
import java.io.StringReader;
import java.io.StringWriter;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.transform.Source;
import javax.xml.transform.stream.StreamSource;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.persistence.SubsystemMarshallingContext;
import org.jboss.dmr.ModelNode;
import org.jboss.staxmapper.XMLElementReader;
import org.jboss.staxmapper.XMLElementWriter;
import org.jboss.staxmapper.XMLExtendedStreamWriter;
import org.jboss.staxmapper.XMLExtendedStreamWriterFactory;
import org.jboss.staxmapper.XMLMapper;
import org.junit.Assert;
import org.junit.Test;

public abstract class AbstractExtensionTest {
    private final XMLElementReader<List<ModelNode>> reader;
    private final XMLElementWriter<SubsystemMarshallingContext> writer;
    private final String path;
    private final String namespace;

    protected AbstractExtensionTest(XMLElementReader<List<ModelNode>> reader, XMLElementWriter<SubsystemMarshallingContext> writer, String path, String namespace) {
        this.reader = reader;
        this.writer = writer;
        this.path = path;
        this.namespace = namespace;
    }

    @Test
    public void test() throws Exception {
        URL url = Thread.currentThread().getContextClassLoader().getResource(this.path);
        Assert.assertNotNull((Object)url);
        List<ModelNode> operations = this.parse(new StreamSource(url.toString()));
        ModelNode model = this.populate(operations);
        String xml = this.write(model);
        Assert.assertEquals(operations, this.parse(new StreamSource(new StringReader(xml))));
    }

    protected abstract ModelNode populate(List<ModelNode> var1) throws OperationFailedException;

    private List<ModelNode> parse(Source source) throws XMLStreamException, IOException {
        ArrayList<ModelNode> operations = new ArrayList<ModelNode>();
        XMLMapper mapper = XMLMapper.Factory.create();
        mapper.registerRootElement(new QName(this.namespace, "subsystem"), this.reader);
        XMLStreamReader reader = XMLInputFactory.newInstance().createXMLStreamReader(source);
        mapper.parseDocument(operations, reader);
        return operations;
    }

    private String write(ModelNode model) throws XMLStreamException {
        StringWriter result = new StringWriter();
        XMLExtendedStreamWriter writer = XMLExtendedStreamWriterFactory.create(XMLOutputFactory.newFactory().createXMLStreamWriter(result));
        this.writer.writeContent(writer, (Object)new SubsystemMarshallingContext(model, writer));
        writer.flush();
        return result.toString();
    }
}

