/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.clustering.subsystem;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.StringReader;
import java.io.StringWriter;
import java.net.URISyntaxException;
import java.net.URL;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamReader;
import org.jboss.as.controller.Extension;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.subsystem.test.AbstractSubsystemBaseTest;
import org.jboss.as.subsystem.test.AdditionalInitialization;
import org.jboss.as.subsystem.test.ModelDescriptionValidator;

public abstract class ClusteringSubsystemTest
extends AbstractSubsystemBaseTest {
    private final String path;

    protected ClusteringSubsystemTest(String name, Extension extension, String path) {
        super(name, extension);
        this.path = path;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String getSubsystemXml() throws IOException {
        URL url = Thread.currentThread().getContextClassLoader().getResource(this.path);
        if (url == null) {
            throw new IllegalStateException(String.format("Failed to locate %s", this.path));
        }
        try {
            BufferedReader reader = new BufferedReader(new FileReader(new File(url.toURI())));
            StringWriter writer = new StringWriter();
            try {
                String line = reader.readLine();
                while (line != null) {
                    writer.write(line);
                    line = reader.readLine();
                }
            }
            finally {
                reader.close();
            }
            return writer.toString();
        }
        catch (URISyntaxException e) {
            throw new IllegalStateException(e);
        }
    }

    protected void compareXml(String configId, String original, String marshalled) throws Exception {
        XMLStreamReader originalReader = XMLInputFactory.newInstance().createXMLStreamReader(new StringReader(original));
        XMLStreamReader marshalledReader = XMLInputFactory.newInstance().createXMLStreamReader(new StringReader(marshalled));
        String originalNS = null;
        if (originalReader.next() == 1) {
            originalNS = originalReader.getNamespaceURI();
        }
        String marshalledNS = null;
        if (marshalledReader.next() == 1) {
            marshalledNS = marshalledReader.getNamespaceURI();
        }
        if (originalNS.equals(marshalledNS)) {
            this.compareXml(configId, original, marshalled, true);
        }
    }

    protected AdditionalInitialization createAdditionalInitialization() {
        return new AdditionalInitialization(){

            protected OperationContext.Type getType() {
                return OperationContext.Type.MANAGEMENT;
            }

            protected ModelDescriptionValidator.ValidationConfiguration getModelValidationConfiguration() {
                return ClusteringSubsystemTest.this.getModelValidationConfiguration();
            }
        };
    }

    protected abstract ModelDescriptionValidator.ValidationConfiguration getModelValidationConfiguration();
}

