/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.clustering.infinispan.subsystem;

import java.util.Locale;
import java.util.ResourceBundle;
import org.jboss.as.clustering.infinispan.subsystem.CommonAttributes;
import org.jboss.as.clustering.infinispan.subsystem.Namespace;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ModelType;

public class InfinispanDescriptions {
    public static final String RESOURCE_NAME = InfinispanDescriptions.class.getPackage().getName() + ".LocalDescriptions";

    private InfinispanDescriptions() {
    }

    static ModelNode getSubsystemDescription(Locale locale) {
        ResourceBundle resources = InfinispanDescriptions.getResources(locale);
        ModelNode subsystem = InfinispanDescriptions.createDescription(resources, "infinispan");
        subsystem.get("head-comment-allowed").set(true);
        subsystem.get("tail-comment-allowed").set(true);
        subsystem.get("namespace").set(Namespace.CURRENT.getUri());
        subsystem.get(new String[]{"children", "cache-container", "description"}).set(resources.getString("infinispan.container"));
        subsystem.get(new String[]{"children", "cache-container", "min-occurs"}).set(1);
        subsystem.get(new String[]{"children", "cache-container", "max-occurs"}).set(Integer.MAX_VALUE);
        subsystem.get(new String[]{"children", "cache-container", "model-description"}).setEmptyObject();
        return subsystem;
    }

    static ModelNode getSubsystemAddDescription(Locale locale) {
        ResourceBundle resources = InfinispanDescriptions.getResources(locale);
        return InfinispanDescriptions.createOperationDescription("add", resources, "infinispan.add");
    }

    static ModelNode getSubsystemDescribeDescription(Locale locale) {
        ResourceBundle resources = InfinispanDescriptions.getResources(locale);
        ModelNode op = InfinispanDescriptions.createOperationDescription("describe", resources, "infinispan.describe");
        op.get("request-properties").setEmptyObject();
        op.get(new String[]{"reply-properties", "type"}).set(ModelType.LIST);
        op.get(new String[]{"reply-properties", "value-type"}).set(ModelType.OBJECT);
        return op;
    }

    static ModelNode getSubsystemRemoveDescription(Locale locale) {
        ResourceBundle resources = InfinispanDescriptions.getResources(locale);
        ModelNode op = InfinispanDescriptions.createOperationDescription("remove", resources, "infinispan.remove");
        op.get("reply-properties").setEmptyObject();
        op.get("request-properties").setEmptyObject();
        return op;
    }

    static ModelNode getCacheContainerDescription(Locale locale) {
        ResourceBundle resources = InfinispanDescriptions.getResources(locale);
        String keyPrefix = "infinispan.container";
        ModelNode container = InfinispanDescriptions.createDescription(resources, keyPrefix);
        for (AttributeDefinition attr : CommonAttributes.CACHE_CONTAINER_ATTRIBUTES) {
            attr.addResourceAttributeDescription(resources, keyPrefix, container);
        }
        container.get(new String[]{"children", "transport", "description"}).set(resources.getString(keyPrefix + ".transport"));
        container.get(new String[]{"children", "transport", "min-occurs"}).set(0);
        container.get(new String[]{"children", "transport", "max-occurs"}).set(1);
        container.get(new String[]{"children", "transport", "allowed"}).setEmptyList().add("TRANSPORT");
        container.get(new String[]{"children", "transport", "model-description"});
        container.get(new String[]{"children", "local-cache", "description"}).set(resources.getString(keyPrefix + ".local-cache"));
        container.get(new String[]{"children", "local-cache", "min-occurs"}).set(0);
        container.get(new String[]{"children", "local-cache", "max-occurs"}).set(Integer.MAX_VALUE);
        container.get(new String[]{"children", "local-cache", "model-description"});
        container.get(new String[]{"children", "invalidation-cache", "description"}).set(resources.getString(keyPrefix + ".invalidation-cache"));
        container.get(new String[]{"children", "invalidation-cache", "min-occurs"}).set(0);
        container.get(new String[]{"children", "invalidation-cache", "max-occurs"}).set(Integer.MAX_VALUE);
        container.get(new String[]{"children", "invalidation-cache", "model-description"});
        container.get(new String[]{"children", "replicated-cache", "description"}).set(resources.getString(keyPrefix + ".replicated-cache"));
        container.get(new String[]{"children", "replicated-cache", "min-occurs"}).set(0);
        container.get(new String[]{"children", "replicated-cache", "max-occurs"}).set(Integer.MAX_VALUE);
        container.get(new String[]{"children", "replicated-cache", "model-description"});
        container.get(new String[]{"children", "distributed-cache", "description"}).set(resources.getString(keyPrefix + ".distributed-cache"));
        container.get(new String[]{"children", "distributed-cache", "min-occurs"}).set(0);
        container.get(new String[]{"children", "distributed-cache", "max-occurs"}).set(Integer.MAX_VALUE);
        container.get(new String[]{"children", "distributed-cache", "model-description"});
        return container;
    }

    static ModelNode getCacheContainerAddDescription(Locale locale) {
        ResourceBundle resources = InfinispanDescriptions.getResources(locale);
        ModelNode op = InfinispanDescriptions.createOperationDescription("add", resources, "infinispan.container.add");
        for (AttributeDefinition attr : CommonAttributes.CACHE_CONTAINER_ATTRIBUTES) {
            attr.addOperationParameterDescription(resources, "infinispan.container", op);
        }
        return op;
    }

    static ModelNode getCacheContainerRemoveDescription(Locale locale) {
        ResourceBundle resources = InfinispanDescriptions.getResources(locale);
        ModelNode op = InfinispanDescriptions.createOperationDescription("remove", resources, "infinispan.container.remove");
        op.get("request-properties").setEmptyObject();
        return op;
    }

    static ModelNode getAddAliasCommandDescription(Locale locale) {
        ResourceBundle resources = InfinispanDescriptions.getResources(locale);
        ModelNode op = InfinispanDescriptions.createOperationDescription("add-alias", resources, "infinispan.container.alias.add-alias");
        CommonAttributes.NAME.addOperationParameterDescription(resources, "infinispan.container.alias", op);
        return op;
    }

    static ModelNode getRemoveAliasCommandDescription(Locale locale) {
        ResourceBundle resources = InfinispanDescriptions.getResources(locale);
        ModelNode op = InfinispanDescriptions.createOperationDescription("remove-alias", resources, "infinispan.container.alias.remove-alias");
        CommonAttributes.NAME.addOperationParameterDescription(resources, "infinispan.container.alias", op);
        return op;
    }

    static ModelNode getLocalCacheDescription(Locale locale) {
        ResourceBundle resources = InfinispanDescriptions.getResources(locale);
        ModelNode cache = InfinispanDescriptions.createDescription(resources, "infinispan.container.local-cache");
        for (AttributeDefinition attr : CommonAttributes.CACHE_ATTRIBUTES) {
            attr.addResourceAttributeDescription(resources, "infinispan.cache", cache);
        }
        InfinispanDescriptions.addCommonCacheChildren("infinispan.cache", cache, resources);
        return cache;
    }

    static ModelNode getLocalCacheAddDescription(Locale locale) {
        ResourceBundle resources = InfinispanDescriptions.getResources(locale);
        ModelNode op = InfinispanDescriptions.createOperationDescription("add", resources, "infinispan.container.local-cache.add");
        InfinispanDescriptions.addCommonCacheAddRequestProperties("infinispan.cache", op, resources);
        return op;
    }

    static ModelNode getInvalidationCacheDescription(Locale locale) {
        ResourceBundle resources = InfinispanDescriptions.getResources(locale);
        ModelNode cache = InfinispanDescriptions.createDescription(resources, "infinispan.container.invalidation-cache");
        for (AttributeDefinition attr : CommonAttributes.CACHE_ATTRIBUTES) {
            attr.addResourceAttributeDescription(resources, "infinispan.cache", cache);
        }
        for (AttributeDefinition attr : CommonAttributes.CLUSTERED_CACHE_ATTRIBUTES) {
            attr.addResourceAttributeDescription(resources, "infinispan.clustered-cache", cache);
        }
        InfinispanDescriptions.addCommonCacheChildren("infinispan.cache", cache, resources);
        return cache;
    }

    static ModelNode getInvalidationCacheAddDescription(Locale locale) {
        ResourceBundle resources = InfinispanDescriptions.getResources(locale);
        ModelNode op = InfinispanDescriptions.createOperationDescription("add", resources, "infinispan.container.invalidation-cache.add");
        InfinispanDescriptions.addCommonCacheAddRequestProperties("infinispan.cache", op, resources);
        InfinispanDescriptions.addCommonClusteredCacheAddRequestProperties("infinispan.clustered-cache", op, resources);
        return op;
    }

    static ModelNode getReplicatedCacheDescription(Locale locale) {
        ResourceBundle resources = InfinispanDescriptions.getResources(locale);
        ModelNode cache = InfinispanDescriptions.createDescription(resources, "infinispan.container.replicated-cache");
        for (AttributeDefinition attr : CommonAttributes.CACHE_ATTRIBUTES) {
            attr.addResourceAttributeDescription(resources, "infinispan.cache", cache);
        }
        for (AttributeDefinition attr : CommonAttributes.CLUSTERED_CACHE_ATTRIBUTES) {
            attr.addResourceAttributeDescription(resources, "infinispan.clustered-cache", cache);
        }
        InfinispanDescriptions.addCommonCacheChildren("infinispan.cache", cache, resources);
        InfinispanDescriptions.addStateTransferCacheChildren("infinispan.replicated-cache", cache, resources);
        return cache;
    }

    static ModelNode getReplicatedCacheAddDescription(Locale locale) {
        ResourceBundle resources = InfinispanDescriptions.getResources(locale);
        ModelNode op = InfinispanDescriptions.createOperationDescription("add", resources, "infinispan.container.replicated-cache.add");
        InfinispanDescriptions.addCommonCacheAddRequestProperties("infinispan.cache", op, resources);
        InfinispanDescriptions.addCommonClusteredCacheAddRequestProperties("infinispan.clustered-cache", op, resources);
        CommonAttributes.STATE_TRANSFER_OBJECT.addOperationParameterDescription(resources, "infinispan.replicated-cache", op);
        return op;
    }

    static ModelNode getDistributedCacheDescription(Locale locale) {
        ResourceBundle resources = InfinispanDescriptions.getResources(locale);
        ModelNode cache = InfinispanDescriptions.createDescription(resources, "infinispan.container.distributed-cache");
        for (AttributeDefinition attr : CommonAttributes.CACHE_ATTRIBUTES) {
            attr.addResourceAttributeDescription(resources, "infinispan.cache", cache);
        }
        for (AttributeDefinition attr : CommonAttributes.CLUSTERED_CACHE_ATTRIBUTES) {
            attr.addResourceAttributeDescription(resources, "infinispan.clustered-cache", cache);
        }
        for (AttributeDefinition attr : CommonAttributes.DISTRIBUTED_CACHE_ATTRIBUTES) {
            attr.addResourceAttributeDescription(resources, "infinispan.distributed-cache", cache);
        }
        InfinispanDescriptions.addCommonCacheChildren("infinispan.cache", cache, resources);
        InfinispanDescriptions.addStateTransferCacheChildren("infinispan.replicated-cache", cache, resources);
        return cache;
    }

    static ModelNode getDistributedCacheAddDescription(Locale locale) {
        ResourceBundle resources = InfinispanDescriptions.getResources(locale);
        ModelNode op = InfinispanDescriptions.createOperationDescription("add", resources, "infinispan.container.distributed-cache.add");
        InfinispanDescriptions.addCommonCacheAddRequestProperties("infinispan.cache", op, resources);
        InfinispanDescriptions.addCommonClusteredCacheAddRequestProperties("infinispan.clustered-cache", op, resources);
        for (AttributeDefinition attr : CommonAttributes.DISTRIBUTED_CACHE_ATTRIBUTES) {
            attr.addOperationParameterDescription(resources, "infinispan.distributed-cache", op);
        }
        CommonAttributes.STATE_TRANSFER_OBJECT.addOperationParameterDescription(resources, "infinispan.replicated-cache", op);
        return op;
    }

    static ModelNode getCacheRemoveDescription(Locale locale) {
        ResourceBundle resources = InfinispanDescriptions.getResources(locale);
        ModelNode op = InfinispanDescriptions.createOperationDescription("remove", resources, "infinispan.cache.remove");
        op.get("request-properties").setEmptyObject();
        return op;
    }

    static ModelNode getTransportDescription(Locale locale) {
        ResourceBundle resources = InfinispanDescriptions.getResources(locale);
        ModelNode transport = InfinispanDescriptions.createDescription(resources, "infinispan.container.transport");
        for (AttributeDefinition attr : CommonAttributes.TRANSPORT_ATTRIBUTES) {
            attr.addResourceAttributeDescription(resources, "infinispan.container.transport", transport);
        }
        return transport;
    }

    static ModelNode getTransportAddDescription(Locale locale) {
        ResourceBundle resources = InfinispanDescriptions.getResources(locale);
        ModelNode op = InfinispanDescriptions.createOperationDescription("add", resources, "infinispan.container.transport.add");
        for (AttributeDefinition attr : CommonAttributes.TRANSPORT_ATTRIBUTES) {
            attr.addOperationParameterDescription(resources, "infinispan.container.transport", op);
        }
        return op;
    }

    static ModelNode getTransportRemoveDescription(Locale locale) {
        ResourceBundle resources = InfinispanDescriptions.getResources(locale);
        ModelNode op = InfinispanDescriptions.createOperationDescription("remove", resources, "infinispan.container.transport.remove");
        op.get("request-properties").setEmptyObject();
        return op;
    }

    static ModelNode getLockingDescription(Locale locale) {
        ResourceBundle resources = InfinispanDescriptions.getResources(locale);
        ModelNode locking = InfinispanDescriptions.createDescription(resources, "infinispan.cache.locking");
        for (AttributeDefinition attr : CommonAttributes.LOCKING_ATTRIBUTES) {
            attr.addResourceAttributeDescription(resources, "infinispan.cache.locking", locking);
        }
        return locking;
    }

    static ModelNode getLockingAddDescription(Locale locale) {
        ResourceBundle resources = InfinispanDescriptions.getResources(locale);
        ModelNode op = InfinispanDescriptions.createOperationDescription("add", resources, "infinispan.cache.locking.add");
        for (AttributeDefinition attr : CommonAttributes.LOCKING_ATTRIBUTES) {
            attr.addOperationParameterDescription(resources, "infinispan.cache.locking", op);
        }
        return op;
    }

    static ModelNode getLockingRemoveDescription(Locale locale) {
        ResourceBundle resources = InfinispanDescriptions.getResources(locale);
        ModelNode op = InfinispanDescriptions.createOperationDescription("remove", resources, "infinispan.cache.locking.remove");
        op.get("request-properties").setEmptyObject();
        return op;
    }

    static ModelNode getTransactionDescription(Locale locale) {
        ResourceBundle resources = InfinispanDescriptions.getResources(locale);
        ModelNode transaction = InfinispanDescriptions.createDescription(resources, "infinispan.cache.transaction");
        for (AttributeDefinition attr : CommonAttributes.TRANSACTION_ATTRIBUTES) {
            attr.addResourceAttributeDescription(resources, "infinispan.cache.transaction", transaction);
        }
        return transaction;
    }

    static ModelNode getTransactionAddDescription(Locale locale) {
        ResourceBundle resources = InfinispanDescriptions.getResources(locale);
        ModelNode op = InfinispanDescriptions.createOperationDescription("add", resources, "infinispan.cache.transaction.add");
        for (AttributeDefinition attr : CommonAttributes.TRANSACTION_ATTRIBUTES) {
            attr.addOperationParameterDescription(resources, "infinispan.cache.transaction", op);
        }
        return op;
    }

    static ModelNode getTransactionRemoveDescription(Locale locale) {
        ResourceBundle resources = InfinispanDescriptions.getResources(locale);
        ModelNode op = InfinispanDescriptions.createOperationDescription("remove", resources, "infinispan.cache.transaction.remove");
        op.get("request-properties").setEmptyObject();
        return op;
    }

    static ModelNode getEvictionDescription(Locale locale) {
        ResourceBundle resources = InfinispanDescriptions.getResources(locale);
        ModelNode eviction = InfinispanDescriptions.createDescription(resources, "infinispan.cache.eviction");
        for (AttributeDefinition attr : CommonAttributes.EVICTION_ATTRIBUTES) {
            attr.addResourceAttributeDescription(resources, "infinispan.cache.eviction", eviction);
        }
        return eviction;
    }

    static ModelNode getEvictionAddDescription(Locale locale) {
        ResourceBundle resources = InfinispanDescriptions.getResources(locale);
        ModelNode op = InfinispanDescriptions.createOperationDescription("add", resources, "infinispan.cache.eviction.add");
        for (AttributeDefinition attr : CommonAttributes.EVICTION_ATTRIBUTES) {
            attr.addOperationParameterDescription(resources, "infinispan.cache.eviction", op);
        }
        return op;
    }

    static ModelNode getEvictionRemoveDescription(Locale locale) {
        ResourceBundle resources = InfinispanDescriptions.getResources(locale);
        ModelNode op = InfinispanDescriptions.createOperationDescription("remove", resources, "infinispan.cache.eviction.remove");
        op.get("request-properties").setEmptyObject();
        return op;
    }

    static ModelNode getExpirationDescription(Locale locale) {
        ResourceBundle resources = InfinispanDescriptions.getResources(locale);
        ModelNode expiration = InfinispanDescriptions.createDescription(resources, "infinispan.cache.expiration");
        for (AttributeDefinition attr : CommonAttributes.EXPIRATION_ATTRIBUTES) {
            attr.addResourceAttributeDescription(resources, "infinispan.cache.expiration", expiration);
        }
        return expiration;
    }

    static ModelNode getExpirationAddDescription(Locale locale) {
        ResourceBundle resources = InfinispanDescriptions.getResources(locale);
        ModelNode op = InfinispanDescriptions.createOperationDescription("add", resources, "infinispan.cache.expiration.add");
        for (AttributeDefinition attr : CommonAttributes.EXPIRATION_ATTRIBUTES) {
            attr.addOperationParameterDescription(resources, "infinispan.cache.expiration", op);
        }
        return op;
    }

    static ModelNode getExpirationRemoveDescription(Locale locale) {
        ResourceBundle resources = InfinispanDescriptions.getResources(locale);
        ModelNode op = InfinispanDescriptions.createOperationDescription("remove", resources, "infinispan.cache.expiration.remove");
        op.get("request-properties").setEmptyObject();
        return op;
    }

    static ModelNode getStateTransferDescription(Locale locale) {
        ResourceBundle resources = InfinispanDescriptions.getResources(locale);
        ModelNode stateTransfer = InfinispanDescriptions.createDescription(resources, "infinispan.replicated-cache.state-transfer");
        for (AttributeDefinition attr : CommonAttributes.STATE_TRANSFER_ATTRIBUTES) {
            attr.addResourceAttributeDescription(resources, "infinispan.replicated-cache.state-transfer", stateTransfer);
        }
        return stateTransfer;
    }

    static ModelNode getStateTransferAddDescription(Locale locale) {
        ResourceBundle resources = InfinispanDescriptions.getResources(locale);
        ModelNode op = InfinispanDescriptions.createOperationDescription("add", resources, "infinispan.replicated-cache.state-transfer.add");
        for (AttributeDefinition attr : CommonAttributes.STATE_TRANSFER_ATTRIBUTES) {
            attr.addOperationParameterDescription(resources, "infinispan.replicated-cache.state-transfer", op);
        }
        return op;
    }

    static ModelNode getStateTransferRemoveDescription(Locale locale) {
        ResourceBundle resources = InfinispanDescriptions.getResources(locale);
        ModelNode op = InfinispanDescriptions.createOperationDescription("remove", resources, "infinispan.replicated-cache.state-transfer.remove");
        op.get("request-properties").setEmptyObject();
        return op;
    }

    static ModelNode getCacheStoreDescription(Locale locale) {
        ResourceBundle resources = InfinispanDescriptions.getResources(locale);
        ModelNode store = InfinispanDescriptions.createDescription(resources, "infinispan.cache.store");
        for (AttributeDefinition attr : CommonAttributes.COMMON_STORE_ATTRIBUTES) {
            attr.addResourceAttributeDescription(resources, "infinispan.cache.store", store);
        }
        for (AttributeDefinition attr : CommonAttributes.STORE_ATTRIBUTES) {
            attr.addResourceAttributeDescription(resources, "infinispan.cache.store", store);
        }
        InfinispanDescriptions.addCacheStoreWriteBehindCacheChildren("infinispan.cache.store", store, resources);
        InfinispanDescriptions.addCacheStorePropertyCacheChildren("infinispan.cache.store", store, resources);
        return store;
    }

    static ModelNode getCacheStoreAddDescription(Locale locale) {
        ResourceBundle resources = InfinispanDescriptions.getResources(locale);
        ModelNode op = InfinispanDescriptions.createOperationDescription("add", resources, "infinispan.cache.store.add");
        for (AttributeDefinition attr : CommonAttributes.COMMON_STORE_ATTRIBUTES) {
            attr.addOperationParameterDescription(resources, "infinispan.cache.store", op);
        }
        CommonAttributes.PROPERTIES.addOperationParameterDescription(resources, "infinispan.cache.store", op);
        for (AttributeDefinition attr : CommonAttributes.STORE_ATTRIBUTES) {
            attr.addOperationParameterDescription(resources, "infinispan.cache.store", op);
        }
        return op;
    }

    static ModelNode getCacheStoreRemoveDescription(Locale locale) {
        ResourceBundle resources = InfinispanDescriptions.getResources(locale);
        ModelNode op = InfinispanDescriptions.createOperationDescription("remove", resources, "infinispan.cache.store.remove");
        op.get("request-properties").setEmptyObject();
        return op;
    }

    static ModelNode getCacheStoreWriteBehindDescription(Locale locale) {
        ResourceBundle resources = InfinispanDescriptions.getResources(locale);
        ModelNode writeBehind = InfinispanDescriptions.createDescription(resources, "infinispan.cache.store.write-behind");
        for (AttributeDefinition attr : CommonAttributes.WRITE_BEHIND_ATTRIBUTES) {
            attr.addResourceAttributeDescription(resources, "infinispan.cache.store.write-behind", writeBehind);
        }
        return writeBehind;
    }

    static ModelNode getCacheStoreWriteBehindAddDescription(Locale locale) {
        ResourceBundle resources = InfinispanDescriptions.getResources(locale);
        ModelNode op = InfinispanDescriptions.createOperationDescription("add", resources, "infinispan.cache.store.write-behind.add");
        for (AttributeDefinition attr : CommonAttributes.WRITE_BEHIND_ATTRIBUTES) {
            attr.addOperationParameterDescription(resources, "infinispan.cache.store.write-behind", op);
        }
        return op;
    }

    static ModelNode getCacheStoreWriteBehindRemoveDescription(Locale locale) {
        ResourceBundle resources = InfinispanDescriptions.getResources(locale);
        ModelNode op = InfinispanDescriptions.createOperationDescription("remove", resources, "infinispan.cache.store.write-behind.remove");
        op.get("request-properties").setEmptyObject();
        return op;
    }

    static ModelNode getCacheStorePropertyDescription(Locale locale) {
        ResourceBundle resources = InfinispanDescriptions.getResources(locale);
        ModelNode storeProperty = InfinispanDescriptions.createDescription(resources, "infinispan.cache.store.property");
        CommonAttributes.VALUE.addResourceAttributeDescription(resources, "infinispan.cache.store.property", storeProperty);
        return storeProperty;
    }

    static ModelNode getCacheStorePropertyAddDescription(Locale locale) {
        ResourceBundle resources = InfinispanDescriptions.getResources(locale);
        ModelNode op = InfinispanDescriptions.createOperationDescription("add", resources, "infinispan.cache.store.property.add");
        CommonAttributes.VALUE.addOperationParameterDescription(resources, "infinispan.cache.store.property", op);
        return op;
    }

    static ModelNode getCacheStorePropertyRemoveDescription(Locale locale) {
        ResourceBundle resources = InfinispanDescriptions.getResources(locale);
        ModelNode op = InfinispanDescriptions.createOperationDescription("remove", resources, "infinispan.cache.store.property.remove");
        op.get("request-properties").setEmptyObject();
        return op;
    }

    static ModelNode getFileCacheStoreDescription(Locale locale) {
        ResourceBundle resources = InfinispanDescriptions.getResources(locale);
        ModelNode store = InfinispanDescriptions.createDescription(resources, "infinispan.cache.store");
        for (AttributeDefinition attr : CommonAttributes.COMMON_STORE_ATTRIBUTES) {
            attr.addResourceAttributeDescription(resources, "infinispan.cache.store", store);
        }
        for (AttributeDefinition attr : CommonAttributes.FILE_STORE_ATTRIBUTES) {
            attr.addResourceAttributeDescription(resources, "infinispan.cache.file-store", store);
        }
        InfinispanDescriptions.addCacheStoreWriteBehindCacheChildren("infinispan.cache.store", store, resources);
        InfinispanDescriptions.addCacheStorePropertyCacheChildren("infinispan.cache.store", store, resources);
        return store;
    }

    static ModelNode getFileCacheStoreAddDescription(Locale locale) {
        ResourceBundle resources = InfinispanDescriptions.getResources(locale);
        ModelNode op = InfinispanDescriptions.createOperationDescription("add", resources, "infinispan.cache.store.add");
        for (AttributeDefinition attr : CommonAttributes.COMMON_STORE_ATTRIBUTES) {
            attr.addOperationParameterDescription(resources, "infinispan.cache.store", op);
        }
        CommonAttributes.PROPERTIES.addOperationParameterDescription(resources, "infinispan.cache.store", op);
        for (AttributeDefinition attr : CommonAttributes.FILE_STORE_ATTRIBUTES) {
            attr.addOperationParameterDescription(resources, "infinispan.cache.file-store", op);
        }
        return op;
    }

    static ModelNode getStringKeyedJdbcCacheStoreDescription(Locale locale) {
        ResourceBundle resources = InfinispanDescriptions.getResources(locale);
        ModelNode store = InfinispanDescriptions.createDescription(resources, "infinispan.cache.store");
        for (AttributeDefinition attr : CommonAttributes.COMMON_STORE_ATTRIBUTES) {
            attr.addResourceAttributeDescription(resources, "infinispan.cache.store", store);
        }
        for (AttributeDefinition attr : CommonAttributes.COMMON_JDBC_STORE_ATTRIBUTES) {
            attr.addResourceAttributeDescription(resources, "infinispan.cache.jdbc-store", store);
        }
        for (AttributeDefinition attr : CommonAttributes.STRING_KEYED_JDBC_STORE_ATTRIBUTES) {
            attr.addResourceAttributeDescription(resources, "infinispan.cache.jdbc-store", store);
        }
        InfinispanDescriptions.addCacheStoreWriteBehindCacheChildren("infinispan.cache.store", store, resources);
        InfinispanDescriptions.addCacheStorePropertyCacheChildren("infinispan.cache.store", store, resources);
        return store;
    }

    static ModelNode getStringKeyedJdbcCacheStoreAddDescription(Locale locale) {
        ResourceBundle resources = InfinispanDescriptions.getResources(locale);
        ModelNode op = InfinispanDescriptions.createOperationDescription("add", resources, "infinispan.cache.store.add");
        for (AttributeDefinition attr : CommonAttributes.COMMON_STORE_ATTRIBUTES) {
            attr.addOperationParameterDescription(resources, "infinispan.cache.store", op);
        }
        CommonAttributes.PROPERTIES.addOperationParameterDescription(resources, "infinispan.cache.store", op);
        for (AttributeDefinition attr : CommonAttributes.COMMON_JDBC_STORE_ATTRIBUTES) {
            attr.addOperationParameterDescription(resources, "infinispan.cache.jdbc-store", op);
        }
        for (AttributeDefinition attr : CommonAttributes.STRING_KEYED_JDBC_STORE_ATTRIBUTES) {
            attr.addOperationParameterDescription(resources, "infinispan.cache.jdbc-store", op);
        }
        CommonAttributes.PROPERTIES.addOperationParameterDescription(resources, "infinispan.cache.store", op);
        return op;
    }

    static ModelNode getBinaryKeyedJdbcCacheStoreDescription(Locale locale) {
        ResourceBundle resources = InfinispanDescriptions.getResources(locale);
        ModelNode store = InfinispanDescriptions.createDescription(resources, "infinispan.cache.store");
        for (AttributeDefinition attr : CommonAttributes.COMMON_STORE_ATTRIBUTES) {
            attr.addResourceAttributeDescription(resources, "infinispan.cache.store", store);
        }
        for (AttributeDefinition attr : CommonAttributes.COMMON_JDBC_STORE_ATTRIBUTES) {
            attr.addResourceAttributeDescription(resources, "infinispan.cache.jdbc-store", store);
        }
        for (AttributeDefinition attr : CommonAttributes.BINARY_KEYED_JDBC_STORE_ATTRIBUTES) {
            attr.addResourceAttributeDescription(resources, "infinispan.cache.jdbc-store", store);
        }
        InfinispanDescriptions.addCacheStoreWriteBehindCacheChildren("infinispan.cache.store", store, resources);
        InfinispanDescriptions.addCacheStorePropertyCacheChildren("infinispan.cache.store", store, resources);
        return store;
    }

    static ModelNode getBinaryKeyedJdbcCacheStoreAddDescription(Locale locale) {
        ResourceBundle resources = InfinispanDescriptions.getResources(locale);
        ModelNode op = InfinispanDescriptions.createOperationDescription("add", resources, "infinispan.cache.store.add");
        for (AttributeDefinition attr : CommonAttributes.COMMON_STORE_ATTRIBUTES) {
            attr.addOperationParameterDescription(resources, "infinispan.cache.store", op);
        }
        CommonAttributes.PROPERTIES.addOperationParameterDescription(resources, "infinispan.cache.store", op);
        for (AttributeDefinition attr : CommonAttributes.COMMON_JDBC_STORE_ATTRIBUTES) {
            attr.addOperationParameterDescription(resources, "infinispan.cache.jdbc-store", op);
        }
        for (AttributeDefinition attr : CommonAttributes.BINARY_KEYED_JDBC_STORE_ATTRIBUTES) {
            attr.addOperationParameterDescription(resources, "infinispan.cache.jdbc-store", op);
        }
        return op;
    }

    static ModelNode getMixedKeyedJdbcCacheStoreDescription(Locale locale) {
        ResourceBundle resources = InfinispanDescriptions.getResources(locale);
        ModelNode store = InfinispanDescriptions.createDescription(resources, "infinispan.cache.store");
        for (AttributeDefinition attr : CommonAttributes.COMMON_STORE_ATTRIBUTES) {
            attr.addResourceAttributeDescription(resources, "infinispan.cache.store", store);
        }
        for (AttributeDefinition attr : CommonAttributes.COMMON_JDBC_STORE_ATTRIBUTES) {
            attr.addResourceAttributeDescription(resources, "infinispan.cache.jdbc-store", store);
        }
        for (AttributeDefinition attr : CommonAttributes.MIXED_KEYED_JDBC_STORE_ATTRIBUTES) {
            attr.addResourceAttributeDescription(resources, "infinispan.cache.jdbc-store", store);
        }
        InfinispanDescriptions.addCacheStoreWriteBehindCacheChildren("infinispan.cache.store", store, resources);
        InfinispanDescriptions.addCacheStorePropertyCacheChildren("infinispan.cache.store", store, resources);
        return store;
    }

    static ModelNode getMixedKeyedJdbcCacheStoreAddDescription(Locale locale) {
        ResourceBundle resources = InfinispanDescriptions.getResources(locale);
        ModelNode op = InfinispanDescriptions.createOperationDescription("add", resources, "infinispan.cache.store.add");
        for (AttributeDefinition attr : CommonAttributes.COMMON_STORE_ATTRIBUTES) {
            attr.addOperationParameterDescription(resources, "infinispan.cache.store", op);
        }
        CommonAttributes.PROPERTIES.addOperationParameterDescription(resources, "infinispan.cache.store", op);
        for (AttributeDefinition attr : CommonAttributes.COMMON_JDBC_STORE_ATTRIBUTES) {
            attr.addOperationParameterDescription(resources, "infinispan.cache.jdbc-store", op);
        }
        for (AttributeDefinition attr : CommonAttributes.MIXED_KEYED_JDBC_STORE_ATTRIBUTES) {
            attr.addOperationParameterDescription(resources, "infinispan.cache.jdbc-store", op);
        }
        return op;
    }

    static ModelNode getRemoteCacheStoreDescription(Locale locale) {
        ResourceBundle resources = InfinispanDescriptions.getResources(locale);
        ModelNode store = InfinispanDescriptions.createDescription(resources, "infinispan.cache.store");
        for (AttributeDefinition attr : CommonAttributes.COMMON_STORE_ATTRIBUTES) {
            attr.addResourceAttributeDescription(resources, "infinispan.cache.store", store);
        }
        for (AttributeDefinition attr : CommonAttributes.REMOTE_STORE_ATTRIBUTES) {
            attr.addResourceAttributeDescription(resources, "infinispan.cache.remote-store", store);
        }
        InfinispanDescriptions.addCacheStoreWriteBehindCacheChildren("infinispan.cache.store", store, resources);
        InfinispanDescriptions.addCacheStorePropertyCacheChildren("infinispan.cache.store", store, resources);
        return store;
    }

    static ModelNode getRemoteCacheStoreAddDescription(Locale locale) {
        ResourceBundle resources = InfinispanDescriptions.getResources(locale);
        ModelNode op = InfinispanDescriptions.createOperationDescription("add", resources, "infinispan.cache.store.add");
        for (AttributeDefinition attr : CommonAttributes.COMMON_STORE_ATTRIBUTES) {
            attr.addOperationParameterDescription(resources, "infinispan.cache.store", op);
        }
        CommonAttributes.PROPERTIES.addOperationParameterDescription(resources, "infinispan.cache.store", op);
        for (AttributeDefinition attr : CommonAttributes.REMOTE_STORE_ATTRIBUTES) {
            attr.addOperationParameterDescription(resources, "infinispan.cache.remote-store", op);
        }
        return op;
    }

    private static ResourceBundle getResources(Locale locale) {
        return ResourceBundle.getBundle(RESOURCE_NAME, locale == null ? Locale.getDefault() : locale);
    }

    private static ModelNode createDescription(ResourceBundle resources, String key) {
        return InfinispanDescriptions.createOperationDescription(null, resources, key);
    }

    private static ModelNode createOperationDescription(String operation, ResourceBundle resources, String key) {
        ModelNode description = new ModelNode();
        if (operation != null) {
            description.get("operation-name").set(operation);
        }
        description.get("description").set(resources.getString(key));
        return description;
    }

    private static void addCommonCacheChildren(String keyPrefix, ModelNode description, ResourceBundle resources) {
        description.get(new String[]{"children", "locking", "description"}).set(resources.getString(keyPrefix + ".locking"));
        description.get(new String[]{"children", "locking", "min-occurs"}).set(0);
        description.get(new String[]{"children", "locking", "max-occurs"}).set(1);
        description.get(new String[]{"children", "locking", "allowed"}).setEmptyList();
        description.get(new String[]{"children", "locking", "allowed"}).add("LOCKING");
        description.get(new String[]{"children", "locking", "model-description"});
        description.get(new String[]{"children", "transaction", "description"}).set(resources.getString(keyPrefix + ".transaction"));
        description.get(new String[]{"children", "transaction", "min-occurs"}).set(0);
        description.get(new String[]{"children", "transaction", "max-occurs"}).set(1);
        description.get(new String[]{"children", "transaction", "allowed"}).setEmptyList();
        description.get(new String[]{"children", "transaction", "allowed"}).add("TRANSACTION");
        description.get(new String[]{"children", "transaction", "model-description"});
        description.get(new String[]{"children", "eviction", "description"}).set(resources.getString(keyPrefix + ".eviction"));
        description.get(new String[]{"children", "eviction", "min-occurs"}).set(0);
        description.get(new String[]{"children", "eviction", "max-occurs"}).set(1);
        description.get(new String[]{"children", "eviction", "allowed"}).setEmptyList();
        description.get(new String[]{"children", "eviction", "allowed"}).add("EVICTION");
        description.get(new String[]{"children", "eviction", "model-description"});
        description.get(new String[]{"children", "expiration", "description"}).set(resources.getString(keyPrefix + ".expiration"));
        description.get(new String[]{"children", "expiration", "min-occurs"}).set(0);
        description.get(new String[]{"children", "expiration", "max-occurs"}).set(1);
        description.get(new String[]{"children", "expiration", "allowed"}).setEmptyList();
        description.get(new String[]{"children", "expiration", "allowed"}).add("EXPIRATION");
        description.get(new String[]{"children", "expiration", "model-description"});
        description.get(new String[]{"children", "store", "description"}).set(resources.getString(keyPrefix + ".store"));
        description.get(new String[]{"children", "store", "min-occurs"}).set(0);
        description.get(new String[]{"children", "store", "max-occurs"}).set(1);
        description.get(new String[]{"children", "store", "allowed"}).setEmptyList();
        description.get(new String[]{"children", "store", "allowed"}).add("STORE");
        description.get(new String[]{"children", "store", "model-description"});
        description.get(new String[]{"children", "file-store", "description"}).set(resources.getString(keyPrefix + ".file-store"));
        description.get(new String[]{"children", "file-store", "min-occurs"}).set(0);
        description.get(new String[]{"children", "file-store", "max-occurs"}).set(1);
        description.get(new String[]{"children", "file-store", "allowed"}).setEmptyList();
        description.get(new String[]{"children", "file-store", "allowed"}).add("FILE_STORE");
        description.get(new String[]{"children", "file-store", "model-description"});
        description.get(new String[]{"children", "string-keyed-jdbc-store", "description"}).set(resources.getString(keyPrefix + ".string-keyed-jdbc-store"));
        description.get(new String[]{"children", "string-keyed-jdbc-store", "min-occurs"}).set(0);
        description.get(new String[]{"children", "string-keyed-jdbc-store", "max-occurs"}).set(1);
        description.get(new String[]{"children", "string-keyed-jdbc-store", "allowed"}).setEmptyList();
        description.get(new String[]{"children", "string-keyed-jdbc-store", "allowed"}).add("STRING_KEYED_JDBC_STORE");
        description.get(new String[]{"children", "string-keyed-jdbc-store", "model-description"});
        description.get(new String[]{"children", "binary-keyed-jdbc-store", "description"}).set(resources.getString(keyPrefix + ".binary-keyed-jdbc-store"));
        description.get(new String[]{"children", "binary-keyed-jdbc-store", "min-occurs"}).set(0);
        description.get(new String[]{"children", "binary-keyed-jdbc-store", "max-occurs"}).set(1);
        description.get(new String[]{"children", "binary-keyed-jdbc-store", "allowed"}).setEmptyList();
        description.get(new String[]{"children", "binary-keyed-jdbc-store", "allowed"}).add("BINARY_KEYED_JDBC_STORE");
        description.get(new String[]{"children", "binary-keyed-jdbc-store", "model-description"});
        description.get(new String[]{"children", "mixed-keyed-jdbc-store", "description"}).set(resources.getString(keyPrefix + ".mixed-keyed-jdbc-store"));
        description.get(new String[]{"children", "mixed-keyed-jdbc-store", "min-occurs"}).set(0);
        description.get(new String[]{"children", "mixed-keyed-jdbc-store", "max-occurs"}).set(1);
        description.get(new String[]{"children", "mixed-keyed-jdbc-store", "allowed"}).setEmptyList();
        description.get(new String[]{"children", "mixed-keyed-jdbc-store", "allowed"}).add("MIXED_KEYED_JDBC_STORE");
        description.get(new String[]{"children", "mixed-keyed-jdbc-store", "model-description"});
        description.get(new String[]{"children", "remote-store", "description"}).set(resources.getString(keyPrefix + ".remote-store"));
        description.get(new String[]{"children", "remote-store", "min-occurs"}).set(0);
        description.get(new String[]{"children", "remote-store", "max-occurs"}).set(1);
        description.get(new String[]{"children", "remote-store", "allowed"}).setEmptyList();
        description.get(new String[]{"children", "remote-store", "allowed"}).add("REMOTE_STORE");
        description.get(new String[]{"children", "remote-store", "model-description"});
    }

    private static void addStateTransferCacheChildren(String keyPrefix, ModelNode description, ResourceBundle resources) {
        description.get(new String[]{"children", "state-transfer", "description"}).set(resources.getString(keyPrefix + ".state-transfer"));
        description.get(new String[]{"children", "state-transfer", "min-occurs"}).set(0);
        description.get(new String[]{"children", "state-transfer", "max-occurs"}).set(1);
        description.get(new String[]{"children", "state-transfer", "allowed"}).setEmptyList();
        description.get(new String[]{"children", "state-transfer", "allowed"}).add("STATE_TRANSFER");
        description.get(new String[]{"children", "state-transfer", "model-description"});
    }

    private static void addCacheStoreWriteBehindCacheChildren(String keyPrefix, ModelNode description, ResourceBundle resources) {
        description.get(new String[]{"children", "write-behind", "description"}).set(resources.getString(keyPrefix + ".write-behind"));
        description.get(new String[]{"children", "write-behind", "min-occurs"}).set(0);
        description.get(new String[]{"children", "write-behind", "max-occurs"}).set(1);
        description.get(new String[]{"children", "write-behind", "allowed"}).add("WRITE_BEHIND");
        description.get(new String[]{"children", "write-behind", "model-description"});
    }

    private static void addCacheStorePropertyCacheChildren(String keyPrefix, ModelNode description, ResourceBundle resources) {
        description.get(new String[]{"children", "property", "description"}).set(resources.getString(keyPrefix + ".property"));
        description.get(new String[]{"children", "property", "min-occurs"}).set(0);
        description.get(new String[]{"children", "property", "max-occurs"}).set(1);
        description.get(new String[]{"children", "property", "model-description"});
    }

    private static void addCommonCacheAddRequestProperties(String keyPrefix, ModelNode operation, ResourceBundle resources) {
        for (AttributeDefinition attribute : CommonAttributes.CACHE_ATTRIBUTES) {
            attribute.addOperationParameterDescription(resources, keyPrefix, operation);
        }
    }

    private static void addCommonClusteredCacheAddRequestProperties(String keyPrefix, ModelNode operation, ResourceBundle resources) {
        for (AttributeDefinition attr : CommonAttributes.CLUSTERED_CACHE_ATTRIBUTES) {
            attr.addOperationParameterDescription(resources, keyPrefix, operation);
        }
    }
}

