/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.clustering.jgroups.subsystem;

import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.UUID;
import org.jboss.as.clustering.jgroups.ChannelFactory;
import org.jboss.as.clustering.jgroups.subsystem.ChannelFactoryService;
import org.jboss.as.clustering.jgroups.subsystem.CommonAttributes;
import org.jboss.as.clustering.msc.ServiceContainerHelper;
import org.jboss.as.controller.AbstractRuntimeOnlyHandler;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.ReloadRequiredWriteAttributeHandler;
import org.jboss.as.controller.operations.common.Util;
import org.jboss.as.controller.registry.AttributeAccess;
import org.jboss.as.controller.registry.ManagementResourceRegistration;
import org.jboss.as.controller.registry.Resource;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.Property;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.ServiceRegistry;
import org.jgroups.Channel;
import org.jgroups.stack.ProtocolStack;

public class StackConfigOperationHandlers {
    static final OperationStepHandler TRANSPORT_ADD = new TransportConfigAdd(CommonAttributes.TRANSPORT_PARAMETERS);
    static final SelfRegisteringAttributeHandler TRANSPORT_ATTR = new AttributeWriteHandler(CommonAttributes.TRANSPORT_ATTRIBUTES);
    static final OperationStepHandler PROTOCOL_ADD = new ProtocolConfigAdd(CommonAttributes.PROTOCOL_PARAMETERS);
    static final SelfRegisteringAttributeHandler PROTOCOL_ATTR = new AttributeWriteHandler(CommonAttributes.PROTOCOL_ATTRIBUTES);
    static final OperationStepHandler PROTOCOL_REMOVE = new ProtocolConfigRemove();
    static final OperationStepHandler REMOVE = new OperationStepHandler(){

        public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
            context.removeResource(PathAddress.EMPTY_ADDRESS);
            StackConfigOperationHandlers.reloadRequiredStep(context);
            context.completeStep();
        }
    };
    static final OperationStepHandler PROTOCOL_PROPERTY_ADD = new OperationStepHandler(){

        public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
            Resource resource = context.createResource(PathAddress.EMPTY_ADDRESS);
            CommonAttributes.VALUE.validateAndSet(operation, resource.getModel());
            StackConfigOperationHandlers.reloadRequiredStep(context);
            context.completeStep();
        }
    };
    static final OperationStepHandler PROTOCOL_PROPERTY_ATTR = new OperationStepHandler(){

        public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
            Resource resource = context.readResourceForUpdate(PathAddress.EMPTY_ADDRESS);
            CommonAttributes.VALUE.validateAndSet(operation, resource.getModel());
            StackConfigOperationHandlers.reloadRequiredStep(context);
            context.completeStep();
        }
    };
    static final OperationStepHandler EXPORT_NATIVE_CONFIGURATION = new ExportNativeConfiguration();

    static ModelNode createOperation(AttributeDefinition[] attributes, ModelNode address, ModelNode existing) throws OperationFailedException {
        ModelNode operation = Util.getEmptyOperation((String)"add", (ModelNode)address);
        for (AttributeDefinition attribute : attributes) {
            attribute.validateAndSet(existing, operation);
        }
        return operation;
    }

    static ModelNode createProtocolOperation(AttributeDefinition[] attributes, ModelNode address, ModelNode existing) throws OperationFailedException {
        ModelNode operation = Util.getEmptyOperation((String)"add-protocol", (ModelNode)address);
        for (AttributeDefinition attribute : attributes) {
            attribute.validateAndSet(existing, operation);
        }
        return operation;
    }

    static void reloadRequiredStep(OperationContext context) {
        if (context.getProcessType().isServer() && !context.isBooting()) {
            context.addStep(new OperationStepHandler(){

                public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
                    context.reloadRequired();
                    context.completeStep();
                    if (context.completeStep() == OperationContext.ResultAction.ROLLBACK) {
                        context.revertReloadRequired();
                    }
                }
            }, OperationContext.Stage.RUNTIME);
        }
    }

    static class AttributeWriteHandler
    extends ReloadRequiredWriteAttributeHandler
    implements SelfRegisteringAttributeHandler {
        final AttributeDefinition[] attributes;

        private AttributeWriteHandler(AttributeDefinition[] attributes) {
            super(attributes);
            this.attributes = attributes;
        }

        @Override
        public void registerAttributes(ManagementResourceRegistration registry) {
            EnumSet<AttributeAccess.Flag> flags = EnumSet.of(AttributeAccess.Flag.RESTART_ALL_SERVICES);
            for (AttributeDefinition attr : this.attributes) {
                registry.registerReadWriteAttribute(attr.getName(), null, (OperationStepHandler)this, flags);
            }
        }
    }

    static interface SelfRegisteringAttributeHandler
    extends OperationStepHandler {
        public void registerAttributes(ManagementResourceRegistration var1);
    }

    static class ExportNativeConfiguration
    extends AbstractRuntimeOnlyHandler {
        ExportNativeConfiguration() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void executeRuntimeStep(OperationContext context, ModelNode operation) throws OperationFailedException {
            PathAddress stackAddress = PathAddress.pathAddress((ModelNode)operation.get("address"));
            String stackName = stackAddress.getLastElement().getValue();
            ServiceRegistry registry = context.getServiceRegistry(false);
            ServiceName serviceName = ChannelFactoryService.getServiceName(stackName);
            try {
                ServiceController controller = registry.getRequiredService(serviceName);
                controller.setMode(ServiceController.Mode.ACTIVE);
                try {
                    ChannelFactory factory = (ChannelFactory)ServiceContainerHelper.getValue((ServiceController)controller, ChannelFactory.class);
                    Channel channel = factory.createChannel(UUID.randomUUID().toString());
                    try {
                        List protocols = channel.getProtocolStack().getProtocols();
                        Collections.reverse(protocols);
                        ProtocolStack stack = new ProtocolStack();
                        stack.addProtocols(protocols);
                        context.getResult().set(stack.printProtocolSpecAsXML());
                        context.completeStep();
                    }
                    finally {
                        channel.close();
                    }
                }
                finally {
                    controller.setMode(ServiceController.Mode.ON_DEMAND);
                }
            }
            catch (Exception e) {
                throw new OperationFailedException(e.getLocalizedMessage(), (Throwable)e);
            }
        }
    }

    static class ProtocolConfigRemove
    implements OperationStepHandler {
        ProtocolConfigRemove() {
        }

        public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
            Resource resource = context.readResourceForUpdate(PathAddress.EMPTY_ADDRESS);
            ModelNode subModel = resource.getModel();
            ModelNode type = CommonAttributes.TYPE.validateOperation(operation);
            PathElement protocolRelativePath = PathElement.pathElement((String)"protocol", (String)type.asString());
            if (!resource.hasChild(protocolRelativePath)) {
                throw new OperationFailedException(new ModelNode().set("protocol with relative path " + protocolRelativePath.toString() + " is not defined"));
            }
            context.removeResource(PathAddress.pathAddress((PathElement[])new PathElement[]{protocolRelativePath}));
            List protocols = subModel.get("protocols").asList();
            ModelNode newList = new ModelNode();
            if (protocols == null) {
                // empty if block
            }
            for (ModelNode protocol : protocols) {
                if (protocol.asString().equals(type.asString())) continue;
                newList.add(protocol);
            }
            subModel.get("protocols").set(newList);
            StackConfigOperationHandlers.reloadRequiredStep(context);
            context.completeStep();
        }
    }

    private static class ProtocolConfigAdd
    implements OperationStepHandler {
        private final AttributeDefinition[] attributes;

        ProtocolConfigAdd(AttributeDefinition[] attributes) {
            this.attributes = attributes;
        }

        public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
            Resource resource = context.readResourceForUpdate(PathAddress.EMPTY_ADDRESS);
            ModelNode subModel = resource.getModel();
            ModelNode type = CommonAttributes.TYPE.validateOperation(operation);
            PathElement protocolRelativePath = PathElement.pathElement((String)"protocol", (String)type.asString());
            if (resource.hasChild(protocolRelativePath)) {
                throw new OperationFailedException(new ModelNode().set("protocol with relative path " + protocolRelativePath.toString() + " is already defined"));
            }
            Resource childResource = context.createResource(PathAddress.pathAddress((PathElement[])new PathElement[]{protocolRelativePath}));
            ModelNode protocol = childResource.getModel();
            for (AttributeDefinition attribute : this.attributes) {
                if (attribute.getName().equals("properties")) continue;
                attribute.validateAndSet(operation, protocol);
            }
            ModelNode protocols = subModel.get("protocols");
            if (!protocols.isDefined()) {
                protocols.setEmptyList();
            }
            protocols.add(type);
            this.process(subModel, operation);
            if (operation.hasDefined("properties")) {
                for (Property property : operation.get("properties").asPropertyList()) {
                    Resource param = context.createResource(PathAddress.pathAddress((PathElement[])new PathElement[]{protocolRelativePath, PathElement.pathElement((String)"property", (String)property.getName())}));
                    ModelNode value = property.getValue();
                    if (!value.isDefined()) {
                        throw new OperationFailedException(new ModelNode().set("property " + property.getName() + " not defined"));
                    }
                    param.getModel().get("value").set(value);
                }
            }
            StackConfigOperationHandlers.reloadRequiredStep(context);
            context.completeStep();
        }

        void process(ModelNode subModel, ModelNode operation) {
        }
    }

    private static class TransportConfigAdd
    implements OperationStepHandler {
        private final AttributeDefinition[] attributes;

        TransportConfigAdd(AttributeDefinition[] attributes) {
            this.attributes = attributes;
        }

        public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
            Resource resource = context.createResource(PathAddress.EMPTY_ADDRESS);
            ModelNode subModel = resource.getModel();
            for (AttributeDefinition attribute : this.attributes) {
                if (attribute.getName().equals("properties")) continue;
                attribute.validateAndSet(operation, subModel);
            }
            this.process(subModel, operation);
            if (operation.hasDefined("properties")) {
                for (Property property : operation.get("properties").asPropertyList()) {
                    Resource param = context.createResource(PathAddress.pathAddress((PathElement[])new PathElement[]{PathElement.pathElement((String)"property", (String)property.getName())}));
                    ModelNode value = property.getValue();
                    if (!value.isDefined()) {
                        throw new OperationFailedException(new ModelNode().set("property " + property.getName() + " not defined"));
                    }
                    param.getModel().get("value").set(value);
                }
            }
            StackConfigOperationHandlers.reloadRequiredStep(context);
            context.completeStep();
        }

        void process(ModelNode subModel, ModelNode operation) {
        }
    }
}

