/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.cmp.jdbc;

import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.rmi.MarshalledObject;
import java.rmi.RemoteException;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Arrays;
import java.util.List;
import javax.ejb.Handle;
import org.jboss.as.cmp.jdbc.JDBCUtil;
import org.jboss.logging.Logger;

public interface JDBCResultSetReader {
    public static final JDBCResultSetReader CLOB_READER = new AbstractResultSetReader(){

        @Override
        protected Object readResult(ResultSet rs, int index, Class<?> destination) throws SQLException {
            String content;
            Clob clob = rs.getClob(index);
            if (clob == null) {
                content = null;
            } else {
                Reader reader = clob.getCharacterStream();
                if (reader != null) {
                    int intLength = (int)clob.length();
                    try {
                        if (intLength <= 8192) {
                            char[] chars = new char[intLength];
                            reader.read(chars);
                            content = String.valueOf(chars);
                        }
                        StringBuffer buf = new StringBuffer(intLength);
                        char[] chars = new char[8192];
                        int i = reader.read(chars);
                        while (i > 0) {
                            buf.append(chars, 0, i);
                            i = reader.read(chars);
                        }
                        content = buf.toString();
                    }
                    catch (IOException e) {
                        throw new SQLException("Failed to read CLOB character stream: " + e.getMessage());
                    }
                    finally {
                        JDBCUtil.safeClose(reader);
                    }
                } else {
                    content = null;
                }
            }
            return content;
        }
    };
    public static final JDBCResultSetReader LONGVARCHAR_READER = new AbstractResultSetReader(){

        @Override
        protected Object readResult(ResultSet rs, int index, Class<?> destination) throws SQLException {
            return JDBCUtil.getLongString(rs, index);
        }
    };
    public static final JDBCResultSetReader BINARY_READER = new AbstractResultSetReader(){

        @Override
        protected Object readResult(ResultSet rs, int index, Class<?> destination) throws SQLException {
            Object value = null;
            byte[] bytes = rs.getBytes(index);
            if (!rs.wasNull()) {
                value = destination == byte[].class ? bytes : (Object)JDBCUtil.convertToObject(bytes);
            }
            return value;
        }
    };
    public static final JDBCResultSetReader VARBINARY_READER = new AbstractResultSetReader(){

        @Override
        protected Object readResult(ResultSet rs, int index, Class<?> destination) throws SQLException {
            Object value = null;
            byte[] bytes = rs.getBytes(index);
            if (!rs.wasNull()) {
                value = destination == byte[].class ? bytes : (Object)JDBCUtil.convertToObject(bytes);
            }
            return value;
        }
    };
    public static final JDBCResultSetReader BLOB_READER = new AbstractResultSetReader(){

        @Override
        protected Object readResult(ResultSet rs, int index, Class<?> destination) throws SQLException {
            InputStream binaryData;
            Blob blob = rs.getBlob(index);
            Object value = blob == null ? null : ((binaryData = blob.getBinaryStream()) != null ? (destination == byte[].class ? JDBCUtil.getByteArray(binaryData) : (Object)JDBCUtil.convertToObject(binaryData)) : null);
            return value;
        }
    };
    public static final JDBCResultSetReader LONGVARBINARY_READER = new AbstractResultSetReader(){

        @Override
        protected Object readResult(ResultSet rs, int index, Class<?> destination) throws SQLException {
            Object value = null;
            InputStream binaryData = rs.getBinaryStream(index);
            if (binaryData != null && !rs.wasNull()) {
                value = destination == byte[].class ? JDBCUtil.getByteArray(binaryData) : (Object)JDBCUtil.convertToObject(binaryData);
            }
            return value;
        }
    };
    public static final JDBCResultSetReader JAVA_OBJECT_READER = new AbstractResultSetReader(){

        @Override
        protected Object readResult(ResultSet rs, int index, Class<?> destination) throws SQLException {
            return rs.getObject(index);
        }
    };
    public static final JDBCResultSetReader STRUCT_READER = new AbstractResultSetReader(){

        @Override
        protected Object readResult(ResultSet rs, int index, Class<?> destination) throws SQLException {
            return rs.getObject(index);
        }
    };
    public static final JDBCResultSetReader ARRAY_READER = new AbstractResultSetReader(){

        @Override
        protected Object readResult(ResultSet rs, int index, Class<?> destination) throws SQLException {
            return rs.getObject(index);
        }
    };
    public static final JDBCResultSetReader OTHER_READER = new AbstractResultSetReader(){

        @Override
        protected Object readResult(ResultSet rs, int index, Class<?> destination) throws SQLException {
            return rs.getObject(index);
        }
    };
    public static final JDBCResultSetReader JAVA_UTIL_DATE_READER = new AbstractResultSetReader(){

        @Override
        protected Object readResult(ResultSet rs, int index, Class<?> destination) throws SQLException {
            return rs.getTimestamp(index);
        }

        @Override
        protected Object coerceToJavaType(Object value, Class<?> destination) {
            java.util.Date result;
            if (value instanceof Timestamp) {
                Timestamp ts = (Timestamp)value;
                long temp = ts.getTime();
                if (temp % 1000L == 0L) {
                    temp += (long)(ts.getNanos() / 1000000);
                }
                result = new java.util.Date(temp);
            } else {
                result = new java.util.Date(((java.util.Date)value).getTime());
            }
            return result;
        }
    };
    public static final JDBCResultSetReader JAVA_SQL_DATE_READER = new AbstractResultSetReader(){

        @Override
        protected Object readResult(ResultSet rs, int index, Class<?> destination) throws SQLException {
            return rs.getDate(index);
        }

        @Override
        protected Object coerceToJavaType(Object value, Class<?> destination) {
            return new Date(((Date)value).getTime());
        }
    };
    public static final JDBCResultSetReader JAVA_SQL_TIME_READER = new AbstractResultSetReader(){

        @Override
        protected Object readResult(ResultSet rs, int index, Class<?> destination) throws SQLException {
            return rs.getTime(index);
        }

        @Override
        protected Object coerceToJavaType(Object value, Class<?> destination) {
            return new Time(((Time)value).getTime());
        }
    };
    public static final JDBCResultSetReader JAVA_SQL_TIMESTAMP_READER = new AbstractResultSetReader(){

        @Override
        protected Object readResult(ResultSet rs, int index, Class<?> destination) throws SQLException {
            return rs.getTimestamp(index);
        }

        @Override
        protected Object coerceToJavaType(Object value, Class<?> destination) {
            Timestamp orignal = (Timestamp)value;
            Timestamp copy = new Timestamp(orignal.getTime());
            copy.setNanos(orignal.getNanos());
            return copy;
        }
    };
    public static final JDBCResultSetReader BIGDECIMAL_READER = new AbstractResultSetReader(){

        @Override
        protected Object readResult(ResultSet rs, int index, Class<?> destination) throws SQLException {
            return rs.getBigDecimal(index);
        }
    };
    public static final JDBCResultSetReader REF_READER = new AbstractResultSetReader(){

        @Override
        protected Object readResult(ResultSet rs, int index, Class<?> destination) throws SQLException {
            return rs.getRef(index);
        }
    };
    public static final JDBCResultSetReader BYTE_ARRAY_READER = new AbstractResultSetReader(){

        @Override
        protected Object readResult(ResultSet rs, int index, Class<?> destination) throws SQLException {
            return rs.getBytes(index);
        }
    };
    public static final JDBCResultSetReader OBJECT_READER = new AbstractResultSetReader(){

        @Override
        protected Object readResult(ResultSet rs, int index, Class<?> destination) throws SQLException {
            return rs.getObject(index);
        }
    };
    public static final JDBCResultSetReader STRING_READER = new JDBCResultSetReader(){

        @Override
        public Object get(ResultSet rs, int index, Class<?> destination, Logger log) throws SQLException {
            String result = rs.getString(index);
            if (log.isTraceEnabled()) {
                log.trace((Object)("result: i=" + index + ", type=" + destination.getName() + ", value=" + result));
            }
            return result;
        }
    };
    public static final JDBCResultSetReader BOOLEAN_READER = new AbstractPrimitiveReader(){

        @Override
        protected Object readResult(ResultSet rs, int index, Class<?> destination) throws SQLException {
            return rs.getBoolean(index) ? Boolean.TRUE : Boolean.FALSE;
        }
    };
    public static final JDBCResultSetReader BYTE_READER = new AbstractPrimitiveReader(){

        @Override
        protected Object readResult(ResultSet rs, int index, Class<?> destination) throws SQLException {
            return new Byte(rs.getByte(index));
        }
    };
    public static final JDBCResultSetReader CHARACTER_READER = new AbstractPrimitiveReader(){

        @Override
        protected Object readResult(ResultSet rs, int index, Class<?> destination) throws SQLException {
            return rs.getString(index);
        }

        @Override
        protected Object coerceToJavaType(Object value, Class<?> destination) {
            if (value instanceof String && (destination == Character.class || destination == Character.TYPE)) {
                return new Character(((String)value).charAt(0));
            }
            return value;
        }
    };
    public static final JDBCResultSetReader SHORT_READER = new AbstractPrimitiveReader(){

        @Override
        protected Object readResult(ResultSet rs, int index, Class<?> destination) throws SQLException {
            return new Short(rs.getShort(index));
        }
    };
    public static final JDBCResultSetReader INT_READER = new AbstractPrimitiveReader(){

        @Override
        protected Object readResult(ResultSet rs, int index, Class<?> destination) throws SQLException {
            return new Integer(rs.getInt(index));
        }
    };
    public static final JDBCResultSetReader LONG_READER = new AbstractPrimitiveReader(){

        @Override
        protected Object readResult(ResultSet rs, int index, Class<?> destination) throws SQLException {
            return new Long(rs.getLong(index));
        }
    };
    public static final JDBCResultSetReader FLOAT_READER = new AbstractPrimitiveReader(){

        @Override
        protected Object readResult(ResultSet rs, int index, Class<?> destination) throws SQLException {
            return new Float(rs.getFloat(index));
        }
    };
    public static final JDBCResultSetReader DOUBLE_READER = new AbstractPrimitiveReader(){

        @Override
        protected Object readResult(ResultSet rs, int index, Class<?> destination) throws SQLException {
            return new Double(rs.getDouble(index));
        }
    };

    public Object get(ResultSet var1, int var2, Class<?> var3, Logger var4) throws SQLException;

    public static abstract class AbstractResultSetReader
    implements JDBCResultSetReader {
        @Override
        public Object get(ResultSet rs, int index, Class<?> destination, Logger log) throws SQLException {
            Object result = this.readResult(rs, index, destination);
            if (result != null) {
                result = this.coerceToJavaType(result, destination);
            }
            if (log.isTraceEnabled()) {
                log.trace((Object)("result: i=" + index + ", type=" + destination.getName() + ", value=" + result));
            }
            return result;
        }

        protected abstract Object readResult(ResultSet var1, int var2, Class<?> var3) throws SQLException;

        protected Object coerceToJavaType(Object value, Class<?> destination) throws SQLException {
            try {
                if (value instanceof MarshalledObject && !destination.equals(MarshalledObject.class)) {
                    value = ((MarshalledObject)value).get();
                }
                if (value instanceof Handle) {
                    value = ((Handle)value).getEJBObject();
                }
                if (destination.isAssignableFrom(value.getClass())) {
                    return value;
                }
                if (destination == BigInteger.class && value.getClass() == BigDecimal.class) {
                    return ((BigDecimal)value).toBigInteger();
                }
                String className = null;
                List<Class<?>> interfaces = null;
                ClassLoader cl = null;
                if (value != null) {
                    Class<?> valueClass = value.getClass();
                    className = valueClass.getName();
                    interfaces = Arrays.asList(valueClass.getInterfaces());
                    cl = valueClass.getClassLoader();
                }
                throw new SQLException("Got a " + className + "[cl=" + cl + " + interfaces=" + interfaces + ", value=" + value + "] while looking for a " + destination.getName() + "[cl=" + destination.getClassLoader() + "]");
            }
            catch (RemoteException e) {
                throw new SQLException("Unable to load EJBObject back from Handle: " + e);
            }
            catch (IOException e) {
                throw new SQLException("Unable to load to deserialize result: " + e);
            }
            catch (ClassNotFoundException e) {
                throw new SQLException("Unable to load to deserialize result: " + e);
            }
        }
    }

    public static abstract class AbstractPrimitiveReader
    extends AbstractResultSetReader {
        @Override
        public Object get(ResultSet rs, int index, Class<?> destination, Logger log) throws SQLException {
            Object result = this.readResult(rs, index, destination);
            result = rs.wasNull() ? null : this.coerceToJavaType(result, destination);
            if (log.isTraceEnabled()) {
                log.trace((Object)("result: i=" + index + ", type=" + destination.getName() + ", value=" + result));
            }
            return result;
        }

        @Override
        protected Object coerceToJavaType(Object value, Class<?> destination) throws SQLException {
            return value;
        }
    }
}

