/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.cmp.jdbc.bridge;

import java.util.ArrayList;
import java.util.Collection;
import java.util.ConcurrentModificationException;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.ejb.EJBException;
import javax.ejb.EJBLocalObject;
import javax.ejb.NoSuchObjectLocalException;
import org.jboss.as.cmp.context.CmpEntityBeanContext;
import org.jboss.as.cmp.jdbc.bridge.JDBCCMRFieldBridge;

public class RelationSet
implements Set {
    private JDBCCMRFieldBridge cmrField;
    private CmpEntityBeanContext ctx;
    private List[] setHandle;
    private boolean readOnly;
    private Class relatedLocalInterface;

    public RelationSet(JDBCCMRFieldBridge cmrField, CmpEntityBeanContext ctx, List[] setHandle, boolean readOnly) {
        this.cmrField = cmrField;
        this.ctx = ctx;
        this.setHandle = setHandle;
        this.readOnly = readOnly;
        this.relatedLocalInterface = cmrField.getRelatedLocalInterface();
    }

    private List getIdList() {
        if (this.setHandle[0] == null) {
            throw new IllegalStateException("A CMR collection may only be used within the transaction in which it was created");
        }
        return this.setHandle[0];
    }

    @Override
    public int size() {
        List idList = this.getIdList();
        return idList.size();
    }

    @Override
    public boolean isEmpty() {
        List idList = this.getIdList();
        return idList.isEmpty();
    }

    @Override
    public boolean add(Object o) {
        if (o == null) {
            throw new IllegalArgumentException("Null cannot be added to a CMR relationship collection");
        }
        RelationSet.checkForPKChange();
        List idList = this.getIdList();
        if (this.readOnly) {
            throw new EJBException("This collection is a read-only snapshot");
        }
        if (this.cmrField.isReadOnly()) {
            throw new EJBException("Field is read-only: " + this.cmrField.getFieldName());
        }
        if (!this.relatedLocalInterface.isInstance(o)) {
            String msg = "Object must be an instance of " + this.relatedLocalInterface.getName() + ", but is an isntance of [";
            Class<?>[] classes = o.getClass().getInterfaces();
            for (int i = 0; i < classes.length; ++i) {
                if (i > 0) {
                    msg = msg + ", ";
                }
                msg = msg + classes[i].getName();
            }
            msg = msg + "]";
            throw new IllegalArgumentException(msg);
        }
        Object id = this.getPrimaryKey((EJBLocalObject)o);
        if (idList.contains(id)) {
            return false;
        }
        this.cmrField.createRelationLinks(this.ctx, id);
        return true;
    }

    @Override
    public boolean addAll(Collection c) {
        if (this.readOnly) {
            throw new EJBException("This collection is a read-only snapshot");
        }
        if (this.cmrField.isReadOnly()) {
            throw new EJBException("Field is read-only: " + this.cmrField.getFieldName());
        }
        if (c == null) {
            return false;
        }
        boolean isModified = false;
        Iterator iterator = new HashSet(c).iterator();
        while (iterator.hasNext()) {
            isModified = this.add(iterator.next()) || isModified;
        }
        return isModified;
    }

    @Override
    public boolean remove(Object o) {
        List idList = this.getIdList();
        if (this.readOnly) {
            throw new EJBException("This collection is a read-only snapshot");
        }
        if (this.cmrField.isReadOnly()) {
            throw new EJBException("Field is read-only: " + this.cmrField.getFieldName());
        }
        RelationSet.checkForPKChange();
        if (!this.relatedLocalInterface.isInstance(o)) {
            throw new IllegalArgumentException("Object must be an instance of " + this.relatedLocalInterface.getName());
        }
        Object id = this.getPrimaryKey((EJBLocalObject)o);
        if (!idList.contains(id)) {
            return false;
        }
        this.cmrField.destroyRelationLinks(this.ctx, id);
        return true;
    }

    @Override
    public boolean removeAll(Collection c) {
        if (this.readOnly) {
            throw new EJBException("This collection is a read-only snapshot");
        }
        if (this.cmrField.isReadOnly()) {
            throw new EJBException("Field is read-only: " + this.cmrField.getFieldName());
        }
        if (c == null) {
            return false;
        }
        boolean isModified = false;
        Iterator iterator = new HashSet(c).iterator();
        while (iterator.hasNext()) {
            isModified = this.remove(iterator.next()) || isModified;
        }
        return isModified;
    }

    @Override
    public void clear() {
        RelationSet.checkForPKChange();
        List idList = this.getIdList();
        if (this.readOnly) {
            throw new EJBException("This collection is a read-only snapshot");
        }
        if (this.cmrField.isReadOnly()) {
            throw new EJBException("Field is read-only: " + this.cmrField.getFieldName());
        }
        Iterator iterator = new ArrayList(idList).iterator();
        while (iterator.hasNext()) {
            this.cmrField.destroyRelationLinks(this.ctx, iterator.next());
        }
    }

    @Override
    public boolean retainAll(Collection c) {
        List idList = this.getIdList();
        if (this.readOnly) {
            throw new EJBException("This collection is a read-only snapshot");
        }
        if (this.cmrField.isReadOnly()) {
            throw new EJBException("Field is read-only: " + this.cmrField.getFieldName());
        }
        RelationSet.checkForPKChange();
        if (c == null) {
            if (idList.size() == 0) {
                return false;
            }
            this.clear();
            return true;
        }
        ArrayList<Object> argIds = new ArrayList<Object>();
        for (EJBLocalObject localObject : c) {
            Object relatedId = this.getPrimaryKey(localObject);
            argIds.add(relatedId);
        }
        boolean isModified = false;
        for (Object id : new ArrayList(idList)) {
            if (argIds.contains(id)) continue;
            this.cmrField.destroyRelationLinks(this.ctx, id);
            isModified = true;
        }
        return isModified;
    }

    @Override
    public boolean contains(Object o) {
        List idList = this.getIdList();
        if (!this.relatedLocalInterface.isInstance(o)) {
            throw new IllegalArgumentException("Object must be an instance of " + this.relatedLocalInterface.getName());
        }
        Object id = this.getPrimaryKey((EJBLocalObject)o);
        return idList.contains(id);
    }

    @Override
    public boolean containsAll(Collection c) {
        List idList = this.getIdList();
        if (c == null) {
            return true;
        }
        ArrayList<Object> argIds = new ArrayList<Object>();
        for (EJBLocalObject localObject : c) {
            Object relatedId = this.getPrimaryKey(localObject);
            argIds.add(relatedId);
        }
        return idList.containsAll(argIds);
    }

    @Override
    public Object[] toArray(Object[] a) {
        List idList = this.getIdList();
        Collection<Object> c = this.cmrField.getRelatedComponent().getEntityLocalCollection(idList);
        return c.toArray(a);
    }

    @Override
    public Object[] toArray() {
        List idList = this.getIdList();
        Collection<Object> c = this.cmrField.getRelatedComponent().getEntityLocalCollection(idList);
        return c.toArray();
    }

    private static void checkForPKChange() {
    }

    @Override
    public Iterator iterator() {
        return new Iterator(){
            private final Iterator idIterator;
            private Object currentId;
            {
                this.idIterator = RelationSet.this.getIdList().iterator();
            }

            @Override
            public boolean hasNext() {
                this.verifyIteratorIsValid();
                try {
                    return this.idIterator.hasNext();
                }
                catch (ConcurrentModificationException e) {
                    throw new IllegalStateException("Underlying collection has been modified");
                }
            }

            public Object next() {
                this.verifyIteratorIsValid();
                try {
                    this.currentId = this.idIterator.next();
                    return RelationSet.this.cmrField.getRelatedComponent().getEjbLocalObject(this.currentId);
                }
                catch (ConcurrentModificationException e) {
                    throw new IllegalStateException("Underlying collection has been modified");
                }
            }

            @Override
            public void remove() {
                this.verifyIteratorIsValid();
                if (RelationSet.this.readOnly) {
                    throw new EJBException("This collection is a read-only snapshot");
                }
                if (RelationSet.this.cmrField.isReadOnly()) {
                    throw new EJBException("Field is read-only: " + RelationSet.this.cmrField.getFieldName());
                }
                RelationSet.checkForPKChange();
                try {
                    this.idIterator.remove();
                    RelationSet.this.cmrField.destroyRelationLinks(RelationSet.this.ctx, this.currentId, false);
                }
                catch (ConcurrentModificationException e) {
                    throw new IllegalStateException("Underlying collection has been modified");
                }
            }

            private void verifyIteratorIsValid() {
                if (RelationSet.this.setHandle[0] == null) {
                    throw new IllegalStateException("The iterator of a CMR collection may only be used within the transction in which it was created");
                }
            }
        };
    }

    public String toString() {
        return new StringBuffer().append('[').append(this.cmrField.getEntity().getEntityName()).append('.').append(this.cmrField.getFieldName()).append(':').append(this.getIdList()).append(']').toString();
    }

    private Object getPrimaryKey(EJBLocalObject o) {
        try {
            return o.getPrimaryKey();
        }
        catch (NoSuchObjectLocalException e) {
            throw new IllegalArgumentException(e.getMessage());
        }
    }
}

