/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.cmp.jdbc.metadata;

import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.jboss.as.cmp.jdbc.metadata.JDBCDeclaredQueryMetaData;
import org.jboss.as.cmp.jdbc.metadata.JDBCDynamicQLQueryMetaData;
import org.jboss.as.cmp.jdbc.metadata.JDBCEntityMetaData;
import org.jboss.as.cmp.jdbc.metadata.JDBCJBossQLQueryMetaData;
import org.jboss.as.cmp.jdbc.metadata.JDBCQlQueryMetaData;
import org.jboss.as.cmp.jdbc.metadata.JDBCQueryMetaData;
import org.jboss.as.cmp.jdbc.metadata.JDBCRawSqlQueryMetaData;
import org.jboss.as.cmp.jdbc.metadata.JDBCReadAheadMetaData;
import org.jboss.as.cmp.jdbc.metadata.parser.ParsedQuery;
import org.jboss.metadata.ejb.spec.QueryMetaData;
import org.jboss.util.Classes;

public class JDBCQueryMetaDataFactory {
    private JDBCEntityMetaData entity;

    public JDBCQueryMetaDataFactory(JDBCEntityMetaData entity) {
        this.entity = entity;
    }

    public Map<Method, JDBCQueryMetaData> createJDBCQueryMetaData(QueryMetaData queryData) {
        List<Method> methods = this.getQueryMethods(queryData);
        HashMap<Method, JDBCQueryMetaData> queries = new HashMap<Method, JDBCQueryMetaData>(methods.size());
        for (Method method : methods) {
            queries.put(method, new JDBCQlQueryMetaData(queryData, method, this.entity.getQlCompiler(), false));
        }
        return queries;
    }

    public JDBCQueryMetaData createJDBCQueryMetaData(JDBCQueryMetaData jdbcQueryMetaData, JDBCReadAheadMetaData readAhead, Class<?> qlCompiler) {
        if (jdbcQueryMetaData instanceof JDBCRawSqlQueryMetaData) {
            return new JDBCRawSqlQueryMetaData(jdbcQueryMetaData.getMethod(), qlCompiler, false);
        }
        if (jdbcQueryMetaData instanceof JDBCJBossQLQueryMetaData) {
            return new JDBCJBossQLQueryMetaData((JDBCJBossQLQueryMetaData)jdbcQueryMetaData, readAhead, null, qlCompiler, false);
        }
        if (jdbcQueryMetaData instanceof JDBCDynamicQLQueryMetaData) {
            return new JDBCDynamicQLQueryMetaData((JDBCDynamicQLQueryMetaData)jdbcQueryMetaData, readAhead, qlCompiler, false);
        }
        if (jdbcQueryMetaData instanceof JDBCDeclaredQueryMetaData) {
            return new JDBCDeclaredQueryMetaData((JDBCDeclaredQueryMetaData)jdbcQueryMetaData, readAhead, qlCompiler, false);
        }
        if (jdbcQueryMetaData instanceof JDBCQlQueryMetaData) {
            return new JDBCQlQueryMetaData((JDBCQlQueryMetaData)jdbcQueryMetaData, readAhead, qlCompiler, false);
        }
        throw new RuntimeException("Error in query specification for method " + jdbcQueryMetaData.getMethod().getName());
    }

    public List<JDBCQueryMetaData> createJDBCQueryMetaData(ParsedQuery parsedQuery) {
        Class[] parameters;
        try {
            parameters = Classes.convertToJavaClasses(parsedQuery.getMethodParams().iterator(), (ClassLoader)this.entity.getJDBCApplication().getClassLoader());
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException("Failed to convert method params to class instances: " + parsedQuery.getMethodParams());
        }
        List<Method> methods = this.getQueryMethods(parsedQuery.getMethodName(), parameters);
        Class<?> qlCompiler = parsedQuery.getQlCompiler() != null ? parsedQuery.getQlCompiler() : this.entity.getQlCompiler();
        JDBCReadAheadMetaData readAhead = parsedQuery.getReadAheadMetaData() != null ? new JDBCReadAheadMetaData(parsedQuery.getReadAheadMetaData(), this.entity.getReadAhead()) : this.entity.getReadAhead();
        ArrayList<JDBCQueryMetaData> built = new ArrayList<JDBCQueryMetaData>(methods.size());
        for (Method method : methods) {
            JDBCQueryMetaData queryMetaData;
            JDBCQueryMetaData defaultValue = this.entity.getQueryMetaDataForMethod(method);
            boolean isResultTypeMappingLocal = defaultValue != null && defaultValue.isResultTypeMappingLocal();
            switch (parsedQuery.getType()) {
                case RAW_SQL: {
                    queryMetaData = new JDBCRawSqlQueryMetaData(method, qlCompiler, parsedQuery.isLazyResultsetLoading());
                    break;
                }
                case JBOSS_QL: {
                    queryMetaData = new JDBCJBossQLQueryMetaData(isResultTypeMappingLocal, parsedQuery.getQuery(), method, readAhead, qlCompiler, parsedQuery.isLazyResultsetLoading());
                    break;
                }
                case DYNAMIC_QL: {
                    queryMetaData = new JDBCDynamicQLQueryMetaData(isResultTypeMappingLocal, method, readAhead, qlCompiler, parsedQuery.isLazyResultsetLoading());
                    break;
                }
                case DECLARED_QL: {
                    queryMetaData = new JDBCDeclaredQueryMetaData(isResultTypeMappingLocal, method, readAhead, qlCompiler, parsedQuery.isLazyResultsetLoading(), parsedQuery.getDeclaredParts());
                    break;
                }
                default: {
                    if (defaultValue != null && defaultValue instanceof JDBCQlQueryMetaData) {
                        queryMetaData = new JDBCQlQueryMetaData((JDBCQlQueryMetaData)defaultValue, readAhead, qlCompiler, false);
                        break;
                    }
                    throw new RuntimeException("Error in query specification for method " + method.getName());
                }
            }
            built.add(queryMetaData);
        }
        return built;
    }

    private List<Method> getQueryMethods(QueryMetaData queryData) {
        String methodName = queryData.getQueryMethod().getMethodName();
        try {
            Class[] parameters = Classes.convertToJavaClasses((Iterator)queryData.getQueryMethod().getMethodParams().iterator(), (ClassLoader)this.entity.getJDBCApplication().getClassLoader());
            return this.getQueryMethods(methodName, parameters);
        }
        catch (ClassNotFoundException cnfe) {
            throw new RuntimeException(cnfe.getMessage());
        }
    }

    private List<Method> getQueryMethods(String methodName, Class<?>[] parameters) {
        ArrayList<Method> methods = new ArrayList<Method>(2);
        if (methodName.startsWith("ejbSelect")) {
            Method method = JDBCQueryMetaDataFactory.getQueryMethod(methodName, parameters, this.entity.getEntityClass());
            if (method != null) {
                methods.add(method);
            }
        } else {
            Method method;
            Class<?> localHomeClass;
            Method method2;
            Class<?> homeClass = this.entity.getHomeClass();
            if (homeClass != null && (method2 = JDBCQueryMetaDataFactory.getQueryMethod(methodName, parameters, homeClass)) != null) {
                methods.add(method2);
            }
            if ((localHomeClass = this.entity.getLocalHomeClass()) != null && (method = JDBCQueryMetaDataFactory.getQueryMethod(methodName, parameters, localHomeClass)) != null) {
                methods.add(method);
            }
        }
        if (methods.size() == 0) {
            StringBuffer sb = new StringBuffer(300);
            sb.append("Query method not found: ").append(methodName).append('(');
            for (int i = 0; i < parameters.length; ++i) {
                if (i > 0) {
                    sb.append(',');
                }
                sb.append(parameters[i].getName());
            }
            sb.append(')');
            throw new RuntimeException(sb.toString());
        }
        return methods;
    }

    private static Method getQueryMethod(String queryName, Class<?>[] parameters, Class<?> clazz) {
        try {
            Method method = clazz.getMethod(queryName, parameters);
            if (Modifier.isAbstract(method.getModifiers())) {
                return method;
            }
        }
        catch (NoSuchMethodException noSuchMethodException) {
            // empty catch block
        }
        return null;
    }

    public static enum Type {
        RAW_SQL,
        JBOSS_QL,
        DYNAMIC_QL,
        DECLARED_QL,
        EJB_QL;

    }
}

