/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.cmp.jdbc.metadata.parser;

import java.sql.Types;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.jboss.as.cmp.jdbc.SQLUtil;
import org.jboss.as.cmp.jdbc.metadata.JDBCApplicationMetaData;
import org.jboss.as.cmp.jdbc.metadata.JDBCCMPFieldPropertyMetaData;
import org.jboss.as.cmp.jdbc.metadata.JDBCEntityCommandMetaData;
import org.jboss.as.cmp.jdbc.metadata.JDBCFunctionMappingMetaData;
import org.jboss.as.cmp.jdbc.metadata.JDBCLeftJoinMetaData;
import org.jboss.as.cmp.jdbc.metadata.JDBCMappingMetaData;
import org.jboss.as.cmp.jdbc.metadata.JDBCOptimisticLockingMetaData;
import org.jboss.as.cmp.jdbc.metadata.JDBCQueryMetaDataFactory;
import org.jboss.as.cmp.jdbc.metadata.JDBCRelationMetaData;
import org.jboss.as.cmp.jdbc.metadata.JDBCTypeMappingMetaData;
import org.jboss.as.cmp.jdbc.metadata.JDBCUserTypeMappingMetaData;
import org.jboss.as.cmp.jdbc.metadata.JDBCValueClassMetaData;
import org.jboss.as.cmp.jdbc.metadata.JDBCValuePropertyMetaData;
import org.jboss.as.cmp.jdbc.metadata.parser.Attribute;
import org.jboss.as.cmp.jdbc.metadata.parser.Element;
import org.jboss.as.cmp.jdbc.metadata.parser.ParsedApplication;
import org.jboss.as.cmp.jdbc.metadata.parser.ParsedAudit;
import org.jboss.as.cmp.jdbc.metadata.parser.ParsedCmpField;
import org.jboss.as.cmp.jdbc.metadata.parser.ParsedEntity;
import org.jboss.as.cmp.jdbc.metadata.parser.ParsedOptimisticLocking;
import org.jboss.as.cmp.jdbc.metadata.parser.ParsedQuery;
import org.jboss.as.cmp.jdbc.metadata.parser.ParsedReadAhead;
import org.jboss.as.cmp.jdbc.metadata.parser.ParsedRelationship;
import org.jboss.as.cmp.jdbc.metadata.parser.ParsedRelationshipRole;
import org.jboss.metadata.parser.util.MetaDataElementParser;

public class JDBCMetaDataParser
extends MetaDataElementParser {
    public static JDBCApplicationMetaData parse(XMLStreamReader reader, JDBCApplicationMetaData defaults) throws XMLStreamException {
        JDBCMetaDataParser.moveToStart(reader);
        ParsedApplication application = new ParsedApplication();
        block10: for (Element element : JDBCMetaDataParser.children(reader)) {
            switch (element) {
                case DEFAULTS: {
                    application.defaultEntity = JDBCMetaDataParser.parseEntity(reader, defaults.getClassLoader());
                    continue block10;
                }
                case RELATIONSHIPS: {
                    application.relationships = JDBCMetaDataParser.parseRelationships(reader);
                    continue block10;
                }
                case ENTERPRISE_BEANS: {
                    application.entities = JDBCMetaDataParser.parseEnterpriseBeans(reader, defaults.getClassLoader());
                    continue block10;
                }
                case TYPE_MAPPINGS: {
                    application.typeMappings = JDBCMetaDataParser.parseTypeMappings(reader);
                    continue block10;
                }
                case ENTITY_COMMANDS: {
                    application.entityCommands = JDBCMetaDataParser.parseEntityCommands(reader, defaults.getClassLoader());
                    continue block10;
                }
                case DEPENDENT_VALUE_CLASSES: {
                    application.valueClasses = JDBCMetaDataParser.parseDependentValueClasses(reader, defaults.getClassLoader());
                    continue block10;
                }
                case USER_TYPE_MAPPINGS: {
                    application.userTypeMappings = JDBCMetaDataParser.parseUserTypeMappings(reader);
                    continue block10;
                }
                case RESERVED_WORDS: {
                    JDBCMetaDataParser.parseReservedWords(reader);
                    continue block10;
                }
            }
            throw JDBCMetaDataParser.unexpectedElement((XMLStreamReader)reader);
        }
        return new JDBCApplicationMetaData(application, defaults);
    }

    private static List<JDBCTypeMappingMetaData> parseTypeMappings(XMLStreamReader reader) throws XMLStreamException {
        ArrayList<JDBCTypeMappingMetaData> typeMappings = new ArrayList<JDBCTypeMappingMetaData>();
        block3: for (Element element : JDBCMetaDataParser.children(reader)) {
            switch (element) {
                case TYPE_MAPPING: {
                    typeMappings.add(JDBCMetaDataParser.parseTypeMapping(reader));
                    continue block3;
                }
            }
            throw JDBCMetaDataParser.unexpectedElement((XMLStreamReader)reader);
        }
        return typeMappings;
    }

    private static JDBCTypeMappingMetaData parseTypeMapping(XMLStreamReader reader) throws XMLStreamException {
        JDBCTypeMappingMetaData metaData = new JDBCTypeMappingMetaData();
        block23: for (Element element : JDBCMetaDataParser.children(reader)) {
            switch (element) {
                case NAME: {
                    metaData.setName(JDBCMetaDataParser.getElementText((XMLStreamReader)reader));
                    continue block23;
                }
                case ADD_COLUMN_TEMPLATE: {
                    String value = JDBCMetaDataParser.getElementText((XMLStreamReader)reader);
                    if (!JDBCMetaDataParser.isEmpty(value)) {
                        metaData.setAddColomnTemplate(new JDBCFunctionMappingMetaData("add-column-template", value));
                        continue block23;
                    }
                    metaData.setAddColomnTemplate(new JDBCFunctionMappingMetaData("add-column-template", "ALTER TABLE ?1 ADD ?2 ?3"));
                    continue block23;
                }
                case ALIAS_HEADER_PREFIX: {
                    String value = JDBCMetaDataParser.getElementText((XMLStreamReader)reader);
                    if (JDBCMetaDataParser.isEmpty(value)) continue block23;
                    metaData.setAliasHeaderPrefix(value);
                    continue block23;
                }
                case ALIAS_HEADER_SUFFIX: {
                    String value = JDBCMetaDataParser.getElementText((XMLStreamReader)reader);
                    if (JDBCMetaDataParser.isEmpty(value)) continue block23;
                    metaData.setAliasHeaderSuffix(value);
                    continue block23;
                }
                case ALIAS_MAX_LENGHT: {
                    String value = JDBCMetaDataParser.getElementText((XMLStreamReader)reader);
                    try {
                        int aliasMaxLength = Integer.parseInt(value);
                        metaData.setAliasMaxLength(aliasMaxLength);
                        continue block23;
                    }
                    catch (NumberFormatException e) {
                        throw new IllegalArgumentException("Invalid number format in alias-max-length " + value + "': " + e);
                    }
                }
                case ALTER_COLUMN_TEMPLATE: {
                    String value = JDBCMetaDataParser.getElementText((XMLStreamReader)reader);
                    if (!JDBCMetaDataParser.isEmpty(value)) {
                        metaData.setAlterColomnTemplate(new JDBCFunctionMappingMetaData("add-column-template", value));
                        continue block23;
                    }
                    metaData.setAlterColomnTemplate(new JDBCFunctionMappingMetaData("add-column-template", "ALTER TABLE ?1 ADD ?2 ?3"));
                    continue block23;
                }
                case AUTO_INCREMENT_TEMPLATE: {
                    String value = JDBCMetaDataParser.getElementText((XMLStreamReader)reader);
                    if (JDBCMetaDataParser.isEmpty(value)) continue block23;
                    metaData.setAutoIncrementTemplate(new JDBCFunctionMappingMetaData("auto-increment", value));
                    continue block23;
                }
                case DROP_COLUMN_TEMPLATE: {
                    String value = JDBCMetaDataParser.getElementText((XMLStreamReader)reader);
                    if (!JDBCMetaDataParser.isEmpty(value)) {
                        metaData.setDropColomnTemplate(new JDBCFunctionMappingMetaData("drop-column-template", value));
                        continue block23;
                    }
                    metaData.setDropColomnTemplate(new JDBCFunctionMappingMetaData("drop-column-template", "ALTER TABLE ?1 DROP ?2"));
                    continue block23;
                }
                case FALSE_MAPPING: {
                    String value = JDBCMetaDataParser.getElementText((XMLStreamReader)reader);
                    if (JDBCMetaDataParser.isEmpty(value)) continue block23;
                    metaData.setFalseMapping(value);
                    continue block23;
                }
                case FK_CONSTRAINT_TEMPLATE: {
                    String value = JDBCMetaDataParser.getElementText((XMLStreamReader)reader);
                    if (JDBCMetaDataParser.isEmpty(value)) continue block23;
                    metaData.setFKConstraintTemplate(new JDBCFunctionMappingMetaData("fk-constraint", value));
                    continue block23;
                }
                case FUNCTION_MAPPING: {
                    metaData.addFunctionMapping(JDBCMetaDataParser.parseFuctionMapping(reader));
                    continue block23;
                }
                case MAPPING: {
                    metaData.addMapping(JDBCMetaDataParser.parseMapping(reader));
                    continue block23;
                }
                case MAX_KEYS_IN_DELETE: {
                    String value = JDBCMetaDataParser.getElementText((XMLStreamReader)reader);
                    try {
                        int maxKeys = Integer.parseInt(value);
                        metaData.setMaxKeysInDelete(maxKeys);
                        continue block23;
                    }
                    catch (NumberFormatException e) {
                        throw new IllegalArgumentException("Invalid number format in max-keys-in-delete " + value + "': " + e);
                    }
                }
                case PK_CONSTRAINT_TEMPLATE: {
                    String value = JDBCMetaDataParser.getElementText((XMLStreamReader)reader);
                    if (JDBCMetaDataParser.isEmpty(value)) continue block23;
                    metaData.setPKConstraintTemplate(new JDBCFunctionMappingMetaData("pk-constraint", value));
                    continue block23;
                }
                case ROW_LOCKING_TEMPLATE: {
                    String value = JDBCMetaDataParser.getElementText((XMLStreamReader)reader);
                    if (JDBCMetaDataParser.isEmpty(value)) continue block23;
                    metaData.setRowLockingTemplate(new JDBCFunctionMappingMetaData("row-locking", value));
                    continue block23;
                }
                case SUBQUERY_SUPPORTED: {
                    metaData.setSubQuerySupported(Boolean.valueOf(JDBCMetaDataParser.getElementText((XMLStreamReader)reader)));
                    continue block23;
                }
                case TRUE_MAPPING: {
                    String value = JDBCMetaDataParser.getElementText((XMLStreamReader)reader);
                    if (JDBCMetaDataParser.isEmpty(value)) continue block23;
                    metaData.setTrueMapping(value);
                    continue block23;
                }
            }
            throw JDBCMetaDataParser.unexpectedElement((XMLStreamReader)reader);
        }
        return metaData;
    }

    private static JDBCFunctionMappingMetaData parseFuctionMapping(XMLStreamReader reader) throws XMLStreamException {
        JDBCFunctionMappingMetaData metaData = new JDBCFunctionMappingMetaData();
        block4: for (Element element : JDBCMetaDataParser.children(reader)) {
            switch (element) {
                case FUNCTION_NAME: {
                    metaData.setFunctionName(JDBCMetaDataParser.getElementText((XMLStreamReader)reader));
                    continue block4;
                }
                case FUNCTION_SQL: {
                    metaData.setFunctionSql(JDBCMetaDataParser.getElementText((XMLStreamReader)reader));
                    continue block4;
                }
            }
            throw JDBCMetaDataParser.unexpectedElement((XMLStreamReader)reader);
        }
        return metaData;
    }

    private static JDBCMappingMetaData parseMapping(XMLStreamReader reader) throws XMLStreamException {
        JDBCMappingMetaData metaData = new JDBCMappingMetaData();
        block7: for (Element element : JDBCMetaDataParser.children(reader)) {
            switch (element) {
                case JAVA_TYPE: {
                    metaData.setJavaType(JDBCMetaDataParser.getElementText((XMLStreamReader)reader));
                    continue block7;
                }
                case JDBC_TYPE: {
                    metaData.setJdbcType(JDBCMetaDataParser.getJdbcTypeFromName(JDBCMetaDataParser.getElementText((XMLStreamReader)reader)));
                    continue block7;
                }
                case SQL_TYPE: {
                    metaData.setSqlType(JDBCMetaDataParser.getElementText((XMLStreamReader)reader));
                    continue block7;
                }
                case PARAM_SETTER: {
                    metaData.setParamSetter(JDBCMetaDataParser.getElementText((XMLStreamReader)reader));
                    continue block7;
                }
                case RESULT_READER: {
                    metaData.setResultReader(JDBCMetaDataParser.getElementText((XMLStreamReader)reader));
                    continue block7;
                }
            }
            throw JDBCMetaDataParser.unexpectedElement((XMLStreamReader)reader);
        }
        return metaData;
    }

    private static ParsedReadAhead parseReadAhead(XMLStreamReader reader) throws XMLStreamException {
        ParsedReadAhead metaData = new ParsedReadAhead();
        ArrayList<JDBCLeftJoinMetaData> leftJoins = new ArrayList<JDBCLeftJoinMetaData>();
        block6: for (Element element : JDBCMetaDataParser.children(reader)) {
            switch (element) {
                case STRATEGY: {
                    metaData.strategy = JDBCMetaDataParser.getElementText((XMLStreamReader)reader);
                    continue block6;
                }
                case PAGE_SIZE: {
                    metaData.pageSize = Integer.parseInt(JDBCMetaDataParser.getElementText((XMLStreamReader)reader));
                    continue block6;
                }
                case EAGER_LOAD_GROUP: {
                    metaData.eagerLoadGroup = JDBCMetaDataParser.getElementText((XMLStreamReader)reader);
                    continue block6;
                }
                case LEFT_JOIN: {
                    leftJoins.add(JDBCMetaDataParser.parseLeftJoin(reader));
                    continue block6;
                }
            }
            throw JDBCMetaDataParser.unexpectedElement((XMLStreamReader)reader);
        }
        metaData.leftJoinList = leftJoins;
        return metaData;
    }

    private static JDBCLeftJoinMetaData parseLeftJoin(XMLStreamReader reader) throws XMLStreamException {
        JDBCLeftJoinMetaData metaData = new JDBCLeftJoinMetaData();
        ArrayList<JDBCLeftJoinMetaData> leftJoins = new ArrayList<JDBCLeftJoinMetaData>();
        int count = reader.getAttributeCount();
        block7: for (int i = 0; i < count; ++i) {
            Attribute attribute = Attribute.forName(reader.getAttributeLocalName(i));
            switch (attribute) {
                case CMR_FIELD: {
                    metaData.setCmrField(reader.getAttributeValue(i));
                    continue block7;
                }
                case EAGER_LOAD_GROUP: {
                    metaData.setEagerLoadGroup(reader.getAttributeValue(i));
                    continue block7;
                }
                default: {
                    throw JDBCMetaDataParser.unexpectedAttribute((XMLStreamReader)reader, (int)i);
                }
            }
        }
        block8: for (Element element : JDBCMetaDataParser.children(reader)) {
            switch (element) {
                case LEFT_JOIN: {
                    leftJoins.add(JDBCMetaDataParser.parseLeftJoin(reader));
                    continue block8;
                }
            }
            throw JDBCMetaDataParser.unexpectedElement((XMLStreamReader)reader);
        }
        metaData.setLeftJoins(leftJoins);
        return metaData;
    }

    private static ParsedCmpField parseUnknownPk(XMLStreamReader reader, ClassLoader classLoader) throws XMLStreamException {
        ParsedCmpField parsedCmpField = new ParsedCmpField();
        block13: for (Element element : JDBCMetaDataParser.children(reader)) {
            switch (element) {
                case UNKNOWN_KEY_CLASS: {
                    try {
                        parsedCmpField.unknownPk = classLoader.loadClass(JDBCMetaDataParser.getElementText((XMLStreamReader)reader));
                        continue block13;
                    }
                    catch (ClassNotFoundException e) {
                        throw new RuntimeException("Failed to load field type", e);
                    }
                }
                case FIELD_NAME: {
                    parsedCmpField.fieldName = JDBCMetaDataParser.getElementText((XMLStreamReader)reader);
                    continue block13;
                }
                case READ_ONLY: {
                    parsedCmpField.readOnly = Boolean.parseBoolean(JDBCMetaDataParser.getElementText((XMLStreamReader)reader));
                    continue block13;
                }
                case READ_TIMEOUT: {
                    parsedCmpField.readTimeOut = Integer.parseInt(JDBCMetaDataParser.getElementText((XMLStreamReader)reader));
                    continue block13;
                }
                case COLUMN_NAME: {
                    parsedCmpField.columnName = JDBCMetaDataParser.getElementText((XMLStreamReader)reader);
                    continue block13;
                }
                case JDBC_TYPE: {
                    parsedCmpField.jdbcType = JDBCMetaDataParser.getJdbcTypeFromName(JDBCMetaDataParser.getElementText((XMLStreamReader)reader));
                    continue block13;
                }
                case SQL_TYPE: {
                    parsedCmpField.sqlType = JDBCMetaDataParser.getElementText((XMLStreamReader)reader);
                    continue block13;
                }
                case AUTO_INCREMENT: {
                    parsedCmpField.autoIncrement = Boolean.parseBoolean(JDBCMetaDataParser.getElementText((XMLStreamReader)reader));
                    continue block13;
                }
                case KEY_GENERATOR_FACTORY: {
                    JDBCMetaDataParser.getElementText((XMLStreamReader)reader);
                    continue block13;
                }
            }
            throw JDBCMetaDataParser.unexpectedElement((XMLStreamReader)reader);
        }
        return parsedCmpField;
    }

    private static JDBCEntityCommandMetaData parseEntityCommand(XMLStreamReader reader, ClassLoader classLoader) throws XMLStreamException {
        JDBCEntityCommandMetaData metaData = new JDBCEntityCommandMetaData();
        int count = reader.getAttributeCount();
        block9: for (int i = 0; i < count; ++i) {
            Attribute attribute = Attribute.forName(reader.getAttributeLocalName(i));
            switch (attribute) {
                case NAME: {
                    metaData.setName(reader.getAttributeValue(i));
                    continue block9;
                }
                case CLASS: {
                    try {
                        metaData.setClass(classLoader.loadClass(reader.getAttributeValue(i)));
                        continue block9;
                    }
                    catch (ClassNotFoundException e) {
                        throw new RuntimeException("Failed to load entity command class", e);
                    }
                }
                default: {
                    throw JDBCMetaDataParser.unexpectedAttribute((XMLStreamReader)reader, (int)i);
                }
            }
        }
        block10: for (Element element : JDBCMetaDataParser.children(reader)) {
            switch (element) {
                case ATTRIBUTE: {
                    JDBCMetaDataParser.parseAttribute(reader, metaData);
                    continue block10;
                }
            }
            throw JDBCMetaDataParser.unexpectedElement((XMLStreamReader)reader);
        }
        return metaData;
    }

    private static void parseAttribute(XMLStreamReader reader, JDBCEntityCommandMetaData metaData) throws XMLStreamException {
        String name = null;
        int count = reader.getAttributeCount();
        block3: for (int i = 0; i < count; ++i) {
            Attribute attribute = Attribute.forName(reader.getAttributeLocalName(i));
            switch (attribute) {
                case NAME: {
                    name = reader.getAttributeValue(i);
                    continue block3;
                }
                default: {
                    throw JDBCMetaDataParser.unexpectedAttribute((XMLStreamReader)reader, (int)i);
                }
            }
        }
        String value = JDBCMetaDataParser.getElementText((XMLStreamReader)reader);
        if (name != null) {
            metaData.addAttribute(name, value);
        }
    }

    private static List<JDBCEntityCommandMetaData> parseEntityCommands(XMLStreamReader reader, ClassLoader classLoader) throws XMLStreamException {
        ArrayList<JDBCEntityCommandMetaData> commands = new ArrayList<JDBCEntityCommandMetaData>();
        block3: for (Element element : JDBCMetaDataParser.children(reader)) {
            switch (element) {
                case ENTITY_COMMAND: {
                    commands.add(JDBCMetaDataParser.parseEntityCommand(reader, classLoader));
                    continue block3;
                }
            }
            throw JDBCMetaDataParser.unexpectedElement((XMLStreamReader)reader);
        }
        return commands;
    }

    private static List<ParsedRelationship> parseRelationships(XMLStreamReader reader) throws XMLStreamException {
        ArrayList<ParsedRelationship> relationships = new ArrayList<ParsedRelationship>();
        block3: for (Element element : JDBCMetaDataParser.children(reader)) {
            switch (element) {
                case EJB_RELATION: {
                    relationships.add(JDBCMetaDataParser.parseRelationship(reader));
                    continue block3;
                }
            }
            throw JDBCMetaDataParser.unexpectedElement((XMLStreamReader)reader);
        }
        return relationships;
    }

    private static ParsedRelationship parseRelationship(XMLStreamReader reader) throws XMLStreamException {
        ParsedRelationship metaData = new ParsedRelationship();
        block19: for (Element element : JDBCMetaDataParser.children(reader)) {
            switch (element) {
                case EJB_RELATION_NAME: {
                    metaData.relationName = JDBCMetaDataParser.getElementText((XMLStreamReader)reader);
                    break;
                }
                case READ_ONLY: {
                    metaData.readOnly = Boolean.parseBoolean(JDBCMetaDataParser.getElementText((XMLStreamReader)reader));
                    break;
                }
                case READ_TIMEOUT: {
                    metaData.readTimeOut = Integer.parseInt(JDBCMetaDataParser.getElementText((XMLStreamReader)reader));
                    break;
                }
                case FOREIGN_KEY_MAPPING: {
                    metaData.mappingStyle = JDBCRelationMetaData.MappingStyle.FOREIGN_KEY;
                    JDBCMetaDataParser.getElementText((XMLStreamReader)reader);
                    break;
                }
                case RELATION_TABLE_MAPPING: {
                    metaData.mappingStyle = JDBCRelationMetaData.MappingStyle.TABLE;
                    block20: for (Element tableElement : JDBCMetaDataParser.children(reader)) {
                        switch (tableElement) {
                            case TABLE_NAME: {
                                metaData.tableName = JDBCMetaDataParser.getElementText((XMLStreamReader)reader);
                                break;
                            }
                            case DATASOURCE: {
                                metaData.dataSourceName = JDBCMetaDataParser.getElementText((XMLStreamReader)reader);
                                break;
                            }
                            case DATASOURCE_MAPPING: {
                                metaData.datasourceMapping = JDBCMetaDataParser.getElementText((XMLStreamReader)reader);
                                break;
                            }
                            case CREATE_TABLE: {
                                metaData.createTable = Boolean.parseBoolean(JDBCMetaDataParser.getElementText((XMLStreamReader)reader));
                                break;
                            }
                            case REMOVE_TABLE: {
                                metaData.removeTable = Boolean.parseBoolean(JDBCMetaDataParser.getElementText((XMLStreamReader)reader));
                                break;
                            }
                            case ALTER_TABLE: {
                                metaData.alterTable = Boolean.parseBoolean(JDBCMetaDataParser.getElementText((XMLStreamReader)reader));
                                break;
                            }
                            case POST_TABLE_CREATE: {
                                for (String cmd : JDBCMetaDataParser.parsePostTableCreate(reader)) {
                                    metaData.tablePostCreateCmd.add(cmd);
                                }
                                continue block20;
                            }
                            case ROW_LOCKING: {
                                metaData.rowLocking = Boolean.parseBoolean(JDBCMetaDataParser.getElementText((XMLStreamReader)reader));
                                break;
                            }
                            case PK_CONSTRAINT: {
                                metaData.primaryKeyConstraint = Boolean.parseBoolean(JDBCMetaDataParser.getElementText((XMLStreamReader)reader));
                                break;
                            }
                            default: {
                                throw JDBCMetaDataParser.unexpectedElement((XMLStreamReader)reader);
                            }
                        }
                    }
                    continue block19;
                }
                case EJB_RELATIONSHIP_ROLE: {
                    metaData.roles.add(JDBCMetaDataParser.parseEjbRelationshipRole(reader));
                    break;
                }
                default: {
                    throw JDBCMetaDataParser.unexpectedElement((XMLStreamReader)reader);
                }
            }
        }
        return metaData;
    }

    private static ParsedRelationshipRole parseEjbRelationshipRole(XMLStreamReader reader) throws XMLStreamException {
        ParsedRelationshipRole metaData = new ParsedRelationshipRole();
        block7: for (Element element : JDBCMetaDataParser.children(reader)) {
            switch (element) {
                case EJB_RELATIONSHIP_ROLE_NAME: {
                    metaData.relationshipRoleName = JDBCMetaDataParser.getElementText((XMLStreamReader)reader);
                    continue block7;
                }
                case FK_CONSTRAINT: {
                    metaData.foreignKeyConstraint = Boolean.parseBoolean(JDBCMetaDataParser.getElementText((XMLStreamReader)reader));
                    continue block7;
                }
                case READ_AHEAD: {
                    metaData.readAhead = JDBCMetaDataParser.parseReadAhead(reader);
                    continue block7;
                }
                case KEY_FIELDS: {
                    metaData.keyFields = JDBCMetaDataParser.parseKeyFields(reader);
                    continue block7;
                }
                case BATCH_CASCADE_DELETE: {
                    metaData.batchCascadeDelete = Boolean.parseBoolean(JDBCMetaDataParser.getElementText((XMLStreamReader)reader));
                    continue block7;
                }
            }
            throw JDBCMetaDataParser.unexpectedElement((XMLStreamReader)reader);
        }
        return metaData;
    }

    private static List<ParsedCmpField> parseKeyFields(XMLStreamReader reader) throws XMLStreamException {
        ArrayList<ParsedCmpField> parsedCmpFields = new ArrayList<ParsedCmpField>();
        block3: for (Element element : JDBCMetaDataParser.children(reader)) {
            switch (element) {
                case KEY_FIELD: {
                    parsedCmpFields.add(JDBCMetaDataParser.parseCmpField(reader));
                    continue block3;
                }
            }
            throw JDBCMetaDataParser.unexpectedElement((XMLStreamReader)reader);
        }
        return parsedCmpFields;
    }

    private static JDBCCMPFieldPropertyMetaData parseProperty(XMLStreamReader reader) throws XMLStreamException {
        JDBCCMPFieldPropertyMetaData metaData = new JDBCCMPFieldPropertyMetaData();
        block7: for (Element element : JDBCMetaDataParser.children(reader)) {
            switch (element) {
                case PROPERTY_NAME: {
                    metaData.setPropertyName(JDBCMetaDataParser.getElementText((XMLStreamReader)reader));
                    continue block7;
                }
                case COLUMN_NAME: {
                    metaData.setColumnName(JDBCMetaDataParser.getElementText((XMLStreamReader)reader));
                    continue block7;
                }
                case NOT_NULL: {
                    metaData.setNotNul(Boolean.parseBoolean(JDBCMetaDataParser.getElementText((XMLStreamReader)reader)));
                    continue block7;
                }
                case JDBC_TYPE: {
                    metaData.setJdbcType(JDBCMetaDataParser.getJdbcTypeFromName(JDBCMetaDataParser.getElementText((XMLStreamReader)reader)));
                    continue block7;
                }
                case SQL_TYPE: {
                    metaData.setSqlType(JDBCMetaDataParser.getElementText((XMLStreamReader)reader));
                    continue block7;
                }
            }
            throw JDBCMetaDataParser.unexpectedElement((XMLStreamReader)reader);
        }
        return metaData;
    }

    private static List<String> parsePostTableCreate(XMLStreamReader reader) throws XMLStreamException {
        ArrayList<String> statements = new ArrayList<String>();
        block3: for (Element element : JDBCMetaDataParser.children(reader)) {
            switch (element) {
                case SQL_STATEMENT: {
                    statements.add(JDBCMetaDataParser.getElementText((XMLStreamReader)reader));
                    continue block3;
                }
            }
            throw JDBCMetaDataParser.unexpectedElement((XMLStreamReader)reader);
        }
        return statements;
    }

    private static List<ParsedEntity> parseEnterpriseBeans(XMLStreamReader reader, ClassLoader classLoader) throws XMLStreamException {
        ArrayList<ParsedEntity> entities = new ArrayList<ParsedEntity>();
        block3: for (Element element : JDBCMetaDataParser.children(reader)) {
            switch (element) {
                case ENTITY: {
                    entities.add(JDBCMetaDataParser.parseEntity(reader, classLoader));
                    continue block3;
                }
            }
            throw JDBCMetaDataParser.unexpectedElement((XMLStreamReader)reader);
        }
        return entities;
    }

    private static ParsedEntity parseEntity(XMLStreamReader reader, ClassLoader classLoader) throws XMLStreamException {
        ParsedEntity metaData = new ParsedEntity();
        block32: for (Element element : JDBCMetaDataParser.children(reader)) {
            switch (element) {
                case EJB_NAME: {
                    metaData.entityName = JDBCMetaDataParser.getElementText((XMLStreamReader)reader);
                    break;
                }
                case DATASOURCE: {
                    metaData.dataSourceName = JDBCMetaDataParser.getElementText((XMLStreamReader)reader);
                    break;
                }
                case DATASOURCE_MAPPING: {
                    metaData.dataSourceMappingName = JDBCMetaDataParser.getElementText((XMLStreamReader)reader);
                    break;
                }
                case CREATE_TABLE: {
                    metaData.createTable = Boolean.parseBoolean(JDBCMetaDataParser.getElementText((XMLStreamReader)reader));
                    break;
                }
                case REMOVE_TABLE: {
                    metaData.removeTable = Boolean.parseBoolean(JDBCMetaDataParser.getElementText((XMLStreamReader)reader));
                    break;
                }
                case POST_TABLE_CREATE: {
                    for (String cmd : JDBCMetaDataParser.parsePostTableCreate(reader)) {
                        metaData.tablePostCreateCmd.add(cmd);
                    }
                    continue block32;
                }
                case READ_ONLY: {
                    metaData.readOnly = Boolean.parseBoolean(JDBCMetaDataParser.getElementText((XMLStreamReader)reader));
                    break;
                }
                case READ_TIMEOUT: {
                    metaData.readTimeOut = Integer.parseInt(JDBCMetaDataParser.getElementText((XMLStreamReader)reader));
                    break;
                }
                case ROW_LOCKING: {
                    metaData.rowLocking = Boolean.parseBoolean(JDBCMetaDataParser.getElementText((XMLStreamReader)reader));
                    break;
                }
                case PK_CONSTRAINT: {
                    metaData.primaryKeyConstraint = Boolean.parseBoolean(JDBCMetaDataParser.getElementText((XMLStreamReader)reader));
                    break;
                }
                case FK_CONSTRAINT: {
                    metaData.preferredMappingStyle = JDBCMetaDataParser.getElementText((XMLStreamReader)reader);
                    break;
                }
                case READ_AHEAD: {
                    metaData.readAhead = JDBCMetaDataParser.parseReadAhead(reader);
                    break;
                }
                case LIST_CACHE_MAX: {
                    metaData.listCacheMax = Integer.parseInt(JDBCMetaDataParser.getElementText((XMLStreamReader)reader));
                    break;
                }
                case CLEAN_READ_AHEAD: {
                    metaData.cleanReadAheadOnLoad = Boolean.parseBoolean(JDBCMetaDataParser.getElementText((XMLStreamReader)reader));
                    break;
                }
                case FETCH_SIZE: {
                    metaData.fetchSize = Integer.parseInt(JDBCMetaDataParser.getElementText((XMLStreamReader)reader));
                    break;
                }
                case TABLE_NAME: {
                    metaData.tableName = JDBCMetaDataParser.getElementText((XMLStreamReader)reader);
                    break;
                }
                case CMP_FIELD: {
                    metaData.cmpFields.add(JDBCMetaDataParser.parseCmpField(reader));
                    break;
                }
                case LOAD_GROUPS: {
                    metaData.loadGroups.putAll(JDBCMetaDataParser.parseLoadGroups(reader));
                    break;
                }
                case EAGER_LOAD_GROUP: {
                    metaData.eagerLoadGroup = JDBCMetaDataParser.getElementText((XMLStreamReader)reader);
                    break;
                }
                case LAZY_LOAD_GROUPS: {
                    metaData.lazyLoadGroups.addAll(JDBCMetaDataParser.parseLazyLoadGroups(reader));
                    break;
                }
                case QUERY: {
                    metaData.queries.add(JDBCMetaDataParser.parseQuery(reader, classLoader));
                    break;
                }
                case UNKNOWN_PK: {
                    metaData.upkField = JDBCMetaDataParser.parseUnknownPk(reader, classLoader);
                    break;
                }
                case ENTITY_COMMAND: {
                    metaData.entityCommand = JDBCMetaDataParser.parseEntityCommand(reader, classLoader);
                    break;
                }
                case OPTIMISTIC_LOCKING: {
                    metaData.optimisticLocking = JDBCMetaDataParser.parseOptimisticLocking(reader, classLoader);
                    break;
                }
                case AUDIT: {
                    metaData.audit = JDBCMetaDataParser.parseAudit(reader);
                    break;
                }
                case PREFERED_RELATION: {
                    JDBCMetaDataParser.getElementText((XMLStreamReader)reader);
                    break;
                }
                case QL_COMPILER: {
                    String qlCompiler = JDBCMetaDataParser.getElementText((XMLStreamReader)reader);
                    try {
                        metaData.qlCompiler = classLoader.loadClass(qlCompiler);
                        break;
                    }
                    catch (ClassNotFoundException e) {
                        throw new RuntimeException("Failed to load compiler implementation: " + qlCompiler, e);
                    }
                }
                case THROW_RUNTIME_EX: {
                    metaData.throwRuntimeExceptions = Boolean.valueOf(JDBCMetaDataParser.getElementText((XMLStreamReader)reader));
                    break;
                }
                default: {
                    throw JDBCMetaDataParser.unexpectedElement((XMLStreamReader)reader);
                }
            }
        }
        return metaData;
    }

    private static List<String> parseLazyLoadGroups(XMLStreamReader reader) throws XMLStreamException {
        ArrayList<String> groups = new ArrayList<String>();
        block3: for (Element element : JDBCMetaDataParser.children(reader)) {
            switch (element) {
                case LOAD_GROUP_NAME: {
                    groups.add(JDBCMetaDataParser.getElementText((XMLStreamReader)reader));
                    continue block3;
                }
            }
            throw JDBCMetaDataParser.unexpectedElement((XMLStreamReader)reader);
        }
        return groups;
    }

    private static ParsedQuery parseQuery(XMLStreamReader reader, ClassLoader classLoader) throws XMLStreamException {
        ParsedQuery metaData = new ParsedQuery();
        block34: for (Element element : JDBCMetaDataParser.children(reader)) {
            switch (element) {
                case QUERY_METHOD: {
                    block35: for (Element queryMethodChild : JDBCMetaDataParser.children(reader)) {
                        switch (queryMethodChild) {
                            case METHOD_NAME: {
                                metaData.methodName = JDBCMetaDataParser.getElementText((XMLStreamReader)reader);
                                break;
                            }
                            case METHOD_PARAMS: {
                                block36: for (Element paramChild : JDBCMetaDataParser.children(reader)) {
                                    switch (paramChild) {
                                        case METHOD_PARAM: {
                                            metaData.methodParams.add(JDBCMetaDataParser.getElementText((XMLStreamReader)reader));
                                            continue block36;
                                        }
                                    }
                                    throw JDBCMetaDataParser.unexpectedElement((XMLStreamReader)reader);
                                }
                                continue block35;
                            }
                            default: {
                                throw JDBCMetaDataParser.unexpectedElement((XMLStreamReader)reader);
                            }
                        }
                    }
                    continue block34;
                }
                case JBOSS_QL: {
                    metaData.type = JDBCQueryMetaDataFactory.Type.JBOSS_QL;
                    metaData.query = JDBCMetaDataParser.getElementText((XMLStreamReader)reader);
                    break;
                }
                case DYNAMIC_QL: {
                    metaData.type = JDBCQueryMetaDataFactory.Type.DYNAMIC_QL;
                    JDBCMetaDataParser.getElementText((XMLStreamReader)reader);
                    break;
                }
                case DECLARED_QL: {
                    metaData.type = JDBCQueryMetaDataFactory.Type.DECLARED_QL;
                    block37: for (Element declaredChild : JDBCMetaDataParser.children(reader)) {
                        switch (declaredChild) {
                            case FROM: {
                                metaData.declaredParts.put("from", JDBCMetaDataParser.getElementText((XMLStreamReader)reader));
                                break;
                            }
                            case WHERE: {
                                metaData.declaredParts.put("where", JDBCMetaDataParser.getElementText((XMLStreamReader)reader));
                                break;
                            }
                            case ORDER: {
                                metaData.declaredParts.put("order", JDBCMetaDataParser.getElementText((XMLStreamReader)reader));
                                break;
                            }
                            case OTHER: {
                                metaData.declaredParts.put("other", JDBCMetaDataParser.getElementText((XMLStreamReader)reader));
                                break;
                            }
                            case SELECT: {
                                block38: for (Element selectChild : JDBCMetaDataParser.children(reader)) {
                                    switch (selectChild) {
                                        case DISTINCT: {
                                            metaData.declaredParts.put("distinct", JDBCMetaDataParser.getElementText((XMLStreamReader)reader));
                                            continue block38;
                                        }
                                        case EJB_NAME: {
                                            metaData.declaredParts.put("ejb-name", JDBCMetaDataParser.getElementText((XMLStreamReader)reader));
                                            continue block38;
                                        }
                                        case FIELD_NAME: {
                                            metaData.declaredParts.put("field-name", JDBCMetaDataParser.getElementText((XMLStreamReader)reader));
                                            continue block38;
                                        }
                                        case ALIAS: {
                                            metaData.declaredParts.put("alias", JDBCMetaDataParser.getElementText((XMLStreamReader)reader));
                                            continue block38;
                                        }
                                        case ADDITIONAL_COLUMNS: {
                                            metaData.declaredParts.put("additional-columns", JDBCMetaDataParser.getElementText((XMLStreamReader)reader));
                                            continue block38;
                                        }
                                    }
                                    throw JDBCMetaDataParser.unexpectedElement((XMLStreamReader)reader);
                                }
                                continue block37;
                            }
                            default: {
                                throw JDBCMetaDataParser.unexpectedElement((XMLStreamReader)reader);
                            }
                        }
                    }
                    continue block34;
                }
                case RAW_SQL: {
                    metaData.type = JDBCQueryMetaDataFactory.Type.RAW_SQL;
                    metaData.query = JDBCMetaDataParser.getElementText((XMLStreamReader)reader);
                    break;
                }
                case READ_AHEAD: {
                    metaData.readAheadMetaData = JDBCMetaDataParser.parseReadAhead(reader);
                    break;
                }
                case QL_COMPILER: {
                    String qlCompiler = JDBCMetaDataParser.getElementText((XMLStreamReader)reader);
                    try {
                        metaData.qlCompiler = classLoader.loadClass(qlCompiler);
                        break;
                    }
                    catch (ClassNotFoundException e) {
                        throw new RuntimeException("Failed to load compiler implementation: " + qlCompiler, e);
                    }
                }
                case LAZY_RESULTSET_LOADING: {
                    metaData.lazyResultsetLoading = Boolean.parseBoolean(JDBCMetaDataParser.getElementText((XMLStreamReader)reader));
                    break;
                }
                case DESCRIPTION: {
                    JDBCMetaDataParser.getElementText((XMLStreamReader)reader);
                    break;
                }
                default: {
                    throw JDBCMetaDataParser.unexpectedElement((XMLStreamReader)reader);
                }
            }
        }
        return metaData;
    }

    private static ParsedAudit parseAudit(XMLStreamReader reader) throws XMLStreamException {
        ParsedAudit metaData = new ParsedAudit();
        block6: for (Element element : JDBCMetaDataParser.children(reader)) {
            switch (element) {
                case CREATED_BY: {
                    metaData.createdBy = JDBCMetaDataParser.parseAuditField(reader, "audit_created_by");
                    continue block6;
                }
                case CREATED_TIME: {
                    metaData.createdTime = JDBCMetaDataParser.parseAuditField(reader, "audit_created_time");
                    continue block6;
                }
                case UPDATED_BY: {
                    metaData.updatedBy = JDBCMetaDataParser.parseAuditField(reader, "audit_updated_by");
                    continue block6;
                }
                case UPDATED_TIME: {
                    metaData.updatedTime = JDBCMetaDataParser.parseAuditField(reader, "audit_updated_time");
                    continue block6;
                }
            }
            throw JDBCMetaDataParser.unexpectedElement((XMLStreamReader)reader);
        }
        return metaData;
    }

    private static ParsedCmpField parseAuditField(XMLStreamReader reader, String fieldName) throws XMLStreamException {
        ParsedCmpField field = JDBCMetaDataParser.parseCmpField(reader);
        if (field.fieldName == null) {
            field.fieldName = fieldName;
        }
        if (field.columnName == null) {
            field.columnName = fieldName;
        }
        return field;
    }

    private static ParsedOptimisticLocking parseOptimisticLocking(XMLStreamReader reader, ClassLoader classLoader) throws XMLStreamException {
        ParsedOptimisticLocking metaData = new ParsedOptimisticLocking();
        ParsedCmpField lockingField = null;
        block15: for (Element element : JDBCMetaDataParser.children(reader)) {
            switch (element) {
                case GROUP_NAME: {
                    metaData.lockingStrategy = JDBCOptimisticLockingMetaData.LockingStrategy.FIELD_GROUP_STRATEGY;
                    metaData.groupName = JDBCMetaDataParser.getElementText((XMLStreamReader)reader);
                    continue block15;
                }
                case MODIFIED_STRATEGY: {
                    metaData.lockingStrategy = JDBCOptimisticLockingMetaData.LockingStrategy.MODIFIED_STRATEGY;
                    JDBCMetaDataParser.getElementText((XMLStreamReader)reader);
                    continue block15;
                }
                case READ_STRATEGY: {
                    metaData.lockingStrategy = JDBCOptimisticLockingMetaData.LockingStrategy.READ_STRATEGY;
                    JDBCMetaDataParser.getElementText((XMLStreamReader)reader);
                    continue block15;
                }
                case VERSION_COLUMN: {
                    metaData.lockingStrategy = JDBCOptimisticLockingMetaData.LockingStrategy.VERSION_COLUMN_STRATEGY;
                    JDBCMetaDataParser.getElementText((XMLStreamReader)reader);
                    continue block15;
                }
                case TIMESTAMP_COLUMN: {
                    metaData.lockingStrategy = JDBCOptimisticLockingMetaData.LockingStrategy.TIMESTAMP_COLUMN_STRATEGY;
                    JDBCMetaDataParser.getElementText((XMLStreamReader)reader);
                    continue block15;
                }
                case KEY_GENERATOR_FACTORY: {
                    metaData.lockingStrategy = JDBCOptimisticLockingMetaData.LockingStrategy.KEYGENERATOR_COLUMN_STRATEGY;
                    metaData.keyGeneratorFactory = JDBCMetaDataParser.getElementText((XMLStreamReader)reader);
                    continue block15;
                }
                case FIELD_TYPE: {
                    if (lockingField == null) {
                        lockingField = new ParsedCmpField();
                    }
                    try {
                        lockingField.fieldType = classLoader.loadClass(JDBCMetaDataParser.getElementText((XMLStreamReader)reader));
                        continue block15;
                    }
                    catch (ClassNotFoundException e) {
                        throw new RuntimeException("Failed to load field type", e);
                    }
                }
                case FIELD_NAME: {
                    if (lockingField == null) {
                        lockingField = new ParsedCmpField();
                    }
                    lockingField.fieldName = JDBCMetaDataParser.getElementText((XMLStreamReader)reader);
                    continue block15;
                }
                case COLUMN_NAME: {
                    if (lockingField == null) {
                        lockingField = new ParsedCmpField();
                    }
                    lockingField.columnName = JDBCMetaDataParser.getElementText((XMLStreamReader)reader);
                    continue block15;
                }
                case JDBC_TYPE: {
                    if (lockingField == null) {
                        lockingField = new ParsedCmpField();
                    }
                    lockingField.jdbcType = JDBCMetaDataParser.getJdbcTypeFromName(JDBCMetaDataParser.getElementText((XMLStreamReader)reader));
                    continue block15;
                }
                case SQL_TYPE: {
                    if (lockingField == null) {
                        lockingField = new ParsedCmpField();
                    }
                    lockingField.sqlType = JDBCMetaDataParser.getElementText((XMLStreamReader)reader);
                    continue block15;
                }
            }
            throw JDBCMetaDataParser.unexpectedElement((XMLStreamReader)reader);
        }
        metaData.lockingField = lockingField;
        return metaData;
    }

    private static Map<String, List<String>> parseLoadGroups(XMLStreamReader reader) throws XMLStreamException {
        HashMap<String, List<String>> groups = new HashMap<String, List<String>>();
        block3: for (Element element : JDBCMetaDataParser.children(reader)) {
            switch (element) {
                case LOAD_GROUP: {
                    JDBCMetaDataParser.parseLoadGroup(reader, groups);
                    continue block3;
                }
            }
            throw JDBCMetaDataParser.unexpectedElement((XMLStreamReader)reader);
        }
        return groups;
    }

    private static void parseLoadGroup(XMLStreamReader reader, Map<String, List<String>> groups) throws XMLStreamException {
        String groupName = null;
        ArrayList<String> fields = new ArrayList<String>();
        block4: for (Element element : JDBCMetaDataParser.children(reader)) {
            switch (element) {
                case LOAD_GROUP_NAME: {
                    groupName = JDBCMetaDataParser.getElementText((XMLStreamReader)reader);
                    continue block4;
                }
                case FIELD_NAME: {
                    fields.add(JDBCMetaDataParser.getElementText((XMLStreamReader)reader));
                    continue block4;
                }
            }
            throw JDBCMetaDataParser.unexpectedElement((XMLStreamReader)reader);
        }
        if (groupName != null) {
            groups.put(groupName, fields);
        }
    }

    private static ParsedCmpField parseCmpField(XMLStreamReader reader) throws XMLStreamException {
        ParsedCmpField metaData = new ParsedCmpField();
        block14: for (Element element : JDBCMetaDataParser.children(reader)) {
            switch (element) {
                case COLUMN_NAME: {
                    metaData.columnName = JDBCMetaDataParser.getElementText((XMLStreamReader)reader);
                    continue block14;
                }
                case FIELD_NAME: {
                    metaData.fieldName = JDBCMetaDataParser.getElementText((XMLStreamReader)reader);
                    continue block14;
                }
                case READ_ONLY: {
                    metaData.readOnly = Boolean.parseBoolean(JDBCMetaDataParser.getElementText((XMLStreamReader)reader));
                    continue block14;
                }
                case READ_TIMEOUT: {
                    metaData.readTimeOut = Integer.parseInt(JDBCMetaDataParser.getElementText((XMLStreamReader)reader));
                    continue block14;
                }
                case NOT_NULL: {
                    metaData.notNull = Boolean.parseBoolean(JDBCMetaDataParser.getElementText((XMLStreamReader)reader));
                    continue block14;
                }
                case JDBC_TYPE: {
                    metaData.jdbcType = JDBCMetaDataParser.getJdbcTypeFromName(JDBCMetaDataParser.getElementText((XMLStreamReader)reader));
                    continue block14;
                }
                case SQL_TYPE: {
                    metaData.sqlType = JDBCMetaDataParser.getElementText((XMLStreamReader)reader);
                    continue block14;
                }
                case PROPERTY: {
                    metaData.propertyOverrides.add(JDBCMetaDataParser.parseProperty(reader));
                    continue block14;
                }
                case AUTO_INCREMENT: {
                    JDBCMetaDataParser.getElementText((XMLStreamReader)reader);
                    metaData.autoIncrement = true;
                    continue block14;
                }
                case DB_INDEX: {
                    JDBCMetaDataParser.getElementText((XMLStreamReader)reader);
                    metaData.genIndex = true;
                    continue block14;
                }
                case CHECK_DIRTY_AFTER_GET: {
                    metaData.checkDirtyAfterGet = Boolean.parseBoolean(JDBCMetaDataParser.getElementText((XMLStreamReader)reader));
                    continue block14;
                }
                case STATE_FACTORY: {
                    metaData.stateFactory = JDBCMetaDataParser.getElementText((XMLStreamReader)reader);
                    continue block14;
                }
            }
            throw JDBCMetaDataParser.unexpectedElement((XMLStreamReader)reader);
        }
        return metaData;
    }

    private static List<JDBCValueClassMetaData> parseDependentValueClasses(XMLStreamReader reader, ClassLoader classLoader) throws XMLStreamException {
        ArrayList<JDBCValueClassMetaData> valueClasses = new ArrayList<JDBCValueClassMetaData>();
        block3: for (Element element : JDBCMetaDataParser.children(reader)) {
            switch (element) {
                case DEPENDENT_VALUE_CLASS: {
                    valueClasses.add(JDBCMetaDataParser.parseValueClass(reader, classLoader));
                    continue block3;
                }
            }
            throw JDBCMetaDataParser.unexpectedElement((XMLStreamReader)reader);
        }
        return valueClasses;
    }

    private static JDBCValueClassMetaData parseValueClass(XMLStreamReader reader, ClassLoader classLoader) throws XMLStreamException {
        HashMap<String, JDBCValuePropertyMetaData> properties = new HashMap<String, JDBCValuePropertyMetaData>();
        JDBCValueClassMetaData valueClass = new JDBCValueClassMetaData();
        block7: for (Element element : JDBCMetaDataParser.children(reader)) {
            switch (element) {
                case CLASS: {
                    try {
                        valueClass.setClass(classLoader.loadClass(JDBCMetaDataParser.getElementText((XMLStreamReader)reader)));
                        continue block7;
                    }
                    catch (ClassNotFoundException e) {
                        throw new RuntimeException("Failed to load value class", e);
                    }
                }
                case PROPERTY: {
                    JDBCMetaDataParser.parseValueProperty(reader, properties);
                    continue block7;
                }
                case DESCRIPTION: {
                    JDBCMetaDataParser.getElementText((XMLStreamReader)reader);
                    continue block7;
                }
            }
            throw JDBCMetaDataParser.unexpectedElement((XMLStreamReader)reader);
        }
        for (String propertyName : properties.keySet()) {
            JDBCValuePropertyMetaData propertyMetaData = (JDBCValuePropertyMetaData)properties.get(propertyName);
            propertyMetaData.setPropertyName(propertyName, valueClass.getJavaType());
            valueClass.addProperty(propertyMetaData);
        }
        return valueClass;
    }

    private static void parseValueProperty(XMLStreamReader reader, Map<String, JDBCValuePropertyMetaData> properties) throws XMLStreamException {
        String propertyName = null;
        JDBCValuePropertyMetaData metaData = new JDBCValuePropertyMetaData();
        block7: for (Element element : JDBCMetaDataParser.children(reader)) {
            switch (element) {
                case PROPERTY_NAME: {
                    propertyName = JDBCMetaDataParser.getElementText((XMLStreamReader)reader);
                    continue block7;
                }
                case COLUMN_NAME: {
                    metaData.setColumnName(JDBCMetaDataParser.getElementText((XMLStreamReader)reader));
                    continue block7;
                }
                case NOT_NULL: {
                    metaData.setNotNul(Boolean.parseBoolean(JDBCMetaDataParser.getElementText((XMLStreamReader)reader)));
                    continue block7;
                }
                case JDBC_TYPE: {
                    metaData.setJdbcType(JDBCMetaDataParser.getJdbcTypeFromName(JDBCMetaDataParser.getElementText((XMLStreamReader)reader)));
                    continue block7;
                }
                case SQL_TYPE: {
                    metaData.setSqlType(JDBCMetaDataParser.getElementText((XMLStreamReader)reader));
                    continue block7;
                }
            }
            throw JDBCMetaDataParser.unexpectedElement((XMLStreamReader)reader);
        }
        properties.put(propertyName, metaData);
    }

    private static List<JDBCUserTypeMappingMetaData> parseUserTypeMappings(XMLStreamReader reader) throws XMLStreamException {
        ArrayList<JDBCUserTypeMappingMetaData> userTypeMappings = new ArrayList<JDBCUserTypeMappingMetaData>();
        block3: for (Element element : JDBCMetaDataParser.children(reader)) {
            switch (element) {
                case USER_TYPE_MAPPING: {
                    userTypeMappings.add(JDBCMetaDataParser.parseUserTypeMapping(reader));
                    continue block3;
                }
            }
            throw JDBCMetaDataParser.unexpectedElement((XMLStreamReader)reader);
        }
        return userTypeMappings;
    }

    private static JDBCUserTypeMappingMetaData parseUserTypeMapping(XMLStreamReader reader) throws XMLStreamException {
        JDBCUserTypeMappingMetaData metaData = new JDBCUserTypeMappingMetaData();
        block7: for (Element element : JDBCMetaDataParser.children(reader)) {
            switch (element) {
                case JAVA_TYPE: {
                    metaData.setJavaType(JDBCMetaDataParser.getElementText((XMLStreamReader)reader));
                    continue block7;
                }
                case MAPPED_TYPE: {
                    metaData.setMappedType(JDBCMetaDataParser.getElementText((XMLStreamReader)reader));
                    continue block7;
                }
                case MAPPER: {
                    metaData.setMapper(JDBCMetaDataParser.getElementText((XMLStreamReader)reader));
                    continue block7;
                }
                case CHECK_DIRTY_AFTER_GET: {
                    metaData.setCheckDirtyAfterGet(Boolean.parseBoolean(JDBCMetaDataParser.getElementText((XMLStreamReader)reader)));
                    continue block7;
                }
                case STATE_FACTORY: {
                    metaData.setStateFactory(JDBCMetaDataParser.getElementText((XMLStreamReader)reader));
                    continue block7;
                }
            }
            throw JDBCMetaDataParser.unexpectedElement((XMLStreamReader)reader);
        }
        return metaData;
    }

    private static void parseReservedWords(XMLStreamReader reader) throws XMLStreamException {
        block3: for (Element element : JDBCMetaDataParser.children(reader)) {
            switch (element) {
                case WORD: {
                    SQLUtil.addToRwords(JDBCMetaDataParser.getElementText((XMLStreamReader)reader));
                    continue block3;
                }
            }
            throw JDBCMetaDataParser.unexpectedElement((XMLStreamReader)reader);
        }
    }

    private static void moveToStart(XMLStreamReader reader) throws XMLStreamException {
        reader.require(7, null, null);
        while (reader.hasNext() && reader.next() != 1) {
        }
    }

    private static boolean isEmpty(String value) {
        return value == null || value.trim().equals("");
    }

    public static int getJdbcTypeFromName(String name) {
        if (name == null) {
            throw new IllegalArgumentException("jdbc-type cannot be null");
        }
        try {
            return (Integer)Types.class.getField(name).get(null);
        }
        catch (Exception e) {
            return 1111;
        }
    }

    private static Iterable<Element> children(final XMLStreamReader reader) throws XMLStreamException {
        return new Iterable<Element>(){

            @Override
            public Iterator<Element> iterator() {
                return new Iterator<Element>(){

                    @Override
                    public boolean hasNext() {
                        try {
                            return reader.hasNext() && reader.nextTag() != 2;
                        }
                        catch (XMLStreamException e) {
                            throw new IllegalStateException("Unable to get next element: ", e);
                        }
                    }

                    @Override
                    public Element next() {
                        return Element.forName(reader.getLocalName());
                    }

                    @Override
                    public void remove() {
                        throw new UnsupportedOperationException("Remove not supported");
                    }
                };
            }
        };
    }
}

