/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.cmp.processors;

import javax.sql.DataSource;
import javax.transaction.TransactionManager;
import org.jboss.as.cmp.CmpConfig;
import org.jboss.as.cmp.TransactionEntityMap;
import org.jboss.as.cmp.component.CmpEntityBeanComponent;
import org.jboss.as.cmp.component.CmpEntityBeanComponentCreateService;
import org.jboss.as.cmp.component.CmpEntityBeanComponentDescription;
import org.jboss.as.cmp.ejbql.Catalog;
import org.jboss.as.cmp.jdbc.JDBCEntityPersistenceStore;
import org.jboss.as.cmp.jdbc.JDBCStoreManager;
import org.jboss.as.cmp.jdbc.JdbcStoreManagerForeignKeysService;
import org.jboss.as.cmp.jdbc.JdbcStoreManagerInitService;
import org.jboss.as.cmp.jdbc.JdbcStoreManagerRelationshipsService;
import org.jboss.as.cmp.jdbc.JdbcStoreManagerStartService;
import org.jboss.as.cmp.jdbc.metadata.JDBCEntityMetaData;
import org.jboss.as.cmp.jdbc.metadata.JDBCRelationshipRoleMetaData;
import org.jboss.as.connector.subsystems.datasources.AbstractDataSourceService;
import org.jboss.as.ee.component.Attachments;
import org.jboss.as.ee.component.Component;
import org.jboss.as.ee.component.ComponentConfiguration;
import org.jboss.as.ee.component.ComponentConfigurator;
import org.jboss.as.ee.component.ComponentDescription;
import org.jboss.as.ee.component.ComponentStartService;
import org.jboss.as.ee.component.DependencyConfigurator;
import org.jboss.as.ee.component.EEModuleDescription;
import org.jboss.as.server.deployment.DeploymentPhaseContext;
import org.jboss.as.server.deployment.DeploymentUnit;
import org.jboss.as.server.deployment.DeploymentUnitProcessingException;
import org.jboss.as.server.deployment.DeploymentUnitProcessor;
import org.jboss.as.txn.service.TxnServices;
import org.jboss.msc.inject.Injector;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.ServiceTarget;
import org.jboss.msc.value.InjectedValue;
import org.jboss.msc.value.Value;

public class CmpStoreManagerProcessor
implements DeploymentUnitProcessor {
    public void deploy(DeploymentPhaseContext phaseContext) throws DeploymentUnitProcessingException {
        DeploymentUnit deploymentUnit = phaseContext.getDeploymentUnit();
        ServiceTarget serviceTarget = phaseContext.getServiceTarget();
        EEModuleDescription moduleDescription = (EEModuleDescription)deploymentUnit.getAttachment(Attachments.EE_MODULE_DESCRIPTION);
        final Catalog catalog = new Catalog();
        TransactionEntityMap entityMap = new TransactionEntityMap();
        final ServiceName entityMapServiceName = deploymentUnit.getServiceName().append(new String[]{"cmp", "entity-map"});
        serviceTarget.addService(entityMapServiceName, (Service)entityMap).addDependency(TxnServices.JBOSS_TXN_TRANSACTION_MANAGER, TransactionManager.class, entityMap.getTransactionManagerInjector()).install();
        final ServiceName relationsBarrierName = deploymentUnit.getServiceName().append(new String[]{"jdbc", "store-manager", "relations-barrier"});
        ServiceBuilder relationsBarrierBuilder = serviceTarget.addService(relationsBarrierName, Service.NULL);
        final ServiceName startBarrierName = deploymentUnit.getServiceName().append(new String[]{"jdbc", "store-manager", "start-barrier"});
        ServiceBuilder startBarrierBuilder = serviceTarget.addService(startBarrierName, Service.NULL);
        final ServiceName fkBarrierName = deploymentUnit.getServiceName().append(new String[]{"jdbc", "store-manager", "fk-barrier"});
        ServiceBuilder fkBarrierBuilder = serviceTarget.addService(fkBarrierName, Service.NULL);
        for (ComponentDescription component : moduleDescription.getComponentDescriptions()) {
            if (!(component instanceof CmpEntityBeanComponentDescription)) continue;
            final ServiceName serviceNameBase = component.getServiceName().append(new String[]{"jdbc", "store-manager"});
            final ServiceName initName = serviceNameBase.append(new String[]{"INIT"});
            final ServiceName relationsName = serviceNameBase.append(new String[]{"RELATIONS"});
            final ServiceName startName = serviceNameBase.append(new String[]{"START"});
            relationsBarrierBuilder.addDependency(initName);
            startBarrierBuilder.addDependency(relationsName);
            fkBarrierBuilder.addDependency(startName);
            component.getConfigurators().add(new ComponentConfigurator(){

                public void configure(DeploymentPhaseContext context, ComponentDescription description, ComponentConfiguration configuration) throws DeploymentUnitProcessingException {
                    CmpEntityBeanComponentDescription componentDescription = (CmpEntityBeanComponentDescription)description;
                    JDBCEntityMetaData entityMetaData = componentDescription.getEntityMetaData();
                    JDBCStoreManager storeManager = new JDBCStoreManager(context.getDeploymentUnit(), entityMetaData, new CmpConfig(), catalog);
                    JdbcStoreManagerInitService initService = new JdbcStoreManagerInitService(storeManager);
                    ServiceBuilder initBuilder = context.getServiceTarget().addService(initName, (Service)initService);
                    CmpStoreManagerProcessor.this.addDataSourceDependency(initBuilder, storeManager, entityMetaData.getDataSourceName());
                    for (JDBCRelationshipRoleMetaData roleMetaData : entityMetaData.getRelationshipRoles()) {
                        String dsName = roleMetaData.getRelationMetaData().getDataSourceName();
                        if (dsName == null) continue;
                        CmpStoreManagerProcessor.this.addDataSourceDependency(initBuilder, storeManager, dsName);
                    }
                    initBuilder.addDependency(description.getCreateServiceName(), CmpEntityBeanComponent.class, storeManager.getComponentInjector());
                    initBuilder.install();
                    JdbcStoreManagerRelationshipsService resolveRelationshipsService = new JdbcStoreManagerRelationshipsService(storeManager);
                    context.getServiceTarget().addService(relationsName, (Service)resolveRelationshipsService).addDependency(relationsBarrierName).install();
                    JdbcStoreManagerStartService startService = new JdbcStoreManagerStartService(storeManager);
                    context.getServiceTarget().addService(startName, (Service)startService).addDependency(startBarrierName).install();
                    JdbcStoreManagerForeignKeysService fkService = new JdbcStoreManagerForeignKeysService(storeManager);
                    final ServiceName fkName = serviceNameBase.append(new String[]{"FOREIGN_KEYS"});
                    context.getServiceTarget().addService(fkName, (Service)fkService).addDependency(fkBarrierName).install();
                    final InjectedValue persistenceStoreInjector = new InjectedValue();
                    configuration.getCreateDependencies().add(new DependencyConfigurator<Service<Component>>(){

                        public void configureDependency(ServiceBuilder<?> serviceBuilder, Service<Component> service) throws DeploymentUnitProcessingException {
                            CmpEntityBeanComponentCreateService createService = (CmpEntityBeanComponentCreateService)service;
                            createService.setStoreManagerValue((Value<JDBCEntityPersistenceStore>)persistenceStoreInjector);
                            serviceBuilder.addDependency(entityMapServiceName, TransactionEntityMap.class, createService.getTransactionEntityMapInjector());
                        }
                    });
                    configuration.getStartDependencies().add(new DependencyConfigurator<ComponentStartService>(){

                        public void configureDependency(ServiceBuilder<?> serviceBuilder, ComponentStartService service) throws DeploymentUnitProcessingException {
                            serviceBuilder.addDependency(initName, JDBCEntityPersistenceStore.class, (Injector)persistenceStoreInjector);
                            serviceBuilder.addDependency(fkName);
                        }
                    });
                }
            });
        }
        relationsBarrierBuilder.install();
        startBarrierBuilder.install();
        fkBarrierBuilder.install();
    }

    private void addDataSourceDependency(ServiceBuilder<?> builder, JDBCStoreManager storeManager, String dataSourceName) {
        builder.addDependency(AbstractDataSourceService.SERVICE_NAME_BASE.append(new String[]{dataSourceName}), DataSource.class, storeManager.getDataSourceInjector(dataSourceName));
    }

    public void undeploy(DeploymentUnit context) {
    }
}

