/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.cmp.jdbc.bridge;

import java.lang.reflect.Method;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import javax.ejb.EJBException;
import javax.ejb.FinderException;
import javax.ejb.ObjectNotFoundException;
import javax.transaction.Transaction;
import javax.transaction.TransactionManager;
import org.jboss.as.cmp.bridge.SelectorBridge;
import org.jboss.as.cmp.component.CmpEntityBeanComponent;
import org.jboss.as.cmp.context.CmpEntityBeanContext;
import org.jboss.as.cmp.jdbc.JDBCQueryCommand;
import org.jboss.as.cmp.jdbc.JDBCStoreManager;
import org.jboss.as.cmp.jdbc.metadata.JDBCQueryMetaData;

public class JDBCSelectorBridge
implements SelectorBridge {
    private final JDBCQueryMetaData queryMetaData;
    private final JDBCStoreManager manager;
    private TransactionManager tm;
    private boolean syncBeforeSelect;

    public JDBCSelectorBridge(JDBCStoreManager manager, JDBCQueryMetaData queryMetaData) {
        this.queryMetaData = queryMetaData;
        this.manager = manager;
        CmpEntityBeanComponent component = manager.getComponent();
        this.tm = component.getTransactionManager();
        this.syncBeforeSelect = !manager.getCmpConfig().isSyncOnCommitOnly();
    }

    @Override
    public Object invoke(CmpEntityBeanContext ctx, Method method, Object[] args) throws Exception {
        Transaction tx;
        Transaction transaction = tx = ctx != null ? ctx.getTransaction() : this.tm.getTransaction();
        if (this.syncBeforeSelect) {
            this.manager.getComponent().synchronizeEntitiesWithinTransaction(tx);
        }
        return this.execute(ctx, args);
    }

    @Override
    public String getSelectorName() {
        return this.queryMetaData.getMethod().getName();
    }

    @Override
    public Method getMethod() {
        return this.queryMetaData.getMethod();
    }

    private Class getReturnType() {
        return this.queryMetaData.getMethod().getReturnType();
    }

    @Override
    public Object execute(CmpEntityBeanContext ctx, Object[] args) throws FinderException {
        Collection retVal;
        Method method = this.getMethod();
        try {
            JDBCQueryCommand query = this.manager.getQueryManager().getQueryCommand(method);
            final CmpEntityBeanComponent selectedComponent = query.getSelectManager().getComponent();
            JDBCQueryCommand.EntityProxyFactory factory = new JDBCQueryCommand.EntityProxyFactory(){

                @Override
                public Object getEntityObject(Object primaryKey) {
                    return JDBCSelectorBridge.this.queryMetaData.isResultTypeMappingLocal() && selectedComponent.getLocalHomeClass() != null ? selectedComponent.getEjbLocalObject(primaryKey) : selectedComponent.getEJBObject(primaryKey);
                }
            };
            retVal = query.execute(method, args, null, factory);
        }
        catch (FinderException e) {
            throw e;
        }
        catch (EJBException e) {
            throw e;
        }
        catch (Exception e) {
            throw new EJBException("Error in " + this.getSelectorName(), e);
        }
        if (!Collection.class.isAssignableFrom(this.getReturnType())) {
            if (retVal.size() == 0) {
                throw new ObjectNotFoundException();
            }
            if (retVal.size() > 1) {
                throw new FinderException(this.getSelectorName() + " returned " + retVal.size() + " objects");
            }
            Object o = retVal.iterator().next();
            if (o == null && method.getReturnType().isPrimitive()) {
                throw new FinderException("Cannot return null as a value of primitive type " + method.getReturnType().getName());
            }
            return o;
        }
        if (Set.class.isAssignableFrom(this.getReturnType())) {
            return new HashSet(retVal);
        }
        return retVal;
    }
}

