/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.cmp.jdbc;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import javax.ejb.CreateException;
import javax.ejb.DuplicateKeyException;
import org.jboss.as.cmp.context.CmpEntityBeanContext;
import org.jboss.as.cmp.jdbc.JDBCAbstractCreateCommand;
import org.jboss.as.cmp.jdbc.JDBCStoreManager;
import org.jboss.as.cmp.jdbc.JDBCUtil;
import org.jboss.as.cmp.jdbc.SQLUtil;

public abstract class JDBCInsertPKCreateCommand
extends JDBCAbstractCreateCommand {
    protected String existsSQL;

    @Override
    public void init(JDBCStoreManager manager) {
        super.init(manager);
        if (this.exceptionProcessor == null) {
            this.initExistsSQL();
        }
    }

    protected void initExistsSQL() {
        StringBuffer sql = new StringBuffer(300);
        sql.append("SELECT ").append("COUNT(*)").append(" FROM ").append(this.entity.getQualifiedTableName()).append(" WHERE ");
        SQLUtil.getWhereClause(this.entity.getPrimaryKeyFields(), sql);
        this.existsSQL = sql.toString();
        if (this.debug) {
            this.log.debug((Object)("Entity Exists SQL: " + this.existsSQL));
        }
    }

    @Override
    protected void beforeInsert(CmpEntityBeanContext ctx) throws CreateException {
        if (this.existsSQL != null) {
            ResultSet rs;
            PreparedStatement ps;
            Connection c;
            block7: {
                c = null;
                ps = null;
                rs = null;
                try {
                    if (this.debug) {
                        this.log.debug((Object)("Executing SQL: " + this.existsSQL));
                    }
                    c = this.entity.getDataSource().getConnection();
                    ps = c.prepareStatement(this.existsSQL);
                    Object pk = this.entity.extractPrimaryKeyFromInstance(ctx);
                    this.entity.setPrimaryKeyParameters(ps, 1, pk);
                    rs = ps.executeQuery();
                    if (!rs.next()) {
                        throw new CreateException("Error checking if entity with primary pk " + pk + "exists: SQL returned no rows");
                    }
                    if (rs.getInt(1) <= 0) break block7;
                    throw new DuplicateKeyException("Entity with primary key " + pk + " already exists");
                }
                catch (SQLException e) {
                    try {
                        this.log.error((Object)"Error checking if entity exists", (Throwable)e);
                        throw new CreateException("Error checking if entity exists:" + e);
                    }
                    catch (Throwable throwable) {
                        JDBCUtil.safeClose(rs);
                        JDBCUtil.safeClose(ps);
                        JDBCUtil.safeClose(c);
                        throw throwable;
                    }
                }
            }
            JDBCUtil.safeClose(rs);
            JDBCUtil.safeClose(ps);
            JDBCUtil.safeClose(c);
        }
    }
}

