/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.cmp.jdbc.bridge;

import java.lang.reflect.Field;
import javax.ejb.EJBException;
import org.jboss.as.cmp.context.CmpEntityBeanContext;
import org.jboss.as.cmp.jdbc.CMPFieldStateFactory;
import org.jboss.as.cmp.jdbc.JDBCContext;
import org.jboss.as.cmp.jdbc.JDBCStoreManager;
import org.jboss.as.cmp.jdbc.JDBCType;
import org.jboss.as.cmp.jdbc.bridge.JDBCAbstractCMPFieldBridge;
import org.jboss.as.cmp.jdbc.bridge.JDBCCMRFieldBridge;
import org.jboss.as.cmp.jdbc.bridge.JDBCEntityBridge;
import org.jboss.as.cmp.jdbc.metadata.JDBCCMPFieldMetaData;

public class JDBCCMP2xFieldBridge
extends JDBCAbstractCMPFieldBridge {
    private final String columnName;
    private final JDBCCMP2xFieldBridge cmpFieldIAmMappedTo;
    private ChainLink cmrChainLink;

    public JDBCCMP2xFieldBridge(JDBCStoreManager manager, JDBCCMPFieldMetaData metadata) {
        super(manager, metadata);
        this.cmpFieldIAmMappedTo = null;
        this.columnName = metadata.getColumnName();
    }

    public JDBCCMP2xFieldBridge(JDBCStoreManager manager, JDBCCMPFieldMetaData metadata, CMPFieldStateFactory stateFactory, boolean checkDirtyAfterGet) {
        this(manager, metadata);
        this.stateFactory = stateFactory;
        this.checkDirtyAfterGet = checkDirtyAfterGet;
    }

    public JDBCCMP2xFieldBridge(JDBCCMP2xFieldBridge cmpField, CMPFieldStateFactory stateFactory, boolean checkDirtyAfterGet) {
        this((JDBCStoreManager)cmpField.getManager(), cmpField.getFieldName(), cmpField.getFieldType(), cmpField.getJDBCType(), cmpField.isReadOnly(), cmpField.getReadTimeOut(), cmpField.getPrimaryKeyClass(), cmpField.getPrimaryKeyField(), cmpField, null, cmpField.getColumnName());
        this.stateFactory = stateFactory;
        this.checkDirtyAfterGet = checkDirtyAfterGet;
    }

    public JDBCCMP2xFieldBridge(JDBCStoreManager manager, JDBCCMPFieldMetaData metadata, JDBCType jdbcType) {
        super(manager, metadata, jdbcType);
        this.cmpFieldIAmMappedTo = null;
        this.columnName = metadata.getColumnName();
    }

    public JDBCCMP2xFieldBridge(JDBCStoreManager manager, String fieldName, Class fieldType, JDBCType jdbcType, boolean readOnly, long readTimeOut, Class primaryKeyClass, Field primaryKeyField, JDBCCMP2xFieldBridge cmpFieldIAmMappedTo, JDBCCMRFieldBridge myCMRField, String columnName) {
        super(manager, fieldName, fieldType, jdbcType, readOnly, readTimeOut, primaryKeyClass, primaryKeyField, cmpFieldIAmMappedTo.getFieldIndex(), cmpFieldIAmMappedTo.getTableIndex(), cmpFieldIAmMappedTo.checkDirtyAfterGet, cmpFieldIAmMappedTo.stateFactory);
        this.cmpFieldIAmMappedTo = cmpFieldIAmMappedTo;
        if (myCMRField != null) {
            this.cmrChainLink = new CMRChainLink(myCMRField);
            cmpFieldIAmMappedTo.addCMRChainLink(this.cmrChainLink);
        }
        this.columnName = columnName;
    }

    public JDBCCMP2xFieldBridge getCmpFieldIAmMappedTo() {
        return this.cmpFieldIAmMappedTo;
    }

    public ChainLink getCmrChainLink() {
        return this.cmrChainLink;
    }

    public boolean isFKFieldMappedToCMPField() {
        return this.cmpFieldIAmMappedTo != null && this.cmrChainLink != null;
    }

    public String getColumnName() {
        return this.columnName;
    }

    @Override
    public Object getInstanceValue(CmpEntityBeanContext ctx) {
        FieldState fieldState = this.getLoadedState(ctx);
        return fieldState.getValue();
    }

    @Override
    public void setInstanceValue(CmpEntityBeanContext ctx, Object value) {
        FieldState fieldState = this.getFieldState(ctx);
        if (this.cmpFieldIAmMappedTo != null && this.cmpFieldIAmMappedTo.isPrimaryKeyMember()) {
            if (value != null) {
                if (fieldState.isLoaded() && fieldState.isValueChanged(value)) {
                    throw new IllegalStateException("New value [" + value + "] of a foreign key field " + this.getFieldName() + " changed the value of a primary key field " + this.cmpFieldIAmMappedTo.getFieldName() + "[" + fieldState.value + "]");
                }
                fieldState.setValue(value);
            }
        } else {
            if (this.cmrChainLink != null && JDBCEntityBridge.isEjbCreateDone(ctx) && fieldState.isLoaded() && fieldState.isValueChanged(value)) {
                this.cmrChainLink.execute(ctx, fieldState, value);
            }
            fieldState.setValue(value);
        }
        fieldState.setLoaded();
    }

    @Override
    public void lockInstanceValue(CmpEntityBeanContext ctx) {
        this.getFieldState(ctx).lockValue();
    }

    @Override
    public boolean isLoaded(CmpEntityBeanContext ctx) {
        return this.getFieldState(ctx).isLoaded();
    }

    @Override
    public boolean isDirty(CmpEntityBeanContext ctx) {
        return !this.primaryKeyMember && !this.readOnly && this.getFieldState(ctx).isDirty();
    }

    @Override
    public void setClean(CmpEntityBeanContext ctx) {
        FieldState fieldState = this.getFieldState(ctx);
        fieldState.setClean();
        if (this.readOnly && this.readTimeOut != -1L) {
            fieldState.lastRead = System.currentTimeMillis();
        }
    }

    @Override
    public void resetPersistenceContext(CmpEntityBeanContext ctx) {
        JDBCContext jdbcCtx;
        FieldState fieldState;
        if (this.isReadTimedOut(ctx) && (fieldState = (FieldState)(jdbcCtx = (JDBCContext)ctx.getPersistenceContext()).getFieldState(this.jdbcContextIndex)) != null) {
            fieldState.reset();
        }
    }

    @Override
    public boolean isReadTimedOut(CmpEntityBeanContext ctx) {
        if (!this.readOnly) {
            return true;
        }
        if (this.readTimeOut == -1L) {
            return false;
        }
        long readInterval = System.currentTimeMillis() - this.getFieldState(ctx).lastRead;
        return readInterval >= this.readTimeOut;
    }

    @Override
    public Object getLockedValue(CmpEntityBeanContext ctx) {
        return this.getLoadedState(ctx).getLockedValue();
    }

    public void updateState(CmpEntityBeanContext ctx, Object value) {
        this.getFieldState(ctx).updateState(value);
    }

    @Override
    protected void setDirtyAfterGet(CmpEntityBeanContext ctx) {
        this.getFieldState(ctx).setCheckDirty();
    }

    private FieldState getLoadedState(CmpEntityBeanContext ctx) {
        FieldState fieldState = this.getFieldState(ctx);
        if (!fieldState.isLoaded()) {
            this.manager.loadField(this, ctx);
            if (!fieldState.isLoaded()) {
                throw new EJBException("Could not load field value: " + this.getFieldName());
            }
        }
        return fieldState;
    }

    private void addCMRChainLink(ChainLink nextCMRChainLink) {
        if (this.cmrChainLink == null) {
            this.cmrChainLink = new DummyChainLink();
        }
        this.cmrChainLink.setNextLink(nextCMRChainLink);
    }

    private FieldState getFieldState(CmpEntityBeanContext ctx) {
        JDBCContext jdbcCtx = (JDBCContext)ctx.getPersistenceContext();
        FieldState fieldState = (FieldState)jdbcCtx.getFieldState(this.jdbcContextIndex);
        if (fieldState == null) {
            fieldState = new FieldState(jdbcCtx);
            jdbcCtx.setFieldState(this.jdbcContextIndex, fieldState);
        }
        return fieldState;
    }

    private static class DummyChainLink
    extends ChainLink {
        private DummyChainLink() {
        }

        @Override
        public void doExecute(ChainLink originator, CmpEntityBeanContext ctx, FieldState fieldState, Object newValue) {
            if (originator != this.getNextLink()) {
                this.getNextLink().doExecute(originator, ctx, fieldState, newValue);
            }
            fieldState.setValue(newValue);
        }
    }

    private static class CMRChainLink
    extends ChainLink {
        private final JDBCCMRFieldBridge cmrField;

        public CMRChainLink(JDBCCMRFieldBridge cmrField) {
            this.cmrField = cmrField;
        }

        @Override
        public void doExecute(ChainLink originator, CmpEntityBeanContext ctx, FieldState fieldState, Object newValue) {
            Object oldRelatedId = this.cmrField.getRelatedIdFromContext(ctx);
            if (originator != this.getNextLink()) {
                this.getNextLink().doExecute(originator, ctx, fieldState, newValue);
            }
            fieldState.setValue(newValue);
            Object newRelatedId = this.cmrField.getRelatedIdFromContext(ctx);
            if (oldRelatedId != null) {
                this.destroyRelations(oldRelatedId, ctx);
            }
            if (newRelatedId != null) {
                this.createRelations(newRelatedId, ctx);
            }
        }

        private void createRelations(Object newRelatedId, CmpEntityBeanContext ctx) {
            try {
                if (this.cmrField.isForeignKeyValid(newRelatedId)) {
                    this.cmrField.createRelationLinks(ctx, newRelatedId, false);
                } else {
                    this.cmrField.setForeignKey(ctx, newRelatedId);
                    if (ctx.getPrimaryKey() != null) {
                        JDBCCMRFieldBridge relatedCMRField = (JDBCCMRFieldBridge)this.cmrField.getRelatedCMRField();
                        relatedCMRField.addRelatedPKWaitingForMyPK(newRelatedId, ctx.getPrimaryKey());
                    }
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }

        private void destroyRelations(Object oldRelatedId, CmpEntityBeanContext ctx) {
            JDBCCMRFieldBridge relatedCMRField = (JDBCCMRFieldBridge)this.cmrField.getRelatedCMRField();
            relatedCMRField.removeRelatedPKWaitingForMyPK(oldRelatedId, ctx.getPrimaryKey());
            try {
                if (this.cmrField.isForeignKeyValid(oldRelatedId)) {
                    this.cmrField.destroyRelationLinks(ctx, oldRelatedId, true, false);
                }
            }
            catch (Exception e) {
                // empty catch block
            }
        }
    }

    private static abstract class ChainLink {
        private ChainLink nextLink = this;

        public void setNextLink(ChainLink nextLink) {
            nextLink.nextLink = this.nextLink;
            this.nextLink = nextLink;
        }

        public ChainLink getNextLink() {
            return this.nextLink;
        }

        public void execute(CmpEntityBeanContext ctx, FieldState fieldState, Object newValue) {
            this.nextLink.doExecute(this, ctx, fieldState, newValue);
        }

        protected abstract void doExecute(ChainLink var1, CmpEntityBeanContext var2, FieldState var3, Object var4);
    }

    private class FieldState {
        private JDBCEntityBridge.EntityState entityState;
        private Object value;
        private Object state;
        private Object lockedValue;
        private long lastRead = -1L;

        public FieldState(JDBCContext jdbcCtx) {
            this.entityState = jdbcCtx.getEntityState();
        }

        public Object getValue() {
            return this.value;
        }

        public void setValue(Object newValue) {
            this.value = newValue;
            this.setCheckDirty();
        }

        private void setCheckDirty() {
            this.entityState.setCheckDirty(JDBCCMP2xFieldBridge.this.tableIndex);
        }

        public boolean isLoaded() {
            return this.entityState.isLoaded(JDBCCMP2xFieldBridge.this.tableIndex);
        }

        public void setLoaded() {
            this.entityState.setLoaded(JDBCCMP2xFieldBridge.this.tableIndex);
        }

        public boolean isDirty() {
            return this.isLoaded() && !JDBCCMP2xFieldBridge.this.stateFactory.isStateValid(this.state, this.value);
        }

        public boolean isValueChanged(Object newValue) {
            return this.value == null ? newValue != null : !this.value.equals(newValue);
        }

        public void setClean() {
            this.entityState.setClean(JDBCCMP2xFieldBridge.this.tableIndex);
            this.updateState(this.value);
        }

        private void updateState(Object value) {
            this.state = JDBCCMP2xFieldBridge.this.stateFactory.getFieldState(value);
            this.lockedValue = value;
        }

        public void reset() {
            this.value = null;
            this.state = null;
            this.lastRead = -1L;
            this.entityState.resetFlags(JDBCCMP2xFieldBridge.this.tableIndex);
        }

        public void lockValue() {
            if (this.entityState.lockValue(JDBCCMP2xFieldBridge.this.tableIndex)) {
                this.lockedValue = this.value;
            }
        }

        public Object getLockedValue() {
            return this.lockedValue;
        }
    }
}

