/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.cmp.keygenerator.hilo;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import javax.sql.DataSource;
import javax.transaction.TransactionManager;
import org.jboss.as.cmp.jdbc.JDBCUtil;
import org.jboss.as.cmp.jdbc.SQLUtil;
import org.jboss.as.cmp.keygenerator.KeyGenerator;
import org.jboss.as.cmp.keygenerator.KeyGeneratorFactory;
import org.jboss.as.cmp.keygenerator.hilo.HiLoKeyGenerator;
import org.jboss.logging.Logger;
import org.jboss.msc.inject.Injector;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.StartContext;
import org.jboss.msc.service.StartException;
import org.jboss.msc.service.StopContext;
import org.jboss.msc.value.InjectedValue;

public class HiLoKeyGeneratorFactory
implements KeyGeneratorFactory,
Service<KeyGeneratorFactory> {
    public static final ServiceName SERVICE_NAME = ServiceName.JBOSS.append(new String[]{"cmp", "keygen", HiLoKeyGeneratorFactory.class.getSimpleName()});
    private static final Logger log = Logger.getLogger(HiLoKeyGeneratorFactory.class);
    private final InjectedValue<DataSource> ds = new InjectedValue();
    private final InjectedValue<TransactionManager> tm = new InjectedValue();
    private String tableName;
    private String sequenceColumn;
    private String sequenceName;
    private String idColumnName;
    private String createTableDdl;
    private String selectHiSql;
    private long blockSize;
    private boolean createTable = true;
    private boolean dropTable;

    public synchronized void start(StartContext context) throws StartException {
        try {
            this.initSequence(this.tableName, this.sequenceColumn, this.sequenceName, this.idColumnName);
        }
        catch (SQLException e) {
            throw new StartException("Failed to start HiLoKeyGeneratorFactory", (Throwable)e);
        }
    }

    public synchronized void stop(StopContext context) {
        if (this.dropTable) {
            try {
                this.dropTableIfExists(this.tableName);
            }
            catch (SQLException e) {
                throw new IllegalStateException("Failed to stop HiLoKeyGeneratorFactory", e);
            }
        }
    }

    public KeyGeneratorFactory getValue() throws IllegalStateException, IllegalArgumentException {
        return this;
    }

    @Override
    public KeyGenerator getKeyGenerator() throws Exception {
        return new HiLoKeyGenerator((DataSource)this.ds.getValue(), this.tableName, this.sequenceColumn, this.sequenceName, this.idColumnName, this.selectHiSql, this.blockSize, (TransactionManager)this.tm.getValue());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initSequence(String tableName, String sequenceColumn, String sequenceName, String idColumnName) throws SQLException {
        ResultSet rs;
        Statement st;
        Connection con;
        block8: {
            if (this.createTable) {
                this.createTableIfNotExists(tableName);
            }
            con = null;
            st = null;
            rs = null;
            try {
                String sql = "select " + idColumnName + " from " + tableName + " where " + sequenceColumn + "='" + sequenceName + "'";
                log.debug((Object)("Executing SQL: " + sql));
                con = ((DataSource)this.ds.getValue()).getConnection();
                st = con.createStatement();
                rs = st.executeQuery(sql);
                if (!rs.next()) {
                    sql = "insert into " + tableName + "(" + sequenceColumn + ", " + idColumnName + ") values ('" + sequenceName + "', 0)";
                    log.debug((Object)("Executing SQL: " + sql));
                    Statement insertSt = con.createStatement();
                    try {
                        int i = insertSt.executeUpdate(sql);
                        if (i != 1) {
                            throw new SQLException("Expected one updated row but got: " + i);
                        }
                        break block8;
                    }
                    finally {
                        JDBCUtil.safeClose(insertSt);
                    }
                }
                HiLoKeyGenerator.setHighestHi(rs.getLong(1));
            }
            catch (Throwable throwable) {
                JDBCUtil.safeClose(rs);
                JDBCUtil.safeClose(st);
                JDBCUtil.safeClose(con);
                throw throwable;
            }
        }
        JDBCUtil.safeClose(rs);
        JDBCUtil.safeClose(st);
        JDBCUtil.safeClose(con);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createTableIfNotExists(String tableName) throws SQLException {
        Connection con = null;
        Statement st = null;
        try {
            if (!SQLUtil.tableExists(tableName, (DataSource)this.ds.getValue())) {
                log.debug((Object)("Executing DDL: " + this.createTableDdl));
                con = ((DataSource)this.ds.getValue()).getConnection();
                st = con.createStatement();
                st.executeUpdate(this.createTableDdl);
            }
        }
        finally {
            JDBCUtil.safeClose(st);
            JDBCUtil.safeClose(con);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void dropTableIfExists(String tableName) throws SQLException {
        Connection con = null;
        Statement st = null;
        try {
            if (SQLUtil.tableExists(tableName, (DataSource)this.ds.getValue())) {
                String ddl = "drop table " + tableName;
                log.debug((Object)("Executing DDL: " + ddl));
                con = ((DataSource)this.ds.getValue()).getConnection();
                st = con.createStatement();
                st.executeUpdate(ddl);
            }
        }
        finally {
            JDBCUtil.safeClose(st);
            JDBCUtil.safeClose(con);
        }
    }

    public void setTableName(String tableName) {
        this.tableName = tableName;
    }

    public void setSequenceColumn(String sequenceColumn) {
        this.sequenceColumn = sequenceColumn;
    }

    public void setSequenceName(String sequenceName) {
        this.sequenceName = sequenceName;
    }

    public void setIdColumnName(String idColumnName) {
        this.idColumnName = idColumnName;
    }

    public void setCreateTableDdl(String createTableDdl) {
        this.createTableDdl = createTableDdl;
    }

    public void setSelectHiSql(String selectHiSql) {
        this.selectHiSql = selectHiSql;
    }

    public void setBlockSize(long blockSize) {
        this.blockSize = blockSize;
    }

    public void setCreateTable(boolean createTable) {
        this.createTable = createTable;
    }

    public void setDropTable(boolean dropTable) {
        this.dropTable = dropTable;
    }

    public Injector<TransactionManager> getTransactionManagerInjector() {
        return this.tm;
    }

    public Injector<DataSource> getDataSourceInjector() {
        return this.ds;
    }
}

