/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.cmp.jdbc.metadata;

import java.util.Date;
import org.jboss.as.cmp.jdbc.metadata.JDBCCMPFieldMetaData;
import org.jboss.as.cmp.jdbc.metadata.JDBCEntityMetaData;
import org.jboss.as.cmp.jdbc.metadata.parser.ParsedCmpField;
import org.jboss.as.cmp.jdbc.metadata.parser.ParsedOptimisticLocking;

public final class JDBCOptimisticLockingMetaData {
    private final LockingStrategy lockingStrategy;
    private final String groupName;
    private final JDBCCMPFieldMetaData lockingField;
    private final String keyGeneratorFactory;

    public JDBCOptimisticLockingMetaData(JDBCEntityMetaData entity, ParsedOptimisticLocking optimisticLocking) {
        this.lockingStrategy = optimisticLocking.getLockingStrategy();
        switch (this.lockingStrategy) {
            case FIELD_GROUP_STRATEGY: {
                this.groupName = optimisticLocking.getGroupName();
                this.lockingField = null;
                this.keyGeneratorFactory = null;
                break;
            }
            case MODIFIED_STRATEGY: {
                this.groupName = null;
                this.lockingField = null;
                this.keyGeneratorFactory = null;
                break;
            }
            case READ_STRATEGY: {
                this.groupName = null;
                this.lockingField = null;
                this.keyGeneratorFactory = null;
                break;
            }
            case VERSION_COLUMN_STRATEGY: {
                if (optimisticLocking.getLockingField().getFieldType() != null) {
                    throw new RuntimeException("field-type is not allowed for version column. It is implicitly set to java.lang.Long.");
                }
                this.lockingField = this.constructLockingField(entity, optimisticLocking.getLockingField());
                this.groupName = null;
                this.keyGeneratorFactory = null;
                break;
            }
            case TIMESTAMP_COLUMN_STRATEGY: {
                if (optimisticLocking.getLockingField().getFieldType() != null) {
                    throw new RuntimeException("field-type is not allowed for timestamp column. It is implicitly set to java.util.Date.");
                }
                this.lockingField = this.constructLockingField(entity, optimisticLocking.getLockingField());
                this.groupName = null;
                this.keyGeneratorFactory = null;
                break;
            }
            case KEYGENERATOR_COLUMN_STRATEGY: {
                this.lockingField = this.constructLockingField(entity, optimisticLocking.getLockingField());
                this.groupName = null;
                this.keyGeneratorFactory = optimisticLocking.getKeyGeneratorFactory();
                break;
            }
            default: {
                throw new RuntimeException("Unexpected error: entity " + entity.getName() + " has unkown/incorrect optimistic locking configuration. -- " + (Object)((Object)this.lockingStrategy));
            }
        }
    }

    private JDBCCMPFieldMetaData constructLockingField(JDBCEntityMetaData entity, ParsedCmpField lockingField) {
        String sqlType;
        int jdbcType;
        String columnName;
        String fieldName;
        String string = fieldName = lockingField != null ? lockingField.getFieldName() : null;
        if (fieldName == null || fieldName.trim().length() < 1) {
            fieldName = this.lockingStrategy == LockingStrategy.VERSION_COLUMN_STRATEGY ? "version_lock" : (this.lockingStrategy == LockingStrategy.TIMESTAMP_COLUMN_STRATEGY ? "timestamp_lock" : "generated_lock");
        }
        String string2 = columnName = lockingField != null ? lockingField.getColumnName() : null;
        if (columnName == null || columnName.trim().length() < 1) {
            columnName = this.lockingStrategy == LockingStrategy.VERSION_COLUMN_STRATEGY ? "version_lock" : (this.lockingStrategy == LockingStrategy.TIMESTAMP_COLUMN_STRATEGY ? "timestamp_lock" : "generated_lock");
        }
        Class fieldType = null;
        if (this.lockingStrategy == LockingStrategy.VERSION_COLUMN_STRATEGY) {
            fieldType = Long.class;
        } else if (this.lockingStrategy == LockingStrategy.TIMESTAMP_COLUMN_STRATEGY) {
            fieldType = Date.class;
        }
        if (lockingField != null && lockingField.getFieldType() != null) {
            fieldType = lockingField.getFieldType();
        }
        if (lockingField != null && lockingField.getJdbcType() != null) {
            jdbcType = lockingField.getJdbcType();
            sqlType = lockingField.getSqlType();
        } else {
            jdbcType = Integer.MIN_VALUE;
            sqlType = null;
        }
        return new JDBCCMPFieldMetaData(entity, fieldName, fieldType, columnName, jdbcType, sqlType);
    }

    public LockingStrategy getLockingStrategy() {
        return this.lockingStrategy;
    }

    public String getGroupName() {
        return this.groupName;
    }

    public JDBCCMPFieldMetaData getLockingField() {
        return this.lockingField;
    }

    public String getKeyGeneratorFactory() {
        return this.keyGeneratorFactory;
    }

    public static enum LockingStrategy {
        FIELD_GROUP_STRATEGY,
        MODIFIED_STRATEGY,
        READ_STRATEGY,
        VERSION_COLUMN_STRATEGY,
        TIMESTAMP_COLUMN_STRATEGY,
        KEYGENERATOR_COLUMN_STRATEGY;

    }
}

